/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.templates;

import com.android.ide.common.repository.GradleCoordinate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum SupportLibrary {
    SUPPORT_ANNOTATIONS("com.android.support", "support-annotations"),
    SUPPORT_V4("com.android.support", "support-v4"),
    SUPPORT_V13("com.android.support", "support-v13"),
    APP_COMPAT_V7("com.android.support", "appcompat-v7"),
    SUPPORT_VECTOR_DRAWABLE("com.android.support", "support-vector-drawable"),
    DESIGN("com.android.support", "design"),
    GRID_LAYOUT_V7("com.android.support", "gridlayout-v7"),
    MEDIA_ROUTER_V7("com.android.support", "mediarouter-v7"),
    CARDVIEW_V7("com.android.support", "cardview-v7"),
    PALETTE_V7("com.android.support", "palette-v7"),
    LEANBACK_V17("com.android.support", "leanback-v17"),
    RECYCLERVIEW_V7("com.android.support", "recyclerview-v7"),
    TEST_RUNNER("com.android.support.test", "runner"),
    ESPRESSO_CORE("com.android.support.test.espresso", "espresso-core"),
    ESPRESSO_CONTRIB("com.android.support.test.espresso", "espresso-contrib"),
    PLAY_SERVICES("com.google.android.gms", "play-services"),
    PLAY_SERVICES_ADS("com.google.android.gms", "play-services-ads"),
    PLAY_SERVICES_WEARABLE("com.google.android.gms", "play-services-wearable"),
    PLAY_SERVICES_MAPS("com.google.android.gms", "play-services-maps"),
    WEARABLE("com.google.android.support", "wearable");

    private final String myGroupId;
    private final String myArtifactId;

    @Nullable
    public static SupportLibrary forGradleCoordinate(@NotNull GradleCoordinate coordinate) {
        if (coordinate == null) {
            SupportLibrary.$$$reportNull$$$0(0);
        }
        if (coordinate.getGroupId() == null || coordinate.getArtifactId() == null) {
            return null;
        }
        return SupportLibrary.find(coordinate.getGroupId(), coordinate.getArtifactId());
    }

    @Nullable
    public static SupportLibrary find(@NotNull String groupId, @NotNull String artifactId) {
        if (groupId == null) {
            SupportLibrary.$$$reportNull$$$0(1);
        }
        if (artifactId == null) {
            SupportLibrary.$$$reportNull$$$0(2);
        }
        for (SupportLibrary library : SupportLibrary.values()) {
            if (!library.getGroupId().equals(groupId) || !library.getArtifactId().equals(artifactId)) continue;
            return library;
        }
        return null;
    }

    private SupportLibrary(String groupId, String artifactId) {
        this.myGroupId = groupId;
        this.myArtifactId = artifactId;
    }

    public String getGroupId() {
        return this.myGroupId;
    }

    public String getArtifactId() {
        return this.myArtifactId;
    }

    @NotNull
    public GradleCoordinate getGradleCoordinate(@NotNull String revision) {
        if (revision == null) {
            SupportLibrary.$$$reportNull$$$0(3);
        }
        GradleCoordinate gradleCoordinate = new GradleCoordinate(this.myGroupId, this.myArtifactId, new GradleCoordinate.RevisionComponent[]{new GradleCoordinate.StringComponent(revision)});
        if (gradleCoordinate == null) {
            SupportLibrary.$$$reportNull$$$0(4);
        }
        return gradleCoordinate;
    }

    public String toString() {
        return this.myGroupId + ":" + this.myArtifactId;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coordinate";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactId";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revision";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/templates/SupportLibrary";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/templates/SupportLibrary";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getGradleCoordinate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "forGradleCoordinate";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "find";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getGradleCoordinate";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

