/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.templates;

import com.android.ide.common.xml.XmlFormatPreferences;
import com.android.manifmerger.ManifestMerger2;
import com.android.manifmerger.MergingReport;
import com.android.manifmerger.XmlDocument;
import com.android.resources.ResourceFolderType;
import com.android.tools.idea.templates.recipe.RenderingContext;
import com.android.utils.ILogger;
import com.android.utils.StdLogger;
import com.android.utils.XmlUtils;
import com.google.common.base.Charsets;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.lang.Language;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlComment;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagChild;
import com.intellij.psi.xml.XmlText;
import com.intellij.util.SystemProperties;
import freemarker.template.TemplateException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;

public class RecipeMergeUtils {
    private static final Logger LOG = Logger.getInstance(RecipeMergeUtils.class);
    private static final String MERGE_ATTR_STRATEGY = "templateMergeStrategy";
    private static final String MERGE_ATTR_STRATEGY_REPLACE = "replace";
    private static final String MERGE_ATTR_STRATEGY_PRESERVE = "preserve";
    private static final Pattern INCLUDE_PATTERN = Pattern.compile("(^|\\n)\\s*include +(':[^']+', *)*':[^']+'");

    public static String mergeGradleSettingsFile(@NotNull String source, @NotNull String dest) throws IOException, TemplateException {
        if (source == null) {
            RecipeMergeUtils.$$$reportNull$$$0(0);
        }
        if (dest == null) {
            RecipeMergeUtils.$$$reportNull$$$0(1);
        }
        StringBuilder contents = new StringBuilder(dest);
        for (String line : Splitter.on((char)'\n').omitEmptyStrings().trimResults().split((CharSequence)source)) {
            if (!line.startsWith("include")) {
                throw new RuntimeException("When merging settings.gradle files, only include directives can be merged.");
            }
            line = line.substring("include".length()).trim();
            Matcher matcher = INCLUDE_PATTERN.matcher(contents);
            if (matcher.find()) {
                contents.insert(matcher.end(), ", " + line);
                continue;
            }
            contents.insert(0, "include " + line + SystemProperties.getLineSeparator());
        }
        return contents.toString();
    }

    @Nullable
    public static String mergeXml(@NotNull RenderingContext context, String sourceXml, String targetXml, File targetFile) {
        boolean ok;
        String contents;
        String fileName;
        if (context == null) {
            RecipeMergeUtils.$$$reportNull$$$0(2);
        }
        if ((fileName = targetFile.getName()).equals("AndroidManifest.xml")) {
            Document currentDocument = XmlUtils.parseDocumentSilently((String)targetXml, (boolean)true);
            assert (currentDocument != null) : targetXml + " failed to parse";
            Document fragment = XmlUtils.parseDocumentSilently((String)sourceXml, (boolean)true);
            assert (fragment != null) : sourceXml + " failed to parse";
            contents = RecipeMergeUtils.mergeManifest(context.getModuleRoot(), targetFile, targetXml, sourceXml);
            ok = contents != null;
        } else {
            String parentFolderName = targetFile.getParentFile().getName();
            ResourceFolderType folderType = ResourceFolderType.getFolderType((String)parentFolderName);
            contents = RecipeMergeUtils.mergeResourceFile(context, targetXml, sourceXml, fileName, folderType);
            boolean bl = ok = contents != null;
        }
        if (!ok) {
            contents = RecipeMergeUtils.wrapWithMergeConflict(targetXml, sourceXml);
            context.getWarnings().add(String.format("Merge conflict for: %1$s this file must be fixed by hand", targetFile.getName()));
        }
        return contents;
    }

    public static String mergeResourceFile(@NotNull RenderingContext context, @NotNull String targetXml, @NotNull String sourceXml, @NotNull String fileName, @Nullable ResourceFolderType folderType) {
        XmlAttribute[] attributes;
        if (context == null) {
            RecipeMergeUtils.$$$reportNull$$$0(3);
        }
        if (targetXml == null) {
            RecipeMergeUtils.$$$reportNull$$$0(4);
        }
        if (sourceXml == null) {
            RecipeMergeUtils.$$$reportNull$$$0(5);
        }
        if (fileName == null) {
            RecipeMergeUtils.$$$reportNull$$$0(6);
        }
        XmlFile targetPsiFile = (XmlFile)PsiFileFactory.getInstance((Project)context.getProject()).createFileFromText("targetFile", (Language)XMLLanguage.INSTANCE, (CharSequence)StringUtil.convertLineSeparators((String)targetXml));
        XmlFile sourcePsiFile = (XmlFile)PsiFileFactory.getInstance((Project)context.getProject()).createFileFromText("sourceFile", (Language)XMLLanguage.INSTANCE, (CharSequence)StringUtil.convertLineSeparators((String)sourceXml));
        XmlTag root = targetPsiFile.getDocument().getRootTag();
        assert (root != null) : "Cannot find XML root in target: " + targetXml;
        for (XmlAttribute attr : attributes = sourcePsiFile.getRootTag().getAttributes()) {
            if (!attr.getNamespacePrefix().equals("xmlns:")) continue;
            root.setAttribute(attr.getName(), attr.getValue());
        }
        ArrayList prependElements = Lists.newArrayList();
        XmlText indent = null;
        if (folderType == ResourceFolderType.VALUES) {
            HashMap old = Maps.newHashMap();
            for (XmlTag xmlTag : root.getSubTags()) {
                old.put(RecipeMergeUtils.getResourceId(xmlTag), xmlTag);
            }
            for (XmlTag xmlTag : sourcePsiFile.getRootTag().getChildren()) {
                XmlTag replace;
                if (xmlTag instanceof XmlComment) {
                    if (indent != null) {
                        prependElements.add(indent);
                    }
                    prependElements.add((XmlTagChild)xmlTag);
                    continue;
                }
                if (xmlTag instanceof XmlText) {
                    indent = (XmlText)xmlTag;
                    continue;
                }
                if (!(xmlTag instanceof XmlTag)) continue;
                XmlTag subTag = xmlTag;
                String mergeStrategy = subTag.getAttributeValue(MERGE_ATTR_STRATEGY);
                subTag.setAttribute(MERGE_ATTR_STRATEGY, null);
                CodeStyleManager.getInstance((Project)context.getProject()).reformat((PsiElement)subTag);
                String name = RecipeMergeUtils.getResourceId(subTag);
                XmlTag xmlTag2 = replace = name != null ? (XmlTag)old.get(name) : null;
                if (replace != null) {
                    if (MERGE_ATTR_STRATEGY_REPLACE.equals(mergeStrategy)) {
                        PsiElement psiElement = replace.replace((PsiElement)xmlTag);
                        if (psiElement.getPrevSibling() instanceof XmlText && prependElements.get(0) instanceof XmlText) {
                            prependElements.remove(0);
                            if (!prependElements.isEmpty()) {
                                prependElements.add(indent);
                            }
                        }
                        for (XmlTagChild element : prependElements) {
                            root.addBefore((PsiElement)element, psiElement);
                        }
                    } else if (!MERGE_ATTR_STRATEGY_PRESERVE.equals(mergeStrategy) && !replace.getText().trim().equals(xmlTag.getText().trim())) {
                        context.getWarnings().add(String.format("Ignoring conflict for the value: %1$s wanted: \"%2$s\" but it already is: \"%3$s\" in the file: %4$s", name, xmlTag.getText(), replace.getText(), fileName));
                    }
                } else {
                    if (indent != null) {
                        prependElements.add(indent);
                    }
                    subTag = root.addSubTag(subTag, false);
                    for (XmlTagChild element : prependElements) {
                        root.addBefore((PsiElement)element, (PsiElement)subTag);
                    }
                }
                prependElements.clear();
            }
        } else {
            for (PsiElement child : sourcePsiFile.getRootTag().getChildren()) {
                if (!(child instanceof XmlTag)) continue;
                root.addSubTag((XmlTag)child, false);
            }
        }
        return targetPsiFile.getText();
    }

    @Nullable
    private static String mergeManifest(@NotNull File moduleRoot, final @NotNull File targetManifest, final @NotNull String targetXml, final @NotNull String mergeText) {
        if (moduleRoot == null) {
            RecipeMergeUtils.$$$reportNull$$$0(7);
        }
        if (targetManifest == null) {
            RecipeMergeUtils.$$$reportNull$$$0(8);
        }
        if (targetXml == null) {
            RecipeMergeUtils.$$$reportNull$$$0(9);
        }
        if (mergeText == null) {
            RecipeMergeUtils.$$$reportNull$$$0(10);
        }
        try {
            boolean isMasterManifest = FileUtil.filesEqual((File)moduleRoot, (File)targetManifest.getParentFile());
            File tempFile2 = new File(targetManifest.getParentFile(), "nevercreated.xml");
            StdLogger logger = new StdLogger(StdLogger.Level.INFO);
            MergingReport mergeReport = ManifestMerger2.newMerger((File)targetManifest, (ILogger)logger, (ManifestMerger2.MergeType)ManifestMerger2.MergeType.APPLICATION).withFeatures(new ManifestMerger2.Invoker.Feature[]{ManifestMerger2.Invoker.Feature.EXTRACT_FQCNS, ManifestMerger2.Invoker.Feature.NO_PLACEHOLDER_REPLACEMENT}).addLibraryManifest(tempFile2).asType(isMasterManifest ? XmlDocument.Type.MAIN : XmlDocument.Type.OVERLAY).withFileStreamProvider(new ManifestMerger2.FileStreamProvider(){

                protected InputStream getInputStream(@NotNull File file) throws FileNotFoundException {
                    if (file == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    String text = FileUtil.filesEqual((File)file, (File)targetManifest) ? targetXml : mergeText;
                    return new ByteArrayInputStream(text.getBytes(Charsets.UTF_8));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/templates/RecipeMergeUtils$1", "getInputStream"));
                }
            }).merge();
            if (mergeReport.getResult().isSuccess()) {
                return mergeReport.getMergedDocument(MergingReport.MergedManifestKind.MERGED);
            }
            return null;
        }
        catch (ManifestMerger2.MergeFailureException e) {
            LOG.warn((Throwable)e);
            return null;
        }
    }

    private static String getResourceId(@NotNull XmlTag tag) {
        String name;
        if (tag == null) {
            RecipeMergeUtils.$$$reportNull$$$0(11);
        }
        if ((name = tag.getAttributeValue("name")) == null) {
            name = tag.getAttributeValue("id");
        }
        return name;
    }

    @NotNull
    private static XmlFormatPreferences createXmlFormatPreferences() {
        XmlFormatPreferences xmlFormatPreferences = XmlFormatPreferences.defaults();
        if (xmlFormatPreferences == null) {
            RecipeMergeUtils.$$$reportNull$$$0(12);
        }
        return xmlFormatPreferences;
    }

    private static String wrapWithMergeConflict(String original, String added) {
        String sep = "\n";
        return "<<<<<<< Original" + sep + original + sep + "=======" + sep + added + ">>>>>>> Added" + sep;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dest";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetXml";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceXml";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleRoot";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetManifest";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mergeText";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/templates/RecipeMergeUtils";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/templates/RecipeMergeUtils";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createXmlFormatPreferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "mergeGradleSettingsFile";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "mergeXml";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "mergeResourceFile";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "mergeManifest";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getResourceId";
                break;
            }
            case 12: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

