/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.templates;

import com.android.tools.idea.templates.FmUtil;
import com.android.tools.idea.templates.TemplateUtils;
import com.android.utils.SdkUtils;
import freemarker.template.SimpleScalar;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateScalarModel;
import freemarker.template.utility.StringUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class FmActivityToLayoutMethod
implements TemplateMethodModelEx {
    public TemplateModel exec(List args) throws TemplateModelException {
        if (args.size() < 1 || args.size() > 2) {
            throw new TemplateModelException("Wrong arguments");
        }
        String activityName = ((TemplateScalarModel)args.get(0)).getAsString();
        String layoutNamePrefix = "activity_";
        if (args.size() > 1) {
            layoutNamePrefix = ((TemplateScalarModel)args.get(1)).getAsString() + "_";
        }
        if (activityName.isEmpty()) {
            return new SimpleScalar("");
        }
        activityName = FmActivityToLayoutMethod.stripActivitySuffix(activityName);
        String name = TemplateUtils.camelCaseToUnderlines(activityName);
        name = StringUtil.replace((String)name, (String)layoutNamePrefix, (String)"", (boolean)false, (boolean)true);
        return new SimpleScalar(layoutNamePrefix + name);
    }

    private static String stripActivitySuffix(@NotNull String activityName) {
        int lastCharIndex;
        if (activityName == null) {
            FmActivityToLayoutMethod.$$$reportNull$$$0(0);
        }
        if (Character.isDigit(activityName.charAt(lastCharIndex = activityName.length() - 1))) {
            for (int i = lastCharIndex - 1; i > 0; --i) {
                if (Character.isDigit(activityName.charAt(i))) continue;
                if (!SdkUtils.endsWith((CharSequence)activityName, (int)(++i), (CharSequence)"Activity")) break;
                return activityName.substring(0, i - "Activity".length()) + activityName.substring(i);
            }
        }
        return FmUtil.stripSuffix(activityName, "Activity", false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "activityName", "com/android/tools/idea/templates/FmActivityToLayoutMethod", "stripActivitySuffix"));
    }
}

