/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.structure.dialog;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ConfigurationError;
import com.intellij.openapi.roots.ui.configuration.ConfigurationErrors;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.util.SystemProperties;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.BaseButtonBehavior;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.TimedDeadzone;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.RoundRectangle2D;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.JViewport;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigurationErrorsComponent
extends JPanel
implements Disposable,
ListDataListener {
    private static final int MAX_ERRORS_TO_SHOW = SystemProperties.getIntProperty((String)"idea.project.structure.max.errors.to.show", (int)100);
    private static final boolean ONE_LINE = true;
    private static final boolean MULTI_LINE = false;
    @NonNls
    private static final String FIX_ACTION_NAME = "FIX";
    @NonNls
    private static final String NAVIGATE_ACTION_NAME = "NAVIGATE";
    private ConfigurationErrorsListModel myConfigurationErrorsListModel;
    private ErrorView myCurrentView;

    public ConfigurationErrorsComponent(@NotNull Project project) {
        if (project == null) {
            ConfigurationErrorsComponent.$$$reportNull$$$0(0);
        }
        this.setLayout(new BorderLayout());
        this.myConfigurationErrorsListModel = new ConfigurationErrorsListModel(project);
        this.myConfigurationErrorsListModel.addListDataListener(this);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                ConfigurationErrorsComponent.this.revalidate();
                ConfigurationErrorsComponent.this.repaint();
            }
        });
        this.ensureCurrentViewIs(true, null);
        Disposer.register((Disposable)this, (Disposable)this.myConfigurationErrorsListModel);
    }

    public void dispose() {
        if (this.myConfigurationErrorsListModel != null) {
            this.myConfigurationErrorsListModel.removeListDataListener(this);
            this.myConfigurationErrorsListModel = null;
        }
    }

    private void ensureCurrentViewIs(boolean oneLine, @Nullable Object data) {
        if (oneLine) {
            if (this.myCurrentView instanceof OneLineErrorComponent) {
                return;
            }
            this.myConfigurationErrorsListModel.setFilter(true, true);
            OneLineErrorComponent c = new OneLineErrorComponent(this.myConfigurationErrorsListModel){

                @Override
                public void onViewChange(Object data) {
                    ConfigurationErrorsComponent.this.ensureCurrentViewIs(false, data);
                }
            };
            if (this.myCurrentView != null) {
                this.remove(this.myCurrentView.self());
                Disposer.dispose((Disposable)this.myCurrentView);
            }
            this.myCurrentView = c;
        } else {
            this.myConfigurationErrorsListModel.setFilter(data == null || !"Ignored".equals(data), data == null || "Ignored".equals(data));
            if (this.myCurrentView instanceof MultiLineErrorComponent) {
                return;
            }
            MultiLineErrorComponent c = new MultiLineErrorComponent(this.myConfigurationErrorsListModel){

                @Override
                public void onViewChange(Object data) {
                    ConfigurationErrorsComponent.this.ensureCurrentViewIs(true, data);
                }
            };
            if (this.myCurrentView != null) {
                this.remove(this.myCurrentView.self());
                Disposer.dispose((Disposable)this.myCurrentView);
            }
            this.myCurrentView = c;
        }
        this.add((Component)this.myCurrentView.self(), "Center");
        this.myCurrentView.updateView();
        UIUtil.adjustWindowToMinimumSize((Window)SwingUtilities.getWindowAncestor(this));
        this.revalidate();
        this.repaint();
    }

    @Override
    public void intervalAdded(ListDataEvent e) {
        this.updateCurrentView();
    }

    @Override
    public void intervalRemoved(ListDataEvent e) {
        this.updateCurrentView();
    }

    @Override
    public void contentsChanged(ListDataEvent e) {
        this.updateCurrentView();
    }

    private void updateCurrentView() {
        if (this.myCurrentView instanceof MultiLineErrorComponent && this.myConfigurationErrorsListModel.getSize() == 0) {
            this.ensureCurrentViewIs(true, null);
        }
        this.myCurrentView.updateView();
    }

    @NotNull
    private static <T> List<T> concat(final @NotNull List<? extends T> list1, final @NotNull List<? extends T> list2) {
        if (list1 == null) {
            ConfigurationErrorsComponent.$$$reportNull$$$0(1);
        }
        if (list2 == null) {
            ConfigurationErrorsComponent.$$$reportNull$$$0(2);
        }
        AbstractList abstractList = new AbstractList<T>(){

            @Override
            public T get(int index) {
                if (index < list1.size()) {
                    return list1.get(index);
                }
                return list2.get(index - list1.size());
            }

            @Override
            public int size() {
                return list1.size() + list2.size();
            }
        };
        if (abstractList == null) {
            ConfigurationErrorsComponent.$$$reportNull$$$0(3);
        }
        return abstractList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list1";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list2";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/structure/dialog/ConfigurationErrorsComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/structure/dialog/ConfigurationErrorsComponent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "concat";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "concat";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ConfigurationErrorsListModel
    extends AbstractListModel
    implements ConfigurationErrors,
    Disposable {
        private MessageBusConnection myConnection;
        private ArrayList<ConfigurationError> myNotIgnoredErrors;
        private List<ConfigurationError> myAllErrors;
        private ArrayList<ConfigurationError> myIgnoredErrors;

        private ConfigurationErrorsListModel(@NotNull Project project) {
            if (project == null) {
                ConfigurationErrorsListModel.$$$reportNull$$$0(0);
            }
            this.myNotIgnoredErrors = new ArrayList();
            this.myIgnoredErrors = new ArrayList();
            this.setFilter(true, true);
            this.myConnection = project.getMessageBus().connect();
            this.myConnection.subscribe(TOPIC, (Object)this);
        }

        public void setFilter(boolean showNotIgnored, boolean showIgnored) {
            this.myAllErrors = showIgnored && showNotIgnored ? ConfigurationErrorsComponent.concat(this.myNotIgnoredErrors, this.myIgnoredErrors) : (showIgnored ? this.myIgnoredErrors : this.myNotIgnoredErrors);
        }

        @Override
        public int getSize() {
            return Math.min(this.myAllErrors.size(), MAX_ERRORS_TO_SHOW);
        }

        @Override
        public Object getElementAt(int index) {
            return this.myAllErrors.get(index);
        }

        public void addError(@NotNull ConfigurationError error) {
            ArrayList<ConfigurationError> targetList;
            if (error == null) {
                ConfigurationErrorsListModel.$$$reportNull$$$0(1);
            }
            if (this.myAllErrors.contains(error)) {
                return;
            }
            ArrayList<ConfigurationError> arrayList = targetList = error.isIgnored() ? this.myIgnoredErrors : this.myNotIgnoredErrors;
            if (targetList.size() < MAX_ERRORS_TO_SHOW) {
                targetList.add(0, error);
                this.fireIntervalAdded(this, 0, 0);
                return;
            }
            int listSize = targetList.size();
            targetList.ensureCapacity(listSize + 1);
            targetList.add(listSize, error);
            if (listSize < MAX_ERRORS_TO_SHOW) {
                this.fireIntervalAdded(this, listSize, listSize);
            }
        }

        public void removeError(@NotNull ConfigurationError error) {
            if (error == null) {
                ConfigurationErrorsListModel.$$$reportNull$$$0(2);
            }
            int i = this.myAllErrors.indexOf(error);
            this.myIgnoredErrors.remove(error);
            this.myNotIgnoredErrors.remove(error);
            if (i != -1 && i < MAX_ERRORS_TO_SHOW) {
                this.fireIntervalRemoved(this, i, i);
            }
        }

        public List<ConfigurationError> getErrors() {
            return this.myNotIgnoredErrors;
        }

        public List<ConfigurationError> getIgnoredErrors() {
            return this.myIgnoredErrors;
        }

        public void dispose() {
            if (this.myConnection != null) {
                this.myConnection.disconnect();
                this.myConnection = null;
            }
        }

        public void update(ConfigurationError error) {
            int i1;
            int i0 = this.myAllErrors.indexOf(error);
            if (error.isIgnored()) {
                if (this.myNotIgnoredErrors.remove(error)) {
                    this.myIgnoredErrors.add(0, error);
                }
            } else if (this.myIgnoredErrors.remove(error)) {
                this.myNotIgnoredErrors.add(0, error);
            }
            if (i0 == (i1 = this.myAllErrors.indexOf(error)) && i0 != -1) {
                if (i0 < MAX_ERRORS_TO_SHOW) {
                    this.fireContentsChanged(this, i0, i0);
                }
            } else {
                if (i0 != -1 && i0 < MAX_ERRORS_TO_SHOW) {
                    this.fireIntervalRemoved(this, i0, i0);
                }
                if (i1 != -1 && i1 < MAX_ERRORS_TO_SHOW) {
                    this.fireIntervalAdded(this, i1, i1);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "error";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/structure/dialog/ConfigurationErrorsComponent$ConfigurationErrorsListModel";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addError";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "removeError";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static abstract class OneLineErrorComponent
    extends JComponent
    implements ErrorView,
    LinkListener {
        private LinkLabel myErrorsLabel;
        private LinkLabel myIgnoredErrorsLabel;
        private JLabel mySingleErrorLabel;
        private ConfigurationErrorsListModel myModel;

        private OneLineErrorComponent(@NotNull ConfigurationErrorsListModel model) {
            if (model == null) {
                OneLineErrorComponent.$$$reportNull$$$0(0);
            }
            this.myErrorsLabel = new LinkLabel(null, null);
            this.myIgnoredErrorsLabel = new LinkLabel(null, null);
            this.mySingleErrorLabel = new JLabel();
            this.myModel = model;
            this.setLayout(new BorderLayout());
            this.setOpaque(true);
            OneLineErrorComponent.updateLabel((JLabel)this.myErrorsLabel, MessageType.ERROR.getPopupBackground(), this, "Errors");
            OneLineErrorComponent.updateLabel(this.mySingleErrorLabel, MessageType.ERROR.getPopupBackground(), null, null);
            OneLineErrorComponent.updateLabel((JLabel)this.myIgnoredErrorsLabel, MessageType.WARNING.getPopupBackground(), this, "Ignored");
        }

        public void dispose() {
            this.myModel = null;
        }

        private static void updateLabel(@NotNull JLabel label, @NotNull Color bgColor, @Nullable LinkListener listener, @Nullable Object linkData) {
            if (label == null) {
                OneLineErrorComponent.$$$reportNull$$$0(1);
            }
            if (bgColor == null) {
                OneLineErrorComponent.$$$reportNull$$$0(2);
            }
            label.setBorder(BorderFactory.createEmptyBorder(3, 5, 3, 5));
            label.setOpaque(true);
            label.setBackground(bgColor);
            if (label instanceof LinkLabel) {
                ((LinkLabel)label).setListener(listener, linkData);
            }
        }

        @Override
        public void updateView() {
            List<ConfigurationError> ignoredErrors;
            if (this.myModel.getSize() == 0) {
                this.setBorder(null);
            } else if (this.getBorder() == null) {
                this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(5, 0, 5, 0, UIUtil.getPanelBackground()), BorderFactory.createLineBorder(UIUtil.getPanelBackground().darker())));
            }
            List<ConfigurationError> errors = this.myModel.getErrors();
            if (errors.size() > 0) {
                if (errors.size() == 1) {
                    this.mySingleErrorLabel.setText(this.myModel.getErrors().get(0).getPlainTextTitle());
                } else {
                    this.myErrorsLabel.setText(String.format("%s errors found", OneLineErrorComponent.getErrorsCount(errors.size())));
                }
            }
            if ((ignoredErrors = this.myModel.getIgnoredErrors()).size() > 0) {
                this.myIgnoredErrorsLabel.setText(String.format("%s ignored error%s", OneLineErrorComponent.getErrorsCount(ignoredErrors.size()), ignoredErrors.size() == 1 ? "" : "s"));
            }
            this.removeAll();
            if (errors.size() > 0) {
                if (errors.size() == 1) {
                    this.add((Component)this.wrapLabel(this.mySingleErrorLabel, errors.get(0)), "Center");
                    this.mySingleErrorLabel.setToolTipText(errors.get(0).getDescription());
                } else {
                    this.add((Component)this.myErrorsLabel, "Center");
                }
            }
            if (ignoredErrors.size() > 0) {
                this.add((Component)this.myIgnoredErrorsLabel, errors.size() > 0 ? "East" : "Center");
            }
            this.revalidate();
            this.repaint();
        }

        private static String getErrorsCount(int size) {
            return size < MAX_ERRORS_TO_SHOW ? String.valueOf(size) : MAX_ERRORS_TO_SHOW + "+";
        }

        private JComponent wrapLabel(@NotNull JLabel label, @NotNull ConfigurationError configurationError) {
            if (label == null) {
                OneLineErrorComponent.$$$reportNull$$$0(3);
            }
            if (configurationError == null) {
                OneLineErrorComponent.$$$reportNull$$$0(4);
            }
            JPanel result = new JPanel(new BorderLayout());
            result.setBackground(label.getBackground());
            result.add((Component)label, "Center");
            JPanel buttonsPanel = new JPanel();
            buttonsPanel.setOpaque(false);
            buttonsPanel.setLayout(new BoxLayout(buttonsPanel, 0));
            if (configurationError.canBeFixed()) {
                buttonsPanel.add(new ToolbarAlikeButton(AllIcons.Actions.QuickfixBulb){
                    {
                        super(icon);
                        this.setToolTipText("Fix error");
                    }

                    @Override
                    public void onClick(MouseEvent e) {
                        Object o = myModel.getElementAt(0);
                        if (o instanceof ConfigurationError) {
                            ((ConfigurationError)o).fix((JComponent)this, new RelativePoint(e));
                            this.updateView();
                            Container ancestor = SwingUtilities.getAncestorOfClass(ConfigurationErrorsComponent.class, this);
                            if (ancestor != null && ancestor instanceof JComponent) {
                                ((JComponent)ancestor).revalidate();
                                ancestor.repaint();
                            }
                        }
                    }
                });
                buttonsPanel.add(Box.createHorizontalStrut(3));
            }
            buttonsPanel.add(new ToolbarAlikeButton(AllIcons.General.AutoscrollToSource){
                {
                    super(icon);
                    this.setToolTipText("Navigate to error");
                }

                @Override
                public void onClick(MouseEvent e) {
                    Object o = myModel.getElementAt(0);
                    if (o instanceof ConfigurationError) {
                        ((ConfigurationError)o).navigate();
                    }
                }
            });
            buttonsPanel.add(Box.createHorizontalStrut(3));
            buttonsPanel.add(new ToolbarAlikeButton(AllIcons.Actions.Cancel){
                {
                    super(icon);
                    this.setToolTipText("Ignore error");
                }

                @Override
                public void onClick(MouseEvent e) {
                    Object o = myModel.getElementAt(0);
                    if (o instanceof ConfigurationError) {
                        ConfigurationError error;
                        error.ignore(!(error = (ConfigurationError)o).isIgnored());
                        myModel.update(error);
                        this.updateView();
                    }
                }
            });
            buttonsPanel.add(Box.createHorizontalStrut(5));
            result.add((Component)buttonsPanel, "East");
            return result;
        }

        @Override
        public JComponent self() {
            return this;
        }

        @Override
        public abstract void onViewChange(Object var1);

        public void linkSelected(LinkLabel aSource, Object data) {
            this.onViewChange(data);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "label";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "bgColor";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configurationError";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/structure/dialog/ConfigurationErrorsComponent$OneLineErrorComponent";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateLabel";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "wrapLabel";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ErrorListRenderer
    extends JComponent
    implements ListCellRenderer {
        private boolean mySelected;
        private boolean myHasFocus;
        private JTextPane myText;
        private JTextPane myFakeTextPane;
        private JViewport myFakeViewport;
        private JList myList;
        private JPanel myButtonsPanel;
        private JPanel myFixGroup;

        private ErrorListRenderer(@NotNull JList list) {
            if (list == null) {
                ErrorListRenderer.$$$reportNull$$$0(0);
            }
            this.setLayout(new BorderLayout());
            this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            this.setOpaque(false);
            this.myList = list;
            this.myText = new JTextPane();
            this.myButtonsPanel = new JPanel(new BorderLayout());
            this.myButtonsPanel.setBorder(BorderFactory.createEmptyBorder(5, 3, 5, 3));
            this.myButtonsPanel.setOpaque(false);
            JPanel buttons = new JPanel();
            buttons.setOpaque(false);
            buttons.setLayout(new BoxLayout(buttons, 0));
            this.myButtonsPanel.add((Component)buttons, "North");
            this.add((Component)this.myButtonsPanel, "East");
            this.myFixGroup = new JPanel();
            this.myFixGroup.setOpaque(false);
            this.myFixGroup.setLayout(new BoxLayout(this.myFixGroup, 1));
            this.myFixGroup.add(new ToolbarAlikeButton(AllIcons.Actions.QuickfixBulb, ConfigurationErrorsComponent.FIX_ACTION_NAME){});
            this.myFixGroup.add(Box.createHorizontalStrut(3));
            buttons.add(this.myFixGroup);
            buttons.add(new ToolbarAlikeButton(AllIcons.General.AutoscrollToSource, ConfigurationErrorsComponent.NAVIGATE_ACTION_NAME){});
            buttons.add(Box.createHorizontalStrut(3));
            buttons.add(new ToolbarAlikeButton(AllIcons.Actions.Cancel, "IGNORE"){});
            this.myFakeTextPane = new JTextPane();
            this.myText.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
            this.myFakeTextPane.setBorder(BorderFactory.createEmptyBorder(3, 0, 3, 0));
            this.myText.setOpaque(false);
            if (UIUtil.isUnderNimbusLookAndFeel()) {
                this.myText.setBackground(UIUtil.TRANSPARENT_COLOR);
            }
            this.myText.setEditable(false);
            this.myFakeTextPane.setEditable(false);
            this.myText.setEditorKit(UIUtil.getHTMLEditorKit());
            this.myFakeTextPane.setEditorKit(UIUtil.getHTMLEditorKit());
            this.myFakeViewport = new JViewport();
            this.myFakeViewport.setView(this.myFakeTextPane);
            this.add((Component)this.myText, "Center");
        }

        @Override
        public Dimension getPreferredSize() {
            Container parent = this.myList.getParent();
            if (parent != null) {
                this.myFakeTextPane.setText(this.myText.getText());
                Dimension size = parent.getSize();
                this.myFakeViewport.setSize(size);
                Dimension preferredSize = this.myFakeTextPane.getPreferredSize();
                Dimension buttonsPrefSize = this.myButtonsPanel.getPreferredSize();
                int maxHeight = Math.max(buttonsPrefSize.height, preferredSize.height);
                Insets insets = this.getInsets();
                return new Dimension(Math.min(size.width - 20, preferredSize.width), maxHeight + insets.top + insets.bottom);
            }
            return super.getPreferredSize();
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            ConfigurationError error = (ConfigurationError)value;
            this.myList = list;
            this.mySelected = isSelected;
            this.myHasFocus = cellHasFocus;
            this.myFixGroup.setVisible(error.canBeFixed());
            this.myText.setText(error.getDescription());
            this.setBackground(error.isIgnored() ? MessageType.WARNING.getPopupBackground() : MessageType.ERROR.getPopupBackground());
            return this;
        }

        @Override
        protected void paintComponent(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            Rectangle bounds = this.getBounds();
            Insets insets = this.getInsets();
            GraphicsConfig cfg = new GraphicsConfig(g);
            cfg.setAntialiasing(true);
            RoundRectangle2D.Double shape = new RoundRectangle2D.Double(insets.left, insets.top, bounds.width - 1 - insets.left - insets.right, bounds.height - 1 - insets.top - insets.bottom, 6.0, 6.0);
            if (this.mySelected) {
                g2d.setColor(UIUtil.getListSelectionBackground());
                g2d.fillRect(0, 0, bounds.width, bounds.height);
            }
            g2d.setColor(Color.WHITE);
            g2d.fill(shape);
            Color bgColor = this.getBackground();
            g2d.setColor(bgColor);
            g2d.fill(shape);
            g2d.setColor(this.myHasFocus || this.mySelected ? this.getBackground().darker().darker() : this.getBackground().darker());
            g2d.draw(shape);
            cfg.restore();
            super.paintComponent(g);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/android/tools/idea/structure/dialog/ConfigurationErrorsComponent$ErrorListRenderer", "<init>"));
        }
    }

    private static abstract class ToolbarAlikeButton
    extends JComponent {
        private BaseButtonBehavior myBehavior;
        private Icon myIcon;
        private String myName;

        private ToolbarAlikeButton(@NotNull Icon icon, @NotNull String name) {
            if (icon == null) {
                ToolbarAlikeButton.$$$reportNull$$$0(0);
            }
            if (name == null) {
                ToolbarAlikeButton.$$$reportNull$$$0(1);
            }
            this(icon);
            this.myName = name;
        }

        private ToolbarAlikeButton(@NotNull Icon icon) {
            if (icon == null) {
                ToolbarAlikeButton.$$$reportNull$$$0(2);
            }
            this.myIcon = icon;
            this.myBehavior = new BaseButtonBehavior(this, TimedDeadzone.NULL){

                protected void execute(MouseEvent e) {
                    this.onClick(e);
                }
            };
            this.setOpaque(false);
        }

        public String getButtonName() {
            return this.myName;
        }

        public void onClick(MouseEvent e) {
        }

        @Override
        public Insets getInsets() {
            return new Insets(2, 2, 2, 2);
        }

        @Override
        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }

        @Override
        public Dimension getMinimumSize() {
            Dimension size = new Dimension(this.myIcon.getIconWidth(), this.myIcon.getIconHeight());
            JBInsets.addTo((Dimension)size, (Insets)this.getInsets());
            return size;
        }

        @Override
        public void paint(Graphics g) {
            Rectangle bounds = new Rectangle(this.getWidth(), this.getHeight());
            JBInsets.removeFrom((Rectangle)bounds, (Insets)this.getInsets());
            bounds.x += (bounds.width - this.myIcon.getIconWidth()) / 2;
            bounds.y += (bounds.height - this.myIcon.getIconHeight()) / 2;
            if (this.myBehavior.isHovered()) {
                // empty if block
            }
            if (this.myBehavior.isPressedByMouse()) {
                ++bounds.x;
                ++bounds.y;
            }
            this.myIcon.paintIcon(this, g, bounds.x, bounds.y);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "icon";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/structure/dialog/ConfigurationErrorsComponent$ToolbarAlikeButton";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static abstract class MultiLineErrorComponent
    extends JPanel
    implements ErrorView {
        private JList myList;

        protected MultiLineErrorComponent(@NotNull ConfigurationErrorsListModel model) {
            if (model == null) {
                MultiLineErrorComponent.$$$reportNull$$$0(0);
            }
            this.myList = new JBList();
            this.setLayout(new BorderLayout());
            this.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
            this.myList.setModel(model);
            this.myList.setCellRenderer(new ErrorListRenderer(this.myList));
            this.myList.setBackground(UIUtil.getPanelBackground());
            this.myList.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (!e.isPopupTrigger()) {
                        this.processListMouseEvent(e, true);
                    }
                }
            });
            this.myList.addMouseMotionListener(new MouseAdapter(){

                @Override
                public void mouseMoved(MouseEvent e) {
                    if (!e.isPopupTrigger()) {
                        this.processListMouseEvent(e, false);
                    }
                }
            });
            this.myList.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    myList.setCellRenderer(new ErrorListRenderer(myList));
                    this.updatePreferredSize();
                }
            });
            this.add((Component)new JBScrollPane((Component)this.myList), "Center");
            this.add((Component)this.buildToolbar(), "West");
        }

        public void dispose() {
        }

        /*
         * Enabled aggressive block sorting
         */
        private void processListMouseEvent(MouseEvent e, boolean click) {
            block5: {
                ConfigurationError error;
                block6: {
                    String name;
                    block7: {
                        Object value;
                        int index = this.myList.locationToIndex(e.getPoint());
                        if (index <= -1 || (value = this.myList.getModel().getElementAt(index)) == null || !(value instanceof ConfigurationError)) break block5;
                        error = (ConfigurationError)value;
                        Component renderer = this.myList.getCellRenderer().getListCellRendererComponent(this.myList, value, index, false, false);
                        if (!(renderer instanceof ErrorListRenderer)) break block5;
                        Rectangle bounds = this.myList.getCellBounds(index, index);
                        renderer.setBounds(bounds);
                        renderer.doLayout();
                        Point point = e.getPoint();
                        point.translate(-bounds.x, -bounds.y);
                        Component deepestComponentAt = SwingUtilities.getDeepestComponentAt(renderer, point.x, point.y);
                        if (!(deepestComponentAt instanceof ToolbarAlikeButton)) break block6;
                        name = ((ToolbarAlikeButton)deepestComponentAt).getButtonName();
                        if (!click) break block7;
                        if (ConfigurationErrorsComponent.FIX_ACTION_NAME.equals(name)) {
                            this.onClickFix(error, (JComponent)deepestComponentAt, e);
                            break block5;
                        } else if (ConfigurationErrorsComponent.NAVIGATE_ACTION_NAME.equals(name)) {
                            error.navigate();
                            break block5;
                        } else {
                            this.onClickIgnore(error);
                        }
                        break block5;
                    }
                    this.myList.setToolTipText(ConfigurationErrorsComponent.FIX_ACTION_NAME.equals(name) ? "Fix" : (ConfigurationErrorsComponent.NAVIGATE_ACTION_NAME.equals(name) ? "Navigate to the problem" : (error.isIgnored() ? "Not ignore this error" : "Ignore this error")));
                    return;
                }
                if (e.getClickCount() == 2) {
                    error.navigate();
                }
            }
            this.myList.setToolTipText(null);
        }

        private void onClickIgnore(@NotNull ConfigurationError error) {
            if (error == null) {
                MultiLineErrorComponent.$$$reportNull$$$0(1);
            }
            error.ignore(!error.isIgnored());
            ListModel model = this.myList.getModel();
            if (model instanceof ConfigurationErrorsListModel) {
                ((ConfigurationErrorsListModel)model).update(error);
            }
        }

        private void onClickFix(@NotNull ConfigurationError error, JComponent component, MouseEvent e) {
            if (error == null) {
                MultiLineErrorComponent.$$$reportNull$$$0(2);
            }
            error.fix(component, new RelativePoint(e));
        }

        @Override
        public void addNotify() {
            super.addNotify();
            this.updatePreferredSize();
        }

        private void updatePreferredSize() {
            Window window = SwingUtilities.getWindowAncestor(this);
            if (window != null) {
                Dimension d = window.getSize();
                Dimension preferredSize = this.getPreferredSize();
                this.setPreferredSize(new Dimension(preferredSize.width, 200));
                this.setMinimumSize(this.getPreferredSize());
            }
        }

        private JComponent buildToolbar() {
            JPanel result = new JPanel();
            result.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
            result.setLayout(new BorderLayout());
            result.add((Component)new ToolbarAlikeButton(AllIcons.Actions.Collapseall){
                {
                    super(icon);
                    this.setToolTipText("Collapse");
                }

                @Override
                public void onClick(MouseEvent e) {
                    this.onViewChange(null);
                }
            }, "North");
            return result;
        }

        @Override
        public void updateView() {
        }

        @Override
        public JComponent self() {
            return this;
        }

        @Override
        public abstract void onViewChange(@Nullable Object var1);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "error";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/structure/dialog/ConfigurationErrorsComponent$MultiLineErrorComponent";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onClickIgnore";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onClickFix";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static interface ErrorView
    extends Disposable {
        public void updateView();

        public void onViewChange(Object var1);

        public JComponent self();
    }
}

