/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk.wizard;

import com.android.repository.api.Downloader;
import com.android.repository.api.Installer;
import com.android.repository.api.InstallerFactory;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.PackageOperation;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoManager;
import com.android.repository.api.RepoPackage;
import com.android.repository.api.SettingsController;
import com.android.repository.api.Uninstaller;
import com.android.repository.api.UpdatablePackage;
import com.android.repository.io.FileOp;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.sdk.StudioDownloader;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.sdk.wizard.SdkQuickfixUtils;
import com.android.tools.idea.wizard.model.ModelWizardDialog;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class InstallTask
extends Task.Backgroundable {
    private final com.android.repository.api.ProgressIndicator myLogger;
    private Collection<UpdatablePackage> myInstallRequests;
    private Collection<LocalPackage> myUninstallRequests;
    private final RepoManager myRepoManager;
    private final FileOp myFileOp;
    private final InstallerFactory myInstallerFactory;
    private boolean myBackgrounded;
    @Nullable
    private Runnable myPrepareCompleteCallback;
    @Nullable
    private Function<List<RepoPackage>, Void> myCompleteCallback;
    private final SettingsController mySettingsController;

    public InstallTask(@NotNull InstallerFactory installerFactory, @NotNull AndroidSdkHandler sdkHandler, @NotNull SettingsController settings, @NotNull com.android.repository.api.ProgressIndicator logger) {
        if (installerFactory == null) {
            InstallTask.$$$reportNull$$$0(0);
        }
        if (sdkHandler == null) {
            InstallTask.$$$reportNull$$$0(1);
        }
        if (settings == null) {
            InstallTask.$$$reportNull$$$0(2);
        }
        if (logger == null) {
            InstallTask.$$$reportNull$$$0(3);
        }
        super(null, "Installing Android SDK", true, PerformInBackgroundOption.ALWAYS_BACKGROUND);
        this.myLogger = logger;
        this.myRepoManager = sdkHandler.getSdkManager(logger);
        this.myFileOp = sdkHandler.getFileOp();
        this.myInstallerFactory = installerFactory;
        this.mySettingsController = settings;
    }

    public void onCancel() {
        this.myLogger.cancel();
    }

    public void processSentToBackground() {
        this.myBackgrounded = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(@NotNull ProgressIndicator indicator) {
        ArrayList failures;
        block16: {
            block14: {
                block15: {
                    if (indicator == null) {
                        InstallTask.$$$reportNull$$$0(4);
                    }
                    failures = Lists.newArrayList();
                    LinkedHashMap<RepoPackage, PackageOperation> operations = new LinkedHashMap<RepoPackage, PackageOperation>();
                    for (UpdatablePackage install : this.myInstallRequests) {
                        operations.put((RepoPackage)install.getRemote(), this.getOrCreateInstaller((RepoPackage)install.getRemote(), indicator));
                    }
                    for (LocalPackage uninstall : this.myUninstallRequests) {
                        operations.put((RepoPackage)uninstall, this.getOrCreateUninstaller((RepoPackage)uninstall));
                    }
                    try {
                        while (!operations.isEmpty()) {
                            this.preparePackages(operations, failures);
                            if (this.myPrepareCompleteCallback != null) {
                                this.myPrepareCompleteCallback.run();
                            }
                            if (!this.myBackgrounded) {
                                this.completePackages(operations, failures);
                                continue;
                            }
                            this.showPrepareCompleteNotification(operations.keySet());
                            if (failures.isEmpty()) break block14;
                            break block15;
                        }
                        break block16;
                    }
                    catch (Throwable throwable) {
                        if (!failures.isEmpty()) {
                            this.myLogger.logInfo("Failed packages:");
                            for (RepoPackage p : failures) {
                                this.myLogger.logInfo(String.format("- %1$s (%2$s)", p.getDisplayName(), p.getPath()));
                            }
                        }
                        throw throwable;
                    }
                }
                this.myLogger.logInfo("Failed packages:");
                for (RepoPackage p : failures) {
                    this.myLogger.logInfo(String.format("- %1$s (%2$s)", p.getDisplayName(), p.getPath()));
                }
            }
            return;
        }
        if (!failures.isEmpty()) {
            this.myLogger.logInfo("Failed packages:");
            for (RepoPackage p : failures) {
                this.myLogger.logInfo(String.format("- %1$s (%2$s)", p.getDisplayName(), p.getPath()));
            }
        }
        StudioLoggerProgressIndicator progress = new StudioLoggerProgressIndicator(((Object)((Object)this)).getClass());
        this.myRepoManager.loadSynchronously(RepoManager.DEFAULT_EXPIRATION_PERIOD_MS, (com.android.repository.api.ProgressIndicator)progress, null, this.mySettingsController);
        if (this.myCompleteCallback != null) {
            this.myCompleteCallback.apply(failures);
        }
    }

    void completePackages(@NotNull Map<RepoPackage, PackageOperation> operations, @NotNull List<RepoPackage> failures) {
        if (operations == null) {
            InstallTask.$$$reportNull$$$0(5);
        }
        if (failures == null) {
            InstallTask.$$$reportNull$$$0(6);
        }
        for (RepoPackage p : ImmutableSet.copyOf(operations.keySet())) {
            PackageOperation installer = operations.get(p);
            if (!installer.complete(this.myLogger)) {
                PackageOperation fallback = installer.getFallbackOperation();
                if (fallback != null) {
                    this.myLogger.logWarning(String.format("Failed to complete operation using %s, retrying with %s", installer.getClass().getName(), fallback.getClass().getName()));
                    operations.put(p, fallback);
                    continue;
                }
                failures.add(p);
                operations.remove(p);
                continue;
            }
            operations.remove(p);
        }
    }

    @NotNull
    private PackageOperation getOrCreateInstaller(@NotNull RepoPackage p, @NotNull ProgressIndicator indicator) {
        PackageOperation op;
        if (p == null) {
            InstallTask.$$$reportNull$$$0(7);
        }
        if (indicator == null) {
            InstallTask.$$$reportNull$$$0(8);
        }
        if ((op = this.myRepoManager.getInProgressInstallOperation(p)) == null || !(op instanceof Installer)) {
            op = this.myInstallerFactory.createInstaller((RemotePackage)p, this.myRepoManager, (Downloader)new StudioDownloader(indicator), this.myFileOp);
        }
        PackageOperation packageOperation = op;
        if (packageOperation == null) {
            InstallTask.$$$reportNull$$$0(9);
        }
        return packageOperation;
    }

    @NotNull
    private PackageOperation getOrCreateUninstaller(@NotNull RepoPackage p) {
        PackageOperation op;
        if (p == null) {
            InstallTask.$$$reportNull$$$0(10);
        }
        if ((op = this.myRepoManager.getInProgressInstallOperation(p)) == null || !(op instanceof Uninstaller) || op.getInstallStatus() == PackageOperation.InstallStatus.FAILED) {
            op = this.myInstallerFactory.createUninstaller((LocalPackage)p, this.myRepoManager, this.myFileOp);
        }
        PackageOperation packageOperation = op;
        if (packageOperation == null) {
            InstallTask.$$$reportNull$$$0(11);
        }
        return packageOperation;
    }

    void preparePackages(@NotNull Map<RepoPackage, PackageOperation> packageOperationMap, @NotNull List<RepoPackage> failures) {
        if (packageOperationMap == null) {
            InstallTask.$$$reportNull$$$0(12);
        }
        if (failures == null) {
            InstallTask.$$$reportNull$$$0(13);
        }
        for (RepoPackage pack : ImmutableSet.copyOf(packageOperationMap.keySet())) {
            boolean success = false;
            for (PackageOperation op = packageOperationMap.get(pack); op != null; op = op.getFallbackOperation()) {
                try {
                    success = op.prepare(this.myLogger);
                }
                catch (Exception e) {
                    Logger.getInstance(((Object)((Object)this)).getClass()).warn((Throwable)e);
                }
                if (!success) continue;
                packageOperationMap.put(pack, op);
                break;
            }
            if (success) continue;
            failures.add(pack);
            packageOperationMap.remove(pack);
        }
    }

    private void showPrepareCompleteNotification(@NotNull Collection<RepoPackage> packages) {
        Project[] projectArray;
        if (packages == null) {
            InstallTask.$$$reportNull$$$0(14);
        }
        NotificationListener.Adapter notificationListener = new NotificationListener.Adapter(){

            protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                ModelWizardDialog dialogForPaths;
                if (notification == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (event == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ("install".equals(event.getDescription()) && (dialogForPaths = SdkQuickfixUtils.createDialogForPackages(null, InstallTask.this.myInstallRequests, InstallTask.this.myUninstallRequests, false)) != null) {
                    dialogForPaths.show();
                }
                notification.expire();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "notification";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                }
                objectArray[1] = "com/android/tools/idea/sdk/wizard/InstallTask$1";
                objectArray[2] = "hyperlinkActivated";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        NotificationGroup group = new NotificationGroup("SDK Installer", NotificationDisplayType.STICKY_BALLOON, false);
        Project[] openProjects = ProjectManager.getInstance().getOpenProjects();
        if (openProjects.length == 0) {
            Project[] projectArray2 = new Project[1];
            projectArray = projectArray2;
            projectArray2[0] = null;
        } else {
            projectArray = openProjects;
        }
        Project[] openProjectsOrNull = projectArray;
        ApplicationManager.getApplication().invokeLater(() -> this.lambda$showPrepareCompleteNotification$0(openProjectsOrNull, packages, group, (NotificationListener)notificationListener), ModalityState.NON_MODAL, o -> {
            if (packages == null) {
                InstallTask.$$$reportNull$$$0(15);
            }
            for (RepoPackage pack : packages) {
                PackageOperation installer = this.myRepoManager.getInProgressInstallOperation(pack);
                if (installer == null || installer.getInstallStatus() != PackageOperation.InstallStatus.PREPARED) continue;
                return false;
            }
            return true;
        });
    }

    public void setCompleteCallback(Function<List<RepoPackage>, Void> completeCallback) {
        this.myCompleteCallback = completeCallback;
    }

    public void setPrepareCompleteCallback(@Nullable Runnable prepareCompleteCallback) {
        this.myPrepareCompleteCallback = prepareCompleteCallback;
    }

    public void setInstallRequests(List<UpdatablePackage> installRequests) {
        this.myInstallRequests = installRequests;
    }

    public void setUninstallRequests(Collection<LocalPackage> uninstallRequests) {
        this.myUninstallRequests = uninstallRequests;
    }

    private /* synthetic */ void lambda$showPrepareCompleteNotification$0(Project[] openProjectsOrNull, @NotNull Collection packages, NotificationGroup group, NotificationListener notificationListener) {
        if (packages == null) {
            InstallTask.$$$reportNull$$$0(16);
        }
        for (Project p : openProjectsOrNull) {
            String message;
            if (packages.size() == 1) {
                RepoPackage pack = (RepoPackage)packages.iterator().next();
                PackageOperation op = this.myRepoManager.getInProgressInstallOperation(pack);
                String opName = op == null || op instanceof Installer ? "Install" : "Uninstall";
                message = String.format("%1$sation of '%2$s' is ready to continue<br/><a href=\"install\">%1$s Now</a>", opName, pack.getDisplayName());
            } else {
                message = packages.size() + " packages are ready to install or uninstall<br/><a href=\"install\">Continue</a>";
            }
            group.createNotification("SDK Install", message, NotificationType.INFORMATION, notificationListener).notify(p);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "installerFactory";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkHandler";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logger";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operations";
                break;
            }
            case 6: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "failures";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/sdk/wizard/InstallTask";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageOperationMap";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/sdk/wizard/InstallTask";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateInstaller";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateUninstaller";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "run";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "completePackages";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateInstaller";
                break;
            }
            case 9: 
            case 11: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateUninstaller";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "preparePackages";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "showPrepareCompleteNotification";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "lambda$showPrepareCompleteNotification$1";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "lambda$showPrepareCompleteNotification$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

