/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk.install.patch;

import com.android.repository.api.Downloader;
import com.android.repository.api.Installer;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoManager;
import com.android.repository.api.RepoPackage;
import com.android.repository.api.Uninstaller;
import com.android.repository.impl.installer.AbstractInstallerFactory;
import com.android.repository.impl.meta.Archive;
import com.android.repository.io.FileOp;
import com.android.tools.idea.sdk.install.patch.FullInstaller;
import com.android.tools.idea.sdk.install.patch.PatchInstaller;
import com.android.tools.idea.sdk.install.patch.PatchInstallerUtil;
import com.android.tools.idea.sdk.install.patch.PatchRunner;
import com.android.tools.idea.sdk.install.patch.PatchUninstaller;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PatchInstallerFactory
extends AbstractInstallerFactory {
    private static final String KNOWN_GOOD_VERSION = "patcher;v4";

    @NotNull
    protected Installer doCreateInstaller(@NotNull RemotePackage remote, @NotNull RepoManager mgr, @NotNull Downloader downloader, @NotNull FileOp fop) {
        LocalPackage local;
        if (remote == null) {
            PatchInstallerFactory.$$$reportNull$$$0(0);
        }
        if (mgr == null) {
            PatchInstallerFactory.$$$reportNull$$$0(1);
        }
        if (downloader == null) {
            PatchInstallerFactory.$$$reportNull$$$0(2);
        }
        if (fop == null) {
            PatchInstallerFactory.$$$reportNull$$$0(3);
        }
        if (PatchInstallerFactory.hasPatch(local = (LocalPackage)mgr.getPackages().getLocalPackages().get(remote.getPath()), remote)) {
            PatchInstaller patchInstaller = new PatchInstaller(local, remote, downloader, mgr, fop);
            if (patchInstaller == null) {
                PatchInstallerFactory.$$$reportNull$$$0(4);
            }
            return patchInstaller;
        }
        FullInstaller fullInstaller = new FullInstaller(local, remote, mgr, downloader, fop);
        if (fullInstaller == null) {
            PatchInstallerFactory.$$$reportNull$$$0(5);
        }
        return fullInstaller;
    }

    private static boolean hasPatch(@Nullable LocalPackage local, @NotNull RemotePackage remote) {
        if (remote == null) {
            PatchInstallerFactory.$$$reportNull$$$0(6);
        }
        Archive archive = remote.getArchive();
        assert (archive != null);
        return local != null && archive.getPatch(local.getVersion()) != null;
    }

    @NotNull
    protected Uninstaller doCreateUninstaller(@NotNull LocalPackage local, @NotNull RepoManager mgr, @NotNull FileOp fop) {
        if (local == null) {
            PatchInstallerFactory.$$$reportNull$$$0(7);
        }
        if (mgr == null) {
            PatchInstallerFactory.$$$reportNull$$$0(8);
        }
        if (fop == null) {
            PatchInstallerFactory.$$$reportNull$$$0(9);
        }
        PatchUninstaller patchUninstaller = new PatchUninstaller(local, mgr, fop);
        if (patchUninstaller == null) {
            PatchInstallerFactory.$$$reportNull$$$0(10);
        }
        return patchUninstaller;
    }

    protected boolean canHandlePackage(@NotNull RepoPackage p, @NotNull RepoManager manager, @NotNull FileOp fop) {
        LocalPackage patcher;
        if (p == null) {
            PatchInstallerFactory.$$$reportNull$$$0(11);
        }
        if (manager == null) {
            PatchInstallerFactory.$$$reportNull$$$0(12);
        }
        if (fop == null) {
            PatchInstallerFactory.$$$reportNull$$$0(13);
        }
        StudioLoggerProgressIndicator progress = new StudioLoggerProgressIndicator(PatchInstallerFactory.class);
        if (p instanceof LocalPackage) {
            if (fop.isWindows()) {
                LocalPackage latestPatcher = PatchInstallerUtil.getLatestPatcher(manager);
                return latestPatcher != null && !latestPatcher.equals(p);
            }
            return false;
        }
        LocalPackage local = (LocalPackage)manager.getPackages().getLocalPackages().get(p.getPath());
        RemotePackage remote = (RemotePackage)p;
        if (local == null || !fop.isWindows() && !PatchInstallerFactory.hasPatch(local, remote)) {
            return false;
        }
        if (PatchInstallerFactory.hasPatch(local, remote)) {
            patcher = PatchInstallerUtil.getDependantPatcher((RemotePackage)p, manager);
            if (patcher != null && PatchRunner.getPatchRunner(patcher, (ProgressIndicator)progress, fop) != null) {
                return true;
            }
            if (PatchInstallerUtil.getInProgressDependantPatcherInstall((RemotePackage)p, manager) != null) {
                return true;
            }
        }
        return (patcher = PatchInstallerUtil.getLatestPatcher(manager)) != null && PatchInstallerUtil.comparePatcherPaths(patcher.getPath(), KNOWN_GOOD_VERSION) >= 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remote";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mgr";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "downloader";
                break;
            }
            case 3: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fop";
                break;
            }
            case 4: 
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/sdk/install/patch/PatchInstallerFactory";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "local";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/sdk/install/patch/PatchInstallerFactory";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "doCreateInstaller";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "doCreateUninstaller";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doCreateInstaller";
                break;
            }
            case 4: 
            case 5: 
            case 10: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "hasPatch";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "doCreateUninstaller";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "canHandlePackage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

