/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk;

import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.sdk.progress.RepoProgressIndicatorAdapter;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.google.common.collect.Lists;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SdkMerger {
    private static final Logger LOG = Logger.getInstance(SdkMerger.class);

    public static void mergeSdks(@NotNull File srcDir, @NotNull File destDir, @Nullable com.intellij.openapi.progress.ProgressIndicator indicator) {
        if (srcDir == null) {
            SdkMerger.$$$reportNull$$$0(0);
        }
        if (destDir == null) {
            SdkMerger.$$$reportNull$$$0(1);
        }
        Collection<MergeablePackage> packages = SdkMerger.compareSdks(srcDir, destDir, indicator);
        int numPackages = packages.size();
        int i = 0;
        for (MergeablePackage pkg : packages) {
            if (indicator != null) {
                if (indicator.isCanceled()) {
                    return;
                }
                indicator.setFraction((double)i++ / (double)numPackages);
                indicator.setText(String.format("Copying SDK package %1s", pkg.srcPkg.getPath()));
            }
            if (pkg.destPkg != null) {
                File destPkgDir = pkg.destPkg.getLocation();
                try {
                    FileUtil.delete((File)destPkgDir);
                }
                catch (RuntimeException e) {
                    LOG.warn("Failed to delete destination directory " + destPkgDir.getPath(), (Throwable)e);
                }
            }
            try {
                FileUtil.copyDir((File)pkg.srcPkg.getLocation(), (File)new File(pkg.destLocation, pkg.srcPkg.getPath().replace(';', File.separatorChar)));
            }
            catch (IOException e) {
                LOG.error("Unable to copy package " + pkg.srcPkg.getPath(), (Throwable)e);
            }
        }
        if (indicator != null) {
            indicator.setFraction(1.0);
        }
        ProgressIndicator repoProgress = SdkMerger.getRepoProgress(indicator);
        AndroidSdkHandler.getInstance((File)destDir).getSdkManager(repoProgress).loadSynchronously(0L, repoProgress, null, null);
    }

    @NotNull
    public static ProgressIndicator getRepoProgress(@Nullable com.intellij.openapi.progress.ProgressIndicator indicator) {
        Object repoProgress = indicator == null ? new StudioLoggerProgressIndicator(SdkMerger.class) : new RepoProgressIndicatorAdapter(indicator);
        Object object = repoProgress;
        if (object == null) {
            SdkMerger.$$$reportNull$$$0(2);
        }
        return object;
    }

    public static boolean hasMergeableContent(@NotNull File srcDir, @NotNull File destDir) {
        if (srcDir == null) {
            SdkMerger.$$$reportNull$$$0(3);
        }
        if (destDir == null) {
            SdkMerger.$$$reportNull$$$0(4);
        }
        return !SdkMerger.compareSdks(srcDir, destDir, null).isEmpty();
    }

    @NotNull
    private static Collection<MergeablePackage> compareSdks(@NotNull File srcDir, @NotNull File destDir, @Nullable com.intellij.openapi.progress.ProgressIndicator progress) {
        if (srcDir == null) {
            SdkMerger.$$$reportNull$$$0(5);
        }
        if (destDir == null) {
            SdkMerger.$$$reportNull$$$0(6);
        }
        ProgressIndicator repoProgress = SdkMerger.getRepoProgress(progress);
        ArrayList results = Lists.newArrayList();
        AndroidSdkHandler srcHandler = AndroidSdkHandler.getInstance((File)srcDir);
        AndroidSdkHandler destHandler = AndroidSdkHandler.getInstance((File)destDir);
        Map srcPackages = srcHandler.getSdkManager(repoProgress).getPackages().getLocalPackages();
        Map destPackages = destHandler.getSdkManager(repoProgress).getPackages().getLocalPackages();
        for (LocalPackage srcPkg : srcPackages.values()) {
            LocalPackage destPkg = (LocalPackage)destPackages.get(srcPkg.getPath());
            if (destPkg != null) {
                if (srcPkg.getVersion().compareTo(destPkg.getVersion()) <= 0) continue;
                results.add(new MergeablePackage(srcPkg, destPkg, destDir));
                continue;
            }
            results.add(new MergeablePackage(srcPkg, null, destDir));
        }
        ArrayList arrayList = results;
        if (arrayList == null) {
            SdkMerger.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "srcDir";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destDir";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/sdk/SdkMerger";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/sdk/SdkMerger";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepoProgress";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "compareSdks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "mergeSdks";
                break;
            }
            case 2: 
            case 7: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "hasMergeableContent";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "compareSdks";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MergeablePackage {
        @NotNull
        private final LocalPackage srcPkg;
        @Nullable
        private final LocalPackage destPkg;
        @NotNull
        private final File destLocation;

        private MergeablePackage(@NotNull LocalPackage srcPkg, @Nullable LocalPackage destPkg, @NotNull File destLocation) {
            if (srcPkg == null) {
                MergeablePackage.$$$reportNull$$$0(0);
            }
            if (destLocation == null) {
                MergeablePackage.$$$reportNull$$$0(1);
            }
            this.srcPkg = srcPkg;
            this.destPkg = destPkg;
            this.destLocation = destLocation;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "srcPkg";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "destLocation";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/sdk/SdkMerger$MergeablePackage";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

