/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk;

import com.android.repository.api.ProgressIndicator;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.sdk.Jdks;
import com.android.tools.idea.sdk.VersionCheck;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.startup.ExternalAnnotationsSupport;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.impl.SdkConfigurationUtil;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.ui.OrderRoot;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidSdkAdditionalData;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.sdk.AndroidSdkType;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidSdks {
    @NonNls
    public static final String SDK_NAME_PREFIX = "Android ";
    @NotNull
    private final IdeInfo myIdeInfo;
    @NotNull
    private final Jdks myJdks;
    @Nullable
    private AndroidSdkData mySdkData;

    @NotNull
    public static AndroidSdks getInstance() {
        AndroidSdks androidSdks = (AndroidSdks)ServiceManager.getService(AndroidSdks.class);
        if (androidSdks == null) {
            AndroidSdks.$$$reportNull$$$0(0);
        }
        return androidSdks;
    }

    public AndroidSdks(@NotNull Jdks jdks, @NotNull IdeInfo ideInfo) {
        if (jdks == null) {
            AndroidSdks.$$$reportNull$$$0(1);
        }
        if (ideInfo == null) {
            AndroidSdks.$$$reportNull$$$0(2);
        }
        this.myIdeInfo = ideInfo;
        this.myJdks = jdks;
    }

    @Nullable
    public File findPathOfSdkWithoutAddonsFolder(@NotNull Project project) {
        if (project == null) {
            AndroidSdks.$$$reportNull$$$0(3);
        }
        if (this.myIdeInfo.isAndroidStudio()) {
            File sdkPath = IdeSdks.getInstance().getAndroidSdkPath();
            if (sdkPath != null && AndroidSdks.isMissingAddonsFolder(sdkPath)) {
                return sdkPath;
            }
        } else {
            ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
            for (Module module : moduleManager.getModules()) {
                File sdkHomePath;
                String homePath;
                Sdk moduleSdk = ModuleRootManager.getInstance((Module)module).getSdk();
                if (moduleSdk == null || !this.isAndroidSdk(moduleSdk) || (homePath = moduleSdk.getHomePath()) == null || !AndroidSdks.isMissingAddonsFolder(sdkHomePath = new File(FileUtil.toSystemDependentName((String)homePath)))) continue;
                return sdkHomePath;
            }
        }
        return null;
    }

    private static boolean isMissingAddonsFolder(@NotNull File sdkHomePath) {
        File addonsFolder;
        if (sdkHomePath == null) {
            AndroidSdks.$$$reportNull$$$0(4);
        }
        return !(addonsFolder = new File(sdkHomePath, "add-ons")).isDirectory() || FileUtil.notNullize((File[])addonsFolder.listFiles()).length == 0;
    }

    @Nullable
    public Sdk findSuitableAndroidSdk(@NotNull String targetHash) {
        if (targetHash == null) {
            AndroidSdks.$$$reportNull$$$0(5);
        }
        HashSet<String> foundSdkHomePaths = new HashSet<String>();
        ArrayList<Sdk> notCompatibleSdks = new ArrayList<Sdk>();
        for (Sdk sdk : this.getAllAndroidSdks()) {
            String sdkHomePath;
            AndroidSdkAdditionalData originalData = this.getAndroidSdkAdditionalData(sdk);
            if (originalData == null || foundSdkHomePaths.contains(sdkHomePath = sdk.getHomePath()) || !targetHash.equals(originalData.getBuildTargetHashString())) continue;
            if (VersionCheck.isCompatibleVersion(sdkHomePath)) {
                return sdk;
            }
            notCompatibleSdks.add(sdk);
            if (sdkHomePath == null) continue;
            foundSdkHomePaths.add(sdkHomePath);
        }
        return notCompatibleSdks.isEmpty() ? null : (Sdk)notCompatibleSdks.get(0);
    }

    @Nullable
    public AndroidSdkAdditionalData getAndroidSdkAdditionalData(@NotNull Sdk sdk) {
        SdkAdditionalData data;
        if (sdk == null) {
            AndroidSdks.$$$reportNull$$$0(6);
        }
        return (data = sdk.getSdkAdditionalData()) instanceof AndroidSdkAdditionalData ? (AndroidSdkAdditionalData)data : null;
    }

    public void setSdkData(@Nullable AndroidSdkData data) {
        this.mySdkData = data;
    }

    @NotNull
    public AndroidSdkHandler tryToChooseSdkHandler() {
        AndroidSdkData data = this.tryToChooseAndroidSdk();
        AndroidSdkHandler androidSdkHandler = data != null ? data.getSdkHandler() : AndroidSdkHandler.getInstance(null);
        if (androidSdkHandler == null) {
            AndroidSdks.$$$reportNull$$$0(7);
        }
        return androidSdkHandler;
    }

    @Nullable
    public AndroidSdkData tryToChooseAndroidSdk() {
        if (this.mySdkData == null) {
            File path;
            if (this.myIdeInfo.isAndroidStudio() && (path = IdeSdks.getInstance().getAndroidSdkPath()) != null) {
                this.mySdkData = AndroidSdkData.getSdkData(path);
                if (this.mySdkData != null) {
                    return this.mySdkData;
                }
            }
            for (File path2 : this.getAndroidSdkPathsFromExistingPlatforms()) {
                this.mySdkData = AndroidSdkData.getSdkData(path2);
                if (this.mySdkData == null) continue;
                break;
            }
        }
        return this.mySdkData;
    }

    @NotNull
    public Collection<File> getAndroidSdkPathsFromExistingPlatforms() {
        ArrayList<File> result = new ArrayList<File>();
        for (Sdk androidSdk : this.getAllAndroidSdks()) {
            File sdkPath;
            AndroidPlatform androidPlatform = AndroidPlatform.getInstance(androidSdk);
            if (androidPlatform == null || result.contains(sdkPath = androidPlatform.getSdkData().getLocation())) continue;
            if (androidSdk.getName().startsWith(SDK_NAME_PREFIX)) {
                result.add(0, sdkPath);
                continue;
            }
            result.add(sdkPath);
        }
        ArrayList<File> arrayList = result;
        if (arrayList == null) {
            AndroidSdks.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    @NotNull
    public List<Sdk> getAllAndroidSdks() {
        List<Sdk> allSdks = ProjectJdkTable.getInstance().getSdksOfType((SdkTypeId)AndroidSdkType.getInstance());
        List<Sdk> list = allSdks != null ? allSdks : Collections.emptyList();
        if (list == null) {
            AndroidSdks.$$$reportNull$$$0(9);
        }
        return list;
    }

    @Nullable
    public Sdk tryToCreate(@NotNull File sdkPath, @NotNull String targetHashString) {
        AndroidSdkData sdkData;
        if (sdkPath == null) {
            AndroidSdks.$$$reportNull$$$0(10);
        }
        if (targetHashString == null) {
            AndroidSdks.$$$reportNull$$$0(11);
        }
        if ((sdkData = AndroidSdkData.getSdkData(sdkPath)) != null) {
            sdkData.getSdkHandler().getSdkManager((ProgressIndicator)new StudioLoggerProgressIndicator(AndroidSdks.class)).markInvalid();
            IAndroidTarget target = sdkData.findTargetByHashString(targetHashString);
            if (target != null) {
                return this.create(target, sdkData.getLocation(), true);
            }
        }
        return null;
    }

    @Nullable
    public Sdk create(@NotNull IAndroidTarget target, @NotNull File sdkPath, boolean addRoots) {
        Sdk jdk;
        if (target == null) {
            AndroidSdks.$$$reportNull$$$0(12);
        }
        if (sdkPath == null) {
            AndroidSdks.$$$reportNull$$$0(13);
        }
        return (jdk = this.myJdks.chooseOrCreateJavaSdk()) != null ? this.create(target, sdkPath, jdk, addRoots) : null;
    }

    @Nullable
    public Sdk create(@NotNull IAndroidTarget target, @NotNull File sdkPath, @NotNull Sdk jdk, boolean addRoots) {
        if (target == null) {
            AndroidSdks.$$$reportNull$$$0(14);
        }
        if (sdkPath == null) {
            AndroidSdks.$$$reportNull$$$0(15);
        }
        if (jdk == null) {
            AndroidSdks.$$$reportNull$$$0(16);
        }
        return this.create(target, sdkPath, this.chooseNameForNewLibrary(target), jdk, addRoots);
    }

    @Nullable
    public Sdk create(@NotNull IAndroidTarget target, @NotNull File sdkPath, @NotNull String sdkName, @NotNull Sdk jdk, boolean addRoots) {
        if (target == null) {
            AndroidSdks.$$$reportNull$$$0(17);
        }
        if (sdkPath == null) {
            AndroidSdks.$$$reportNull$$$0(18);
        }
        if (sdkName == null) {
            AndroidSdks.$$$reportNull$$$0(19);
        }
        if (jdk == null) {
            AndroidSdks.$$$reportNull$$$0(20);
        }
        if (!target.getAdditionalLibraries().isEmpty()) {
            return null;
        }
        ProjectJdkTable table = ProjectJdkTable.getInstance();
        String tempName = SdkConfigurationUtil.createUniqueSdkName((String)"Android SDK", Arrays.asList(table.getAllJdks()));
        Sdk sdk = table.createSdk(tempName, (SdkTypeId)AndroidSdkType.getInstance());
        SdkModificator sdkModificator = sdk.getSdkModificator();
        sdkModificator.setHomePath(sdkPath.getPath());
        this.setUpSdk(sdk, sdkModificator, target, sdkName, Arrays.asList(table.getAllJdks()), jdk, addRoots);
        sdkModificator.commitChanges();
        ApplicationManager.getApplication().runWriteAction(() -> ProjectJdkTable.getInstance().addJdk(sdk));
        return sdk;
    }

    public void setUpSdk(@NotNull Sdk androidSdk, @NotNull IAndroidTarget target, @NotNull String sdkName, @NotNull Collection<Sdk> allSdks, @Nullable Sdk jdk, boolean addRoots) {
        if (androidSdk == null) {
            AndroidSdks.$$$reportNull$$$0(21);
        }
        if (target == null) {
            AndroidSdks.$$$reportNull$$$0(22);
        }
        if (sdkName == null) {
            AndroidSdks.$$$reportNull$$$0(23);
        }
        if (allSdks == null) {
            AndroidSdks.$$$reportNull$$$0(24);
        }
        SdkModificator sdkModificator = androidSdk.getSdkModificator();
        this.setUpSdk(androidSdk, sdkModificator, target, sdkName, allSdks, jdk, addRoots);
        sdkModificator.commitChanges();
    }

    public void setUpSdk(@NotNull Sdk androidSdk, @NotNull SdkModificator androidSdkModificator, @NotNull IAndroidTarget target, @NotNull String sdkName, @NotNull Collection<Sdk> allSdks, @Nullable Sdk jdk, boolean addRoots) {
        if (androidSdk == null) {
            AndroidSdks.$$$reportNull$$$0(25);
        }
        if (androidSdkModificator == null) {
            AndroidSdks.$$$reportNull$$$0(26);
        }
        if (target == null) {
            AndroidSdks.$$$reportNull$$$0(27);
        }
        if (sdkName == null) {
            AndroidSdks.$$$reportNull$$$0(28);
        }
        if (allSdks == null) {
            AndroidSdks.$$$reportNull$$$0(29);
        }
        AndroidSdkAdditionalData data = new AndroidSdkAdditionalData(androidSdk, jdk);
        data.setBuildTarget(target);
        String name = SdkConfigurationUtil.createUniqueSdkName((String)sdkName, allSdks);
        androidSdkModificator.setName(name);
        if (jdk != null) {
            androidSdkModificator.setVersionString(jdk.getVersionString());
        }
        androidSdkModificator.setSdkAdditionalData((SdkAdditionalData)data);
        if (addRoots) {
            List<OrderRoot> newRoots = this.getLibraryRootsForTarget(target, androidSdk, true);
            androidSdkModificator.removeAllRoots();
            for (OrderRoot orderRoot : newRoots) {
                androidSdkModificator.addRoot(orderRoot.getFile(), orderRoot.getType());
            }
            ExternalAnnotationsSupport.attachJdkAnnotations(androidSdkModificator);
        }
        this.findAndSetPlatformSources(target, androidSdkModificator);
    }

    public void findAndSetPlatformSources(@NotNull IAndroidTarget target, @NotNull SdkModificator sdkModificator) {
        VirtualFile virtualFile;
        File sources;
        if (target == null) {
            AndroidSdks.$$$reportNull$$$0(30);
        }
        if (sdkModificator == null) {
            AndroidSdks.$$$reportNull$$$0(31);
        }
        if ((sources = this.findPlatformSources(target)) != null && (virtualFile = VfsUtil.findFileByIoFile((File)sources, (boolean)true)) != null) {
            for (VirtualFile file : sdkModificator.getRoots(OrderRootType.SOURCES)) {
                if (!file.equals(virtualFile)) continue;
                return;
            }
            sdkModificator.addRoot(virtualFile, OrderRootType.SOURCES);
        }
    }

    @Nullable
    public File findPlatformSources(@NotNull IAndroidTarget target) {
        File platformSource;
        String path;
        if (target == null) {
            AndroidSdks.$$$reportNull$$$0(32);
        }
        if ((path = target.getPath(18)) != null && (platformSource = new File(path)).isDirectory()) {
            return platformSource;
        }
        return null;
    }

    @NotNull
    public List<OrderRoot> getLibraryRootsForTarget(@NotNull IAndroidTarget target, @NotNull Sdk androidSdk, boolean addPlatformAndAddOnJars) {
        if (target == null) {
            AndroidSdks.$$$reportNull$$$0(33);
        }
        if (androidSdk == null) {
            AndroidSdks.$$$reportNull$$$0(34);
        }
        List<OrderRoot> list = this.getLibraryRootsForTarget(target, AndroidSdks.getHomePath(androidSdk), addPlatformAndAddOnJars);
        if (list == null) {
            AndroidSdks.$$$reportNull$$$0(35);
        }
        return list;
    }

    @Nullable
    private static File getHomePath(@NotNull Sdk androidSdk) {
        String sdkPathValue;
        if (androidSdk == null) {
            AndroidSdks.$$$reportNull$$$0(36);
        }
        return StringUtil.isNotEmpty((String)(sdkPathValue = androidSdk.getHomePath())) ? new File(sdkPathValue) : null;
    }

    @NotNull
    public List<OrderRoot> getLibraryRootsForTarget(@NotNull IAndroidTarget target, @Nullable File sdkPath, boolean addPlatformAndAddOnJars) {
        File annotationsJarPath;
        VirtualFile annotationsJar;
        VirtualFile resFolder;
        String resFolderPath;
        VirtualFile javadoc;
        VirtualFile platformSourcesDir;
        VirtualFile platformFolder;
        if (target == null) {
            AndroidSdks.$$$reportNull$$$0(37);
        }
        ArrayList<OrderRoot> result = new ArrayList<OrderRoot>();
        if (addPlatformAndAddOnJars) {
            for (VirtualFile file : this.getPlatformAndAddOnJars(target)) {
                result.add(new OrderRoot(file, OrderRootType.CLASSES));
            }
        }
        if ((platformFolder = AndroidSdks.getPlatformFolder(target)) == null) {
            ArrayList<OrderRoot> arrayList = result;
            if (arrayList == null) {
                AndroidSdks.$$$reportNull$$$0(38);
            }
            return arrayList;
        }
        VirtualFile targetDir = platformFolder;
        if (!target.isPlatform()) {
            targetDir = AndroidSdks.findFileInLocalFileSystem(target.getLocation());
        }
        boolean docsOrSourcesFound = false;
        if (targetDir != null) {
            docsOrSourcesFound = AndroidSdks.addJavaDocAndSources(result, targetDir);
        }
        VirtualFile sdkDir = sdkPath != null ? AndroidSdks.findFileInLocalFileSystem(sdkPath.getPath()) : null;
        VirtualFile sourcesDir = null;
        if (sdkDir != null) {
            docsOrSourcesFound = AndroidSdks.addJavaDocAndSources(result, sdkDir) || docsOrSourcesFound;
            sourcesDir = sdkDir.findChild("sources");
        }
        if (sourcesDir != null && sourcesDir.isDirectory() && (platformSourcesDir = sourcesDir.findChild(platformFolder.getName())) != null && platformSourcesDir.isDirectory()) {
            result.add(new OrderRoot(platformSourcesDir, OrderRootType.SOURCES));
            docsOrSourcesFound = true;
        }
        if (!docsOrSourcesFound && (javadoc = VirtualFileManager.getInstance().findFileByUrl("http://developer.android.com/reference/")) != null) {
            result.add(new OrderRoot(javadoc, JavadocOrderRootType.getInstance()));
        }
        if ((resFolderPath = target.getPath(11)) != null && (resFolder = AndroidSdks.findFileInLocalFileSystem(resFolderPath)) != null) {
            result.add(new OrderRoot(resFolder, OrderRootType.CLASSES));
        }
        if (sdkPath != null && this.needsAnnotationsJarInClasspath(target) && (annotationsJar = AndroidSdks.findFileInJarFileSystem(annotationsJarPath = new File(sdkPath, FileUtil.toSystemDependentName((String)"/tools/support/annotations.jar")))) != null) {
            result.add(new OrderRoot(annotationsJar, OrderRootType.CLASSES));
        }
        ArrayList<OrderRoot> arrayList = result;
        if (arrayList == null) {
            AndroidSdks.$$$reportNull$$$0(39);
        }
        return arrayList;
    }

    @NotNull
    public List<VirtualFile> getPlatformAndAddOnJars(@NotNull IAndroidTarget target) {
        VirtualFile androidJar;
        if (target == null) {
            AndroidSdks.$$$reportNull$$$0(40);
        }
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        VirtualFile platformFolder = AndroidSdks.getPlatformFolder(target);
        if (platformFolder != null && (androidJar = platformFolder.findChild("android.jar")) != null) {
            File androidJarPath = VfsUtilCore.virtualToIoFile((VirtualFile)androidJar);
            VirtualFile androidJarRoot = AndroidSdks.findFileInJarFileSystem(androidJarPath);
            if (androidJarRoot != null) {
                result.add(androidJarRoot);
            }
            List libraries = target.getAdditionalLibraries();
            for (IAndroidTarget.OptionalLibrary library : libraries) {
                VirtualFile root = AndroidSdks.getRoot(library);
                if (root == null) continue;
                result.add(root);
            }
        }
        ArrayList<VirtualFile> arrayList = result;
        if (arrayList == null) {
            AndroidSdks.$$$reportNull$$$0(41);
        }
        return arrayList;
    }

    @Nullable
    private static VirtualFile getPlatformFolder(@NotNull IAndroidTarget target) {
        String platformPath;
        if (target == null) {
            AndroidSdks.$$$reportNull$$$0(42);
        }
        String string = platformPath = target.isPlatform() ? target.getLocation() : target.getParent().getLocation();
        if (platformPath == null) {
            return null;
        }
        return LocalFileSystem.getInstance().refreshAndFindFileByPath(FileUtil.toSystemIndependentName((String)platformPath));
    }

    @Nullable
    private static VirtualFile getRoot(@NotNull IAndroidTarget.OptionalLibrary library) {
        File jar;
        if (library == null) {
            AndroidSdks.$$$reportNull$$$0(43);
        }
        if ((jar = library.getJar()) != null) {
            return AndroidSdks.findFileInJarFileSystem(jar);
        }
        return null;
    }

    private static boolean addJavaDocAndSources(@NotNull List<OrderRoot> orderRoots, @NotNull VirtualFile sdkFolder) {
        VirtualFile sourcesFolder;
        if (orderRoots == null) {
            AndroidSdks.$$$reportNull$$$0(44);
        }
        if (sdkFolder == null) {
            AndroidSdks.$$$reportNull$$$0(45);
        }
        boolean found = false;
        VirtualFile javadocFolder = AndroidSdks.findJavadocFolder(sdkFolder);
        if (javadocFolder != null) {
            orderRoots.add(new OrderRoot(javadocFolder, JavadocOrderRootType.getInstance()));
            found = true;
        }
        if ((sourcesFolder = sdkFolder.findChild("src")) != null) {
            orderRoots.add(new OrderRoot(sourcesFolder, OrderRootType.SOURCES));
            found = true;
        }
        return found;
    }

    @Nullable
    private static VirtualFile findJavadocFolder(@NotNull VirtualFile folder) {
        VirtualFile docsFolder;
        if (folder == null) {
            AndroidSdks.$$$reportNull$$$0(46);
        }
        return (docsFolder = folder.findChild("docs")) != null ? docsFolder.findChild("reference") : null;
    }

    @Nullable
    private static VirtualFile findFileInLocalFileSystem(@NotNull String path) {
        if (path == null) {
            AndroidSdks.$$$reportNull$$$0(47);
        }
        return LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemDependentName((String)path));
    }

    @Nullable
    private static VirtualFile findFileInJarFileSystem(@NotNull File path) {
        if (path == null) {
            AndroidSdks.$$$reportNull$$$0(48);
        }
        String canonicalPath = FileUtil.toCanonicalPath((String)path.getPath());
        return JarFileSystem.getInstance().findFileByPath(canonicalPath + "!/");
    }

    @NotNull
    public String chooseNameForNewLibrary(@NotNull IAndroidTarget target) {
        if (target == null) {
            AndroidSdks.$$$reportNull$$$0(49);
        }
        if (target.isPlatform()) {
            String string = SDK_NAME_PREFIX + target.getVersion().toString() + " Platform";
            if (string == null) {
                AndroidSdks.$$$reportNull$$$0(50);
            }
            return string;
        }
        IAndroidTarget parentTarget = target.getParent();
        String name = SDK_NAME_PREFIX;
        if (parentTarget != null) {
            name = name + parentTarget.getVersionName() + ' ';
        }
        String string = name + target.getName();
        if (string == null) {
            AndroidSdks.$$$reportNull$$$0(51);
        }
        return string;
    }

    public boolean isAndroidSdk(@NotNull Sdk sdk) {
        if (sdk == null) {
            AndroidSdks.$$$reportNull$$$0(52);
        }
        return sdk.getSdkType() == AndroidSdkType.getInstance();
    }

    public boolean needsAnnotationsJarInClasspath(@NotNull IAndroidTarget target) {
        if (target == null) {
            AndroidSdks.$$$reportNull$$$0(53);
        }
        return target.getVersion().getApiLevel() <= 15;
    }

    public void refreshLibrariesIn(@NotNull Sdk sdk) {
        if (sdk == null) {
            AndroidSdks.$$$reportNull$$$0(54);
        }
        VirtualFile[] libraries = sdk.getRootProvider().getFiles(OrderRootType.CLASSES);
        this.replaceLibraries(sdk, libraries);
    }

    @VisibleForTesting
    void replaceLibraries(@NotNull Sdk sdk, @NotNull VirtualFile[] libraries) {
        if (sdk == null) {
            AndroidSdks.$$$reportNull$$$0(55);
        }
        if (libraries == null) {
            AndroidSdks.$$$reportNull$$$0(56);
        }
        SdkModificator sdkModificator = sdk.getSdkModificator();
        sdkModificator.removeRoots(OrderRootType.CLASSES);
        for (VirtualFile library : libraries) {
            sdkModificator.addRoot(library, OrderRootType.CLASSES);
        }
        sdkModificator.commitChanges();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 40: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 40: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/sdk/AndroidSdks";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdks";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideInfo";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkHomePath";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetHash";
                break;
            }
            case 6: 
            case 52: 
            case 54: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 10: 
            case 13: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkPath";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetHashString";
                break;
            }
            case 12: 
            case 14: 
            case 17: 
            case 22: 
            case 27: 
            case 30: 
            case 32: 
            case 33: 
            case 37: 
            case 40: 
            case 42: 
            case 49: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdk";
                break;
            }
            case 19: 
            case 23: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkName";
                break;
            }
            case 21: 
            case 25: 
            case 34: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidSdk";
                break;
            }
            case 24: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allSdks";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidSdkModificator";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkModificator";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orderRoots";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkFolder";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folder";
                break;
            }
            case 47: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraries";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 40: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/sdk/AndroidSdks";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToChooseSdkHandler";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAndroidSdkPathsFromExistingPlatforms";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllAndroidSdks";
                break;
            }
            case 35: 
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryRootsForTarget";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlatformAndAddOnJars";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "chooseNameForNewLibrary";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findPathOfSdkWithoutAddonsFolder";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isMissingAddonsFolder";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findSuitableAndroidSdk";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAndroidSdkAdditionalData";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "tryToCreate";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "setUpSdk";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "findAndSetPlatformSources";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "findPlatformSources";
                break;
            }
            case 33: 
            case 34: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getLibraryRootsForTarget";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getHomePath";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getPlatformAndAddOnJars";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getPlatformFolder";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getRoot";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "addJavaDocAndSources";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "findJavadocFolder";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "findFileInLocalFileSystem";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "findFileInJarFileSystem";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "chooseNameForNewLibrary";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "isAndroidSdk";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "needsAnnotationsJarInClasspath";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "refreshLibrariesIn";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "replaceLibraries";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 40: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

