/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.tasks;

import com.android.ddmlib.CollectingOutputReceiver;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.util.LaunchStatus;
import com.intellij.openapi.diagnostic.Logger;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class ShellCommandLauncher {
    /*
     * WARNING - void declaration
     */
    public static boolean execute(@NotNull String command, @NotNull IDevice device, @NotNull LaunchStatus launchStatus, @NotNull ConsolePrinter printer, long timeout, @NotNull TimeUnit timeUnit) {
        if (command == null) {
            ShellCommandLauncher.$$$reportNull$$$0(0);
        }
        if (device == null) {
            ShellCommandLauncher.$$$reportNull$$$0(1);
        }
        if (launchStatus == null) {
            ShellCommandLauncher.$$$reportNull$$$0(2);
        }
        if (printer == null) {
            ShellCommandLauncher.$$$reportNull$$$0(3);
        }
        if (timeUnit == null) {
            ShellCommandLauncher.$$$reportNull$$$0(4);
        }
        printer.stdout("$ adb shell " + command);
        AndroidLaunchReceiver receiver = new AndroidLaunchReceiver(launchStatus);
        try {
            void timeoutUnit;
            device.executeShellCommand(command, (IShellOutputReceiver)receiver, timeout, (TimeUnit)timeoutUnit);
        }
        catch (Exception e) {
            Logger logger = Logger.getInstance(ShellCommandLauncher.class);
            logger.warn("Unexpected exception while executing shell command: " + command);
            logger.warn((Throwable)e);
            launchStatus.terminateLaunch("Unexpected error while executing: " + command);
            return false;
        }
        String output = receiver.getOutput();
        if (output.toLowerCase(Locale.US).contains("error")) {
            launchStatus.terminateLaunch("Error while executing: " + command);
            printer.stderr(output);
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "command";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "device";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "launchStatus";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "printer";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "timeoutUnit";
                break;
            }
        }
        objectArray[1] = "com/android/tools/idea/run/tasks/ShellCommandLauncher";
        objectArray[2] = "execute";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class AndroidLaunchReceiver
    extends CollectingOutputReceiver {
        private final LaunchStatus myLaunchStatus;

        public AndroidLaunchReceiver(@NotNull LaunchStatus state) {
            if (state == null) {
                AndroidLaunchReceiver.$$$reportNull$$$0(0);
            }
            this.myLaunchStatus = state;
        }

        public boolean isCancelled() {
            return this.myLaunchStatus.isLaunchTerminated();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/android/tools/idea/run/tasks/ShellCommandLauncher$AndroidLaunchReceiver", "<init>"));
        }
    }
}

