/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.tasks;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.fd.InstantRunConfigurable;
import com.android.tools.idea.fd.InstantRunContext;
import com.android.tools.idea.fd.InstantRunManager;
import com.android.tools.idea.fd.InstantRunNotificationProvider;
import com.android.tools.idea.fd.InstantRunSettings;
import com.android.tools.idea.fd.actions.RestartActivityAction;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.tasks.LaunchTask;
import com.android.tools.idea.run.util.LaunchStatus;
import com.intellij.ide.BrowserUtil;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.HashSet;
import java.util.Set;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstantRunNotificationTask
implements LaunchTask {
    private static Set<String> ourBrokenForSecondaryUserMessageDisplayed = new HashSet();
    private static final Object LOCK = new Object();
    private final Project myProject;
    private final InstantRunContext myContext;
    private final InstantRunNotificationProvider myNotificationsProvider;
    private final boolean myShowBrokenForSecondaryUserMessage;

    public InstantRunNotificationTask(@NotNull Project project, @NotNull InstantRunContext context, @NotNull InstantRunNotificationProvider provider, boolean showBrokenForSecondaryUserMessage) {
        if (project == null) {
            InstantRunNotificationTask.$$$reportNull$$$0(0);
        }
        if (context == null) {
            InstantRunNotificationTask.$$$reportNull$$$0(1);
        }
        if (provider == null) {
            InstantRunNotificationTask.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        this.myContext = context;
        this.myNotificationsProvider = provider;
        this.myShowBrokenForSecondaryUserMessage = showBrokenForSecondaryUserMessage;
    }

    @Override
    @NotNull
    public String getDescription() {
        if ("Display Instant Run notification" == null) {
            InstantRunNotificationTask.$$$reportNull$$$0(3);
        }
        return "Display Instant Run notification";
    }

    @Override
    public int getDuration() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean perform(@NotNull IDevice device, @NotNull LaunchStatus launchStatus, @NotNull ConsolePrinter printer) {
        if (device == null) {
            InstantRunNotificationTask.$$$reportNull$$$0(4);
        }
        if (launchStatus == null) {
            InstantRunNotificationTask.$$$reportNull$$$0(5);
        }
        if (printer == null) {
            InstantRunNotificationTask.$$$reportNull$$$0(6);
        }
        if (!InstantRunSettings.isShowNotificationsEnabled()) {
            return true;
        }
        String notificationText = this.myNotificationsProvider.getNotificationText();
        if (notificationText != null) {
            InstantRunNotificationTask.showNotification(this.myProject, this.myContext, notificationText);
        }
        if (this.myShowBrokenForSecondaryUserMessage) {
            boolean show = false;
            Object object = LOCK;
            synchronized (object) {
                if (!ourBrokenForSecondaryUserMessageDisplayed.contains(this.myProject.getLocationHash())) {
                    ourBrokenForSecondaryUserMessageDisplayed.add(this.myProject.getLocationHash());
                    show = true;
                }
            }
            if (show) {
                InstantRunNotificationTask.showIrBrokenForSecondaryUsersNotification(this.myProject);
            }
        }
        return true;
    }

    private static void showIrBrokenForSecondaryUsersNotification(@NotNull Project project) {
        if (project == null) {
            InstantRunNotificationTask.$$$reportNull$$$0(7);
        }
        NotificationListener l = (notification, event) -> {
            if (project == null) {
                InstantRunNotificationTask.$$$reportNull$$$0(11);
            }
            if (event.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                return;
            }
            String description = event.getDescription();
            if ("learnmore".equals(description)) {
                BrowserUtil.browse((String)"http://developers.android.com/r/studio-ui/run-with-work-profile.html", (Project)project);
            }
        };
        InstantRunManager.NOTIFICATION_GROUP.createNotification("", AndroidBundle.message("instant.run.notification.ir.broken.for.secondary.user", new Object[0]), NotificationType.INFORMATION, l).notify(project);
    }

    public static void showNotification(@NotNull Project project, @Nullable InstantRunContext context, @NotNull String notificationText) {
        if (project == null) {
            InstantRunNotificationTask.$$$reportNull$$$0(8);
        }
        if (notificationText == null) {
            InstantRunNotificationTask.$$$reportNull$$$0(9);
        }
        if (!InstantRunSettings.isShowNotificationsEnabled()) {
            return;
        }
        String message = String.format("<html>%1$s<br>(<a href=\"mute\">Don't show again</a>)</html>", notificationText);
        NotificationListener l = (notification, event) -> {
            if (project == null) {
                InstantRunNotificationTask.$$$reportNull$$$0(10);
            }
            if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                String description = event.getDescription();
                if (description != null && description.startsWith("http")) {
                    BrowserUtil.browse((String)description, (Project)project);
                } else if ("mute".equals(description)) {
                    InstantRunSettings.setShowStatusNotifications(false);
                } else if ("configure".equals(description)) {
                    InstantRunConfigurable configurable = new InstantRunConfigurable();
                    ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)configurable);
                } else if ("restart".equals(description)) {
                    assert (context != null) : "Notifications that include a restart activity option need to have a valid instant run context";
                    RestartActivityAction.restartActivity(project, context);
                } else if ("learnmore".equals(description)) {
                    BrowserUtil.browse((String)"http://developer.android.com/r/studio-ui/instant-run.html", (Project)project);
                } else if ("updategradle".equals(description)) {
                    InstantRunConfigurable.updateProjectToInstantRunTools(project, null);
                }
            }
        };
        InstantRunManager.NOTIFICATION_GROUP.createNotification("", message, NotificationType.INFORMATION, l).notify(project);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/run/tasks/InstantRunNotificationTask";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launchStatus";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "printer";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notificationText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/run/tasks/InstantRunNotificationTask";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "perform";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "showIrBrokenForSecondaryUsersNotification";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "showNotification";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "lambda$showNotification$1";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "lambda$showIrBrokenForSecondaryUsersNotification$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

