/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.tasks;

import com.android.ddmlib.Client;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.NullOutputReceiver;
import com.android.tools.idea.fd.InstantRunUtils;
import com.android.tools.idea.run.AndroidDebugState;
import com.android.tools.idea.run.AndroidProcessText;
import com.android.tools.idea.run.AndroidRemoteDebugProcessHandler;
import com.android.tools.idea.run.AndroidSessionInfo;
import com.android.tools.idea.run.LaunchInfo;
import com.android.tools.idea.run.ProcessHandlerConsolePrinter;
import com.android.tools.idea.run.editor.AndroidDebugger;
import com.android.tools.idea.run.tasks.ConnectDebuggerTask;
import com.android.tools.idea.run.util.ProcessHandlerLaunchStatus;
import com.intellij.debugger.ui.DebuggerPanelsManager;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.util.Locale;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ConnectJavaDebuggerTask
extends ConnectDebuggerTask {
    public ConnectJavaDebuggerTask(@NotNull Set<String> applicationIds, @NotNull AndroidDebugger debugger, @NotNull Project project, boolean monitorRemoteProcess) {
        if (applicationIds == null) {
            ConnectJavaDebuggerTask.$$$reportNull$$$0(0);
        }
        if (debugger == null) {
            ConnectJavaDebuggerTask.$$$reportNull$$$0(1);
        }
        if (project == null) {
            ConnectJavaDebuggerTask.$$$reportNull$$$0(2);
        }
        super(applicationIds, debugger, project, monitorRemoteProcess);
    }

    @Override
    public ProcessHandler launchDebugger(@NotNull LaunchInfo currentLaunchInfo, @NotNull Client client, @NotNull ProcessHandlerLaunchStatus launchStatus, @NotNull ProcessHandlerConsolePrinter printer) {
        RunProfile runProfile;
        RunContentDescriptor debugDescriptor;
        if (currentLaunchInfo == null) {
            ConnectJavaDebuggerTask.$$$reportNull$$$0(3);
        }
        if (client == null) {
            ConnectJavaDebuggerTask.$$$reportNull$$$0(4);
        }
        if (launchStatus == null) {
            ConnectJavaDebuggerTask.$$$reportNull$$$0(5);
        }
        if (printer == null) {
            ConnectJavaDebuggerTask.$$$reportNull$$$0(6);
        }
        String debugPort = Integer.toString(client.getDebuggerListenPort());
        final int pid = client.getClientData().getPid();
        Logger.getInstance(ConnectJavaDebuggerTask.class).info(String.format(Locale.US, "Attempting to connect debugger to port %1$s [client %2$d]", debugPort, pid));
        RunContentDescriptor descriptor = currentLaunchInfo.env.getContentToReuse();
        assert (descriptor != null) : "ConnectJavaDebuggerTask expects an existing descriptor that will be reused";
        ProcessHandler processHandler = descriptor.getProcessHandler();
        assert (processHandler != null);
        RemoteConnection connection = new RemoteConnection(true, "localhost", debugPort, false);
        final AndroidRemoteDebugProcessHandler debugProcessHandler = new AndroidRemoteDebugProcessHandler(this.myProject, this.myMonitorRemoteProcess);
        launchStatus.setProcessHandler(debugProcessHandler);
        printer.setProcessHandler(debugProcessHandler);
        processHandler.detachProcess();
        AndroidDebugState debugState = new AndroidDebugState(this.myProject, debugProcessHandler, connection, currentLaunchInfo.consoleProvider);
        try {
            ExecutionEnvironment debugEnv = new ExecutionEnvironmentBuilder(currentLaunchInfo.env).executor(currentLaunchInfo.executor).runner(currentLaunchInfo.runner).contentToReuse(descriptor).build();
            debugDescriptor = DebuggerPanelsManager.getInstance((Project)this.myProject).attachVirtualMachine(debugEnv, (RunProfileState)debugState, connection, false);
        }
        catch (ExecutionException e) {
            processHandler.notifyTextAvailable("ExecutionException: " + e.getMessage() + '.', ProcessOutputTypes.STDERR);
            return null;
        }
        if (debugDescriptor == null) {
            processHandler.notifyTextAvailable("Unable to connect debugger to Android application", ProcessOutputTypes.STDERR);
            return null;
        }
        AndroidProcessText oldText = AndroidProcessText.get(processHandler);
        if (oldText != null) {
            oldText.printTo(debugProcessHandler);
        }
        int uniqueId = (runProfile = currentLaunchInfo.env.getRunProfile()) instanceof RunConfigurationBase ? ((RunConfigurationBase)runProfile).getUniqueID() : -1;
        AndroidSessionInfo value = new AndroidSessionInfo(debugProcessHandler, debugDescriptor, uniqueId, currentLaunchInfo.executor.getId(), InstantRunUtils.isInstantRunEnabled(currentLaunchInfo.env));
        debugProcessHandler.putUserData(AndroidSessionInfo.KEY, value);
        debugProcessHandler.putUserData(AndroidSessionInfo.ANDROID_DEBUG_CLIENT, client);
        debugProcessHandler.putUserData(AndroidSessionInfo.ANDROID_DEVICE_API_LEVEL, client.getDevice().getVersion());
        final String pkgName = client.getClientData().getClientDescription();
        final IDevice device = client.getDevice();
        debugProcessHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                debugProcessHandler.removeProcessListener((ProcessListener)this);
                Client currentClient = device.getClient(pkgName);
                if (currentClient != null && currentClient.getClientData().getPid() != pid) {
                    return;
                }
                Logger.getInstance(ConnectJavaDebuggerTask.class).info("Debugger terminating, so terminating process: " + pkgName);
                try {
                    device.executeShellCommand("am force-stop " + pkgName, (IShellOutputReceiver)new NullOutputReceiver());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/idea/run/tasks/ConnectJavaDebuggerTask$1", "processTerminated"));
            }
        });
        return debugProcessHandler;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicationIds";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugger";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentLaunchInfo";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "client";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launchStatus";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "printer";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/run/tasks/ConnectJavaDebuggerTask";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "launchDebugger";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

