/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.tasks;

import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.android.ddmlib.IDevice;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.LaunchInfo;
import com.android.tools.idea.run.ProcessHandlerConsolePrinter;
import com.android.tools.idea.run.editor.AndroidDebugger;
import com.android.tools.idea.run.tasks.DebugConnectorTask;
import com.android.tools.idea.run.util.LaunchStatus;
import com.android.tools.idea.run.util.ProcessHandlerLaunchStatus;
import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Uninterruptibles;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.breakpoints.XBreakpointManager;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ConnectDebuggerTask
implements DebugConnectorTask {
    private static final int POLL_TIMEOUT = 15;
    private static final TimeUnit POLL_TIMEUNIT = TimeUnit.SECONDS;
    @NotNull
    private final Set<String> myApplicationIds;
    @NotNull
    protected final AndroidDebugger myDebugger;
    @NotNull
    protected final Project myProject;
    protected final boolean myMonitorRemoteProcess;

    protected ConnectDebuggerTask(@NotNull Set<String> applicationIds, @NotNull AndroidDebugger debugger, @NotNull Project project, boolean monitorRemoteProcess) {
        if (applicationIds == null) {
            ConnectDebuggerTask.$$$reportNull$$$0(0);
        }
        if (debugger == null) {
            ConnectDebuggerTask.$$$reportNull$$$0(1);
        }
        if (project == null) {
            ConnectDebuggerTask.$$$reportNull$$$0(2);
        }
        this.myApplicationIds = applicationIds;
        this.myDebugger = debugger;
        this.myProject = project;
        this.myMonitorRemoteProcess = monitorRemoteProcess;
    }

    @Override
    @NotNull
    public String getDescription() {
        if ("Connecting Debugger" == null) {
            ConnectDebuggerTask.$$$reportNull$$$0(3);
        }
        return "Connecting Debugger";
    }

    @Override
    public int getDuration() {
        return 10;
    }

    @Override
    public ProcessHandler perform(final @NotNull LaunchInfo launchInfo, @NotNull IDevice device, final @NotNull ProcessHandlerLaunchStatus state, final @NotNull ProcessHandlerConsolePrinter printer) {
        if (launchInfo == null) {
            ConnectDebuggerTask.$$$reportNull$$$0(4);
        }
        if (device == null) {
            ConnectDebuggerTask.$$$reportNull$$$0(5);
        }
        if (state == null) {
            ConnectDebuggerTask.$$$reportNull$$$0(6);
        }
        if (printer == null) {
            ConnectDebuggerTask.$$$reportNull$$$0(7);
        }
        this.logUnsupportedBreakpoints(device.getVersion(), printer);
        final Client client = this.waitForClient(device, state, printer);
        if (client == null) {
            return null;
        }
        return (ProcessHandler)UIUtil.invokeAndWaitIfNeeded((Computable)new Computable<ProcessHandler>(){

            public ProcessHandler compute() {
                return ConnectDebuggerTask.this.launchDebugger(launchInfo, client, state, printer);
            }
        });
    }

    private void logUnsupportedBreakpoints(@NotNull AndroidVersion version, final @NotNull ConsolePrinter printer) {
        if (version == null) {
            ConnectDebuggerTask.$$$reportNull$$$0(8);
        }
        if (printer == null) {
            ConnectDebuggerTask.$$$reportNull$$$0(9);
        }
        final HashSet allBpTypes = Sets.newHashSet();
        for (AndroidDebugger androidDebugger : (AndroidDebugger[])AndroidDebugger.EP_NAME.getExtensions()) {
            allBpTypes.addAll(androidDebugger.getSupportedBreakpointTypes(this.myProject, version));
        }
        allBpTypes.removeAll(this.myDebugger.getSupportedBreakpointTypes(this.myProject, version));
        if (allBpTypes.isEmpty()) {
            return;
        }
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                XBreakpointManager bpManager = XDebuggerManager.getInstance((Project)ConnectDebuggerTask.this.myProject).getBreakpointManager();
                for (XBreakpointType bpType : allBpTypes) {
                    Collection bps = bpManager.getBreakpoints(bpType);
                    if (bps.isEmpty()) continue;
                    String warnMsg = String.format("The currently selected %1$s debugger doesn't support breakpoints of type '%2$s'. As a result, these breakpoints will not be hit.\nThe debugger selection can be modified in the run configuration dialog.", ConnectDebuggerTask.this.myDebugger.getDisplayName(), bpType.getTitle());
                    printer.stderr(warnMsg);
                    Logger.getInstance(ConnectDebuggerTask.class).info(warnMsg);
                    return;
                }
            }
        });
    }

    @Nullable
    protected Client waitForClient(@NotNull IDevice device, @NotNull LaunchStatus state, @NotNull ConsolePrinter printer) {
        if (device == null) {
            ConnectDebuggerTask.$$$reportNull$$$0(10);
        }
        if (state == null) {
            ConnectDebuggerTask.$$$reportNull$$$0(11);
        }
        if (printer == null) {
            ConnectDebuggerTask.$$$reportNull$$$0(12);
        }
        HashSet<Client> instantApps = new HashSet<Client>();
        for (int i = 0; i < 15; ++i) {
            if (state.isLaunchTerminated()) {
                return null;
            }
            if (!device.isOnline()) {
                printer.stderr("Device is offline");
                return null;
            }
            block8: for (String name : this.myApplicationIds) {
                Client client = device.getClient(name);
                if (client == null) {
                    printer.stdout("Waiting for application to come online: " + Joiner.on((String)" | ").join(this.myApplicationIds));
                    continue;
                }
                if (instantApps.contains(client) && this.isReadyForDebugging(client, printer)) {
                    return client;
                }
                printer.stdout("Connecting to " + name);
                ClientData.DebuggerStatus status = client.getClientData().getDebuggerConnectionStatus();
                switch (status) {
                    case ERROR: {
                        String message = String.format(Locale.US, "Debug port (%1$d) is busy, make sure there is no other active debug connection to the same application", client.getDebuggerListenPort());
                        printer.stderr(message);
                        return null;
                    }
                    case ATTACHED: {
                        printer.stderr("A debugger is already attached");
                        return null;
                    }
                    case WAITING: {
                        if (!this.isReadyForDebugging(client, printer)) continue block8;
                        return client;
                    }
                }
                printer.stderr("Waiting for application to start debug server");
            }
            for (Client client : device.getClients()) {
                String name = client.getClientData().getClientDescription();
                if (!StringUtil.isNotEmpty((String)name) || !name.startsWith("com.google.android.instantapps.supervisor.isolated")) continue;
                try {
                    client.refreshName();
                    instantApps.add(client);
                }
                catch (IOException e) {
                    printer.stderr("Cannot update Instant App process");
                    return null;
                }
            }
            Uninterruptibles.sleepUninterruptibly((long)1L, (TimeUnit)POLL_TIMEUNIT);
        }
        printer.stderr("Could not connect to remote process. Aborting debug session.");
        return null;
    }

    public boolean isReadyForDebugging(@NotNull Client client, @NotNull ConsolePrinter printer) {
        if (client == null) {
            ConnectDebuggerTask.$$$reportNull$$$0(13);
        }
        if (printer == null) {
            ConnectDebuggerTask.$$$reportNull$$$0(14);
        }
        return true;
    }

    @Nullable
    public abstract ProcessHandler launchDebugger(@NotNull LaunchInfo var1, @NotNull Client var2, @NotNull ProcessHandlerLaunchStatus var3, @NotNull ProcessHandlerConsolePrinter var4);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicationIds";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugger";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/run/tasks/ConnectDebuggerTask";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launchInfo";
                break;
            }
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 7: 
            case 9: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "printer";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "client";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/run/tasks/ConnectDebuggerTask";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "perform";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "logUnsupportedBreakpoints";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "waitForClient";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isReadyForDebugging";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

