/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.tools.idea.res.DynamicResourceValueRepository;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.MultiResourceRepository;
import com.android.tools.idea.res.ResourceFolderRegistry;
import com.android.tools.idea.res.ResourceFolderRepository;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.ResourceFolderManager;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ModuleResourceRepository
extends MultiResourceRepository {
    private final AndroidFacet myFacet;
    private final ResourceFolderManager.ResourceFolderListener myResourceFolderListener;

    private ModuleResourceRepository(@NotNull AndroidFacet facet, @NotNull List<? extends LocalResourceRepository> delegates) {
        if (facet == null) {
            ModuleResourceRepository.$$$reportNull$$$0(0);
        }
        if (delegates == null) {
            ModuleResourceRepository.$$$reportNull$$$0(1);
        }
        super(facet.getModule().getName(), delegates);
        this.myResourceFolderListener = new ResourceFolderManager.ResourceFolderListener(){

            @Override
            public void resourceFoldersChanged(@NotNull AndroidFacet facet, @NotNull List<VirtualFile> folders, @NotNull Collection<VirtualFile> added, @NotNull Collection<VirtualFile> removed) {
                if (facet == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (folders == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (added == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (removed == null) {
                    1.$$$reportNull$$$0(3);
                }
                ModuleResourceRepository.this.updateRoots();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "facet";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "folders";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "added";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[0] = "removed";
                        break;
                    }
                }
                objectArray[1] = "com/android/tools/idea/res/ModuleResourceRepository$1";
                objectArray[2] = "resourceFoldersChanged";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        this.myFacet = facet;
        this.myFacet.getResourceFolderManager().addListener(this.myResourceFolderListener);
    }

    @Nullable
    public static LocalResourceRepository getModuleResources(@NotNull Module module, boolean createIfNecessary) {
        AndroidFacet facet;
        if (module == null) {
            ModuleResourceRepository.$$$reportNull$$$0(2);
        }
        if ((facet = AndroidFacet.getInstance(module)) != null) {
            return facet.getModuleResources(createIfNecessary);
        }
        return null;
    }

    @Contract(value="!null, true -> !null")
    @Nullable
    public static LocalResourceRepository getModuleResources(@NotNull AndroidFacet facet, boolean createIfNecessary) {
        if (facet == null) {
            ModuleResourceRepository.$$$reportNull$$$0(3);
        }
        return facet.getModuleResources(createIfNecessary);
    }

    @NotNull
    public static LocalResourceRepository create(@NotNull AndroidFacet facet) {
        boolean gradleProject;
        if (facet == null) {
            ModuleResourceRepository.$$$reportNull$$$0(4);
        }
        if (!(gradleProject = facet.requiresAndroidModel())) {
            VirtualFile primaryResourceDir = facet.getPrimaryResourceDir();
            if (primaryResourceDir == null) {
                EmptyRepository emptyRepository = new EmptyRepository();
                if (emptyRepository == null) {
                    ModuleResourceRepository.$$$reportNull$$$0(5);
                }
                return emptyRepository;
            }
            ResourceFolderRepository resourceFolderRepository = ResourceFolderRegistry.get(facet, primaryResourceDir);
            if (resourceFolderRepository == null) {
                ModuleResourceRepository.$$$reportNull$$$0(6);
            }
            return resourceFolderRepository;
        }
        ResourceFolderManager folderManager = facet.getResourceFolderManager();
        List<VirtualFile> resourceDirectories = folderManager.getFolders();
        ArrayList resources = Lists.newArrayListWithExpectedSize((int)resourceDirectories.size());
        for (VirtualFile resourceDirectory : resourceDirectories) {
            ResourceFolderRepository repository = ResourceFolderRegistry.get(facet, resourceDirectory);
            resources.add(repository);
        }
        DynamicResourceValueRepository dynamicResources = DynamicResourceValueRepository.create(facet);
        resources.add(dynamicResources);
        ModuleResourceRepository repository = new ModuleResourceRepository(facet, (List<? extends LocalResourceRepository>)resources);
        Disposer.register((Disposable)repository, (Disposable)dynamicResources);
        ModuleResourceRepository moduleResourceRepository = repository;
        if (moduleResourceRepository == null) {
            ModuleResourceRepository.$$$reportNull$$$0(7);
        }
        return moduleResourceRepository;
    }

    private void updateRoots() {
        this.updateRoots(this.myFacet.getResourceFolderManager().getFolders());
    }

    void updateRoots(List<VirtualFile> resourceDirectories) {
        List other = null;
        HashMap map = Maps.newHashMap();
        for (LocalResourceRepository repository : this.myChildren) {
            if (repository instanceof ResourceFolderRepository) {
                ResourceFolderRepository folderRepository = (ResourceFolderRepository)repository;
                VirtualFile resourceDir = folderRepository.getResourceDir();
                map.put(resourceDir, folderRepository);
                continue;
            }
            assert (repository instanceof DynamicResourceValueRepository);
            if (other == null) {
                other = Lists.newArrayList();
            }
            other.add(repository);
        }
        HashSet newDirs = Sets.newHashSet(resourceDirectories);
        ArrayList resources = Lists.newArrayListWithExpectedSize((int)(newDirs.size() + (other != null ? other.size() : 0)));
        for (VirtualFile dir : resourceDirectories) {
            ResourceFolderRepository repository = (ResourceFolderRepository)((Object)map.get(dir));
            if (repository == null) {
                repository = ResourceFolderRegistry.get(this.myFacet, dir);
            } else {
                map.remove(dir);
            }
            resources.add(repository);
        }
        if (other != null) {
            resources.addAll(other);
        }
        if (resources.equals(this.myChildren)) {
            assert (map.isEmpty());
            return;
        }
        for (ResourceFolderRepository removed : map.values()) {
            removed.removeParent(this);
        }
        this.setChildren(resources);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.myFacet.getResourceFolderManager().removeListener(this.myResourceFolderListener);
    }

    @NotNull
    public static ModuleResourceRepository createForTest(@NotNull AndroidFacet facet, @NotNull Collection<VirtualFile> resourceDirectories) {
        if (facet == null) {
            ModuleResourceRepository.$$$reportNull$$$0(8);
        }
        if (resourceDirectories == null) {
            ModuleResourceRepository.$$$reportNull$$$0(9);
        }
        ModuleResourceRepository moduleResourceRepository = ModuleResourceRepository.createForTest(facet, resourceDirectories, Collections.emptyList());
        if (moduleResourceRepository == null) {
            ModuleResourceRepository.$$$reportNull$$$0(10);
        }
        return moduleResourceRepository;
    }

    @NotNull
    public static ModuleResourceRepository createForTest(@NotNull AndroidFacet facet, @NotNull Collection<VirtualFile> resourceDirectories, @NotNull Collection<LocalResourceRepository> otherDelegates) {
        if (facet == null) {
            ModuleResourceRepository.$$$reportNull$$$0(11);
        }
        if (resourceDirectories == null) {
            ModuleResourceRepository.$$$reportNull$$$0(12);
        }
        if (otherDelegates == null) {
            ModuleResourceRepository.$$$reportNull$$$0(13);
        }
        assert (ApplicationManager.getApplication().isUnitTestMode());
        ArrayList<LocalResourceRepository> delegates = new ArrayList<LocalResourceRepository>(resourceDirectories.size() + otherDelegates.size());
        for (VirtualFile resourceDirectory : resourceDirectories) {
            delegates.add(ResourceFolderRegistry.get(facet, resourceDirectory));
        }
        delegates.addAll(otherDelegates);
        ModuleResourceRepository moduleResourceRepository = new ModuleResourceRepository(facet, delegates);
        if (moduleResourceRepository == null) {
            ModuleResourceRepository.$$$reportNull$$$0(14);
        }
        return moduleResourceRepository;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegates";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/res/ModuleResourceRepository";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceDirectories";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherDelegates";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/res/ModuleResourceRepository";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 10: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createForTest";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getModuleResources";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 14: {
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createForTest";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class EmptyRepository
    extends MultiResourceRepository {
        public EmptyRepository() {
            super("", Collections.emptyList());
        }

        @Override
        protected void setChildren(@NotNull List<? extends LocalResourceRepository> children) {
            if (children == null) {
                EmptyRepository.$$$reportNull$$$0(0);
            }
            this.myChildren = children;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "children", "com/android/tools/idea/res/ModuleResourceRepository$EmptyRepository", "setChildren"));
        }
    }
}

