/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering.multi;

import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.SdkVersionInfo;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompatibilityRenderTarget
implements IAndroidTarget {
    private final int myApiLevel;
    private final IAndroidTarget myDelegate;
    private final AndroidVersion myVersion;
    private final IAndroidTarget myRealTarget;
    private final String myHashString;

    public CompatibilityRenderTarget(@NotNull IAndroidTarget delegate, int apiLevel, @Nullable IAndroidTarget realTarget) {
        if (delegate == null) {
            CompatibilityRenderTarget.$$$reportNull$$$0(0);
        }
        this.myDelegate = delegate;
        this.myApiLevel = apiLevel;
        this.myRealTarget = realTarget;
        this.myVersion = realTarget != null ? realTarget.getVersion() : new AndroidVersion(apiLevel, null);
        this.myHashString = "compat-" + AndroidTargetHash.getPlatformHashString((AndroidVersion)this.myVersion);
    }

    public static IAndroidTarget copyWithNewDelegate(@NotNull CompatibilityRenderTarget original, @NotNull IAndroidTarget newDelegate) {
        if (original == null) {
            CompatibilityRenderTarget.$$$reportNull$$$0(1);
        }
        if (newDelegate == null) {
            CompatibilityRenderTarget.$$$reportNull$$$0(2);
        }
        return new CompatibilityRenderTarget(newDelegate, original.myApiLevel, original.myRealTarget);
    }

    @NotNull
    public IAndroidTarget getRenderTarget() {
        IAndroidTarget iAndroidTarget = this.myDelegate;
        if (iAndroidTarget == null) {
            CompatibilityRenderTarget.$$$reportNull$$$0(3);
        }
        return iAndroidTarget;
    }

    @Nullable
    public IAndroidTarget getRealTarget() {
        return this.myRealTarget;
    }

    public String getDescription() {
        return this.myDelegate.getDescription();
    }

    public AndroidVersion getVersion() {
        return this.myVersion;
    }

    public String getVersionName() {
        String name = SdkVersionInfo.getAndroidName((int)this.myApiLevel);
        if (name == null) {
            name = Integer.toString(this.myApiLevel);
        }
        return name;
    }

    public String hashString() {
        return this.myHashString;
    }

    public int compareTo(IAndroidTarget other) {
        int delta = this.myApiLevel - other.getVersion().getApiLevel();
        if (delta != 0) {
            return delta;
        }
        return this.myDelegate.compareTo((Object)other);
    }

    public int getRevision() {
        return 1;
    }

    public String getPath(int pathId) {
        return this.myDelegate.getPath(pathId);
    }

    public File getFile(int pathId) {
        return this.myDelegate.getFile(pathId);
    }

    public String getLocation() {
        return this.myDelegate.getLocation();
    }

    public String getVendor() {
        return this.myDelegate.getVendor();
    }

    public String getName() {
        return this.myDelegate.getName();
    }

    public String getFullName() {
        return this.myDelegate.getFullName();
    }

    public String getClasspathName() {
        return this.myDelegate.getClasspathName();
    }

    public String getShortClasspathName() {
        return this.myDelegate.getShortClasspathName();
    }

    public boolean isPlatform() {
        return this.myDelegate.isPlatform();
    }

    public IAndroidTarget getParent() {
        return this.myDelegate.getParent();
    }

    public BuildToolInfo getBuildToolInfo() {
        return this.myDelegate.getBuildToolInfo();
    }

    public List<String> getBootClasspath() {
        return this.myDelegate.getBootClasspath();
    }

    public boolean hasRenderingLibrary() {
        return this.myDelegate.hasRenderingLibrary();
    }

    public File[] getSkins() {
        return this.myDelegate.getSkins();
    }

    @Nullable
    public File getDefaultSkin() {
        return this.myDelegate.getDefaultSkin();
    }

    public List<IAndroidTarget.OptionalLibrary> getOptionalLibraries() {
        return this.myDelegate.getOptionalLibraries();
    }

    public List<IAndroidTarget.OptionalLibrary> getAdditionalLibraries() {
        return this.myDelegate.getAdditionalLibraries();
    }

    public String[] getPlatformLibraries() {
        return this.myDelegate.getPlatformLibraries();
    }

    public String getProperty(String name) {
        return this.myDelegate.getProperty(name);
    }

    public Map<String, String> getProperties() {
        return this.myDelegate.getProperties();
    }

    public boolean canRunOn(IAndroidTarget target) {
        return this.myDelegate.canRunOn(target);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newDelegate";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/rendering/multi/CompatibilityRenderTarget";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/rendering/multi/CompatibilityRenderTarget";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRenderTarget";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "copyWithNewDelegate";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

