/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.ide.common.rendering.api.RenderSession;
import com.android.ide.common.rendering.api.Result;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.tools.idea.rendering.ImagePool;
import com.android.tools.idea.rendering.RenderLogger;
import com.android.tools.idea.rendering.RenderTask;
import com.android.util.PropertiesMap;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenderResult {
    @NotNull
    private final PsiFile myFile;
    @NotNull
    private final RenderLogger myLogger;
    @NotNull
    private final List<ViewInfo> myRootViews;
    @NotNull
    private final List<ViewInfo> mySystemRootViews;
    @NotNull
    private final ImagePool.Image myImage;
    @Nullable
    private final RenderTask myRenderTask;
    @NotNull
    private final Result myRenderResult;
    @NotNull
    private final Map<Object, PropertiesMap> myDefaultProperties;
    @NotNull
    private final Module myModule;

    protected RenderResult(@NotNull PsiFile file, @NotNull Module module, @NotNull RenderLogger logger, @Nullable RenderTask renderTask, @NotNull Result renderResult, @NotNull List<ViewInfo> rootViews, @NotNull List<ViewInfo> systemRootViews, @NotNull ImagePool.Image image, @NotNull Map<Object, PropertiesMap> defaultProperties) {
        if (file == null) {
            RenderResult.$$$reportNull$$$0(0);
        }
        if (module == null) {
            RenderResult.$$$reportNull$$$0(1);
        }
        if (logger == null) {
            RenderResult.$$$reportNull$$$0(2);
        }
        if (renderResult == null) {
            RenderResult.$$$reportNull$$$0(3);
        }
        if (rootViews == null) {
            RenderResult.$$$reportNull$$$0(4);
        }
        if (systemRootViews == null) {
            RenderResult.$$$reportNull$$$0(5);
        }
        if (image == null) {
            RenderResult.$$$reportNull$$$0(6);
        }
        if (defaultProperties == null) {
            RenderResult.$$$reportNull$$$0(7);
        }
        this.myRenderTask = renderTask;
        this.myModule = module;
        this.myFile = file;
        this.myLogger = logger;
        this.myRenderResult = renderResult;
        this.myRootViews = rootViews;
        this.mySystemRootViews = systemRootViews;
        this.myImage = image;
        this.myDefaultProperties = defaultProperties;
    }

    @NotNull
    public static RenderResult create(@NotNull RenderTask renderTask, @NotNull RenderSession session, @NotNull PsiFile file, @NotNull RenderLogger logger, @NotNull ImagePool.Image image) {
        if (renderTask == null) {
            RenderResult.$$$reportNull$$$0(8);
        }
        if (session == null) {
            RenderResult.$$$reportNull$$$0(9);
        }
        if (file == null) {
            RenderResult.$$$reportNull$$$0(10);
        }
        if (logger == null) {
            RenderResult.$$$reportNull$$$0(11);
        }
        if (image == null) {
            RenderResult.$$$reportNull$$$0(12);
        }
        List<ViewInfo> rootViews = session.getRootViews();
        List<ViewInfo> systemRootViews = session.getSystemRootViews();
        Map<Object, PropertiesMap> defaultProperties = session.getDefaultProperties();
        RenderResult renderResult = new RenderResult(file, renderTask.getModule(), logger, renderTask, session.getResult(), rootViews != null ? rootViews : Collections.emptyList(), systemRootViews != null ? systemRootViews : Collections.emptyList(), image, defaultProperties != null ? defaultProperties : Collections.emptyMap());
        if (renderResult == null) {
            RenderResult.$$$reportNull$$$0(13);
        }
        return renderResult;
    }

    @NotNull
    public static RenderResult createSessionInitializationError(@NotNull RenderTask renderTask, @NotNull PsiFile file, @NotNull RenderLogger logger) {
        if (renderTask == null) {
            RenderResult.$$$reportNull$$$0(14);
        }
        if (file == null) {
            RenderResult.$$$reportNull$$$0(15);
        }
        if (logger == null) {
            RenderResult.$$$reportNull$$$0(16);
        }
        RenderResult renderResult = new RenderResult(file, renderTask.getModule(), logger, renderTask, Result.Status.ERROR_UNKNOWN.createResult("Failed to initialize session"), Collections.emptyList(), Collections.emptyList(), ImagePool.NULL_POOLED_IMAGE, Collections.emptyMap());
        if (renderResult == null) {
            RenderResult.$$$reportNull$$$0(17);
        }
        return renderResult;
    }

    @NotNull
    public static RenderResult createBlank(@NotNull PsiFile file) {
        if (file == null) {
            RenderResult.$$$reportNull$$$0(18);
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        assert (module != null);
        RenderResult renderResult = new RenderResult(file, module, new RenderLogger(null, module), null, Result.Status.ERROR_UNKNOWN.createResult(""), Collections.emptyList(), Collections.emptyList(), ImagePool.NULL_POOLED_IMAGE, Collections.emptyMap());
        if (renderResult == null) {
            RenderResult.$$$reportNull$$$0(19);
        }
        return renderResult;
    }

    @NotNull
    public Result getRenderResult() {
        Result result = this.myRenderResult;
        if (result == null) {
            RenderResult.$$$reportNull$$$0(20);
        }
        return result;
    }

    @NotNull
    public RenderLogger getLogger() {
        RenderLogger renderLogger = this.myLogger;
        if (renderLogger == null) {
            RenderResult.$$$reportNull$$$0(21);
        }
        return renderLogger;
    }

    @NotNull
    public ImagePool.Image getRenderedImage() {
        ImagePool.Image image = this.myImage != null ? this.myImage : ImagePool.NULL_POOLED_IMAGE;
        if (image == null) {
            RenderResult.$$$reportNull$$$0(22);
        }
        return image;
    }

    public boolean hasImage() {
        return this.myImage != null && this.myImage != ImagePool.NULL_POOLED_IMAGE;
    }

    @NotNull
    public PsiFile getFile() {
        PsiFile psiFile = this.myFile;
        if (psiFile == null) {
            RenderResult.$$$reportNull$$$0(23);
        }
        return psiFile;
    }

    @Nullable
    public RenderTask getRenderTask() {
        return this.myRenderTask;
    }

    @NotNull
    public Module getModule() {
        Module module = this.myModule;
        if (module == null) {
            RenderResult.$$$reportNull$$$0(24);
        }
        return module;
    }

    @NotNull
    public List<ViewInfo> getRootViews() {
        List<ViewInfo> list = this.myRootViews;
        if (list == null) {
            RenderResult.$$$reportNull$$$0(25);
        }
        return list;
    }

    @NotNull
    public List<ViewInfo> getSystemRootViews() {
        List<ViewInfo> list = this.mySystemRootViews;
        if (list == null) {
            RenderResult.$$$reportNull$$$0(26);
        }
        return list;
    }

    @NotNull
    public Map<Object, PropertiesMap> getDefaultProperties() {
        Map<Object, PropertiesMap> map = this.myDefaultProperties;
        if (map == null) {
            RenderResult.$$$reportNull$$$0(27);
        }
        return map;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logger";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderResult";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootViews";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "systemRootViews";
                break;
            }
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "image";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultProperties";
                break;
            }
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderTask";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 13: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/rendering/RenderResult";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/rendering/RenderResult";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createSessionInitializationError";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createBlank";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getRenderResult";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getRenderedImage";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getModule";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootViews";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemRootViews";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultProperties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 13: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createSessionInitializationError";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createBlank";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

