/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.ide.common.resources.ResourceResolver;
import com.android.tools.idea.rendering.GutterIconCache;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import java.io.File;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GutterIconRenderer
extends com.intellij.openapi.editor.markup.GutterIconRenderer
implements DumbAware {
    private final PsiElement myElement;
    private final File myFile;
    private final ResourceResolver myResourceResolver;
    private Icon myIcon;

    public GutterIconRenderer(ResourceResolver resourceResolver, @NotNull PsiElement element, @Nullable File file) {
        if (element == null) {
            GutterIconRenderer.$$$reportNull$$$0(0);
        }
        this.myResourceResolver = resourceResolver;
        this.myElement = element;
        this.myFile = file;
    }

    @NotNull
    public Icon getIcon() {
        if (this.myIcon == null) {
            if (this.myFile != null) {
                this.myIcon = GutterIconCache.getInstance().getIcon(this.myFile.getPath(), this.myResourceResolver);
            }
            if (this.myIcon == null) {
                this.myIcon = AllIcons.General.Error;
            }
        }
        Icon icon = this.myIcon;
        if (icon == null) {
            GutterIconRenderer.$$$reportNull$$$0(1);
        }
        return icon;
    }

    @Nullable
    public AnAction getClickAction() {
        return new AnAction(){

            public void actionPerformed(AnActionEvent e) {
                Editor editor = (Editor)CommonDataKeys.EDITOR.getData(e.getDataContext());
                if (editor != null) {
                    Project project = editor.getProject();
                    VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByIoFile(GutterIconRenderer.this.myFile);
                    if (project != null && virtualFile != null) {
                        OpenFileDescriptor descriptor = new OpenFileDescriptor(project, virtualFile, -1);
                        FileEditorManager.getInstance((Project)project).openEditor(descriptor, true);
                    }
                }
            }
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        GutterIconRenderer that = (GutterIconRenderer)((Object)o);
        if (!this.myElement.equals(that.myElement)) {
            return false;
        }
        return this.myFile.equals(that.myFile);
    }

    public int hashCode() {
        int result = this.myElement.hashCode();
        result = 31 * result + this.myFile.hashCode();
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/rendering/GutterIconRenderer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/rendering/GutterIconRenderer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

