/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.template;

import com.android.tools.idea.npw.assetstudio.icon.AndroidIconGenerator;
import com.android.tools.idea.npw.platform.AndroidVersionsInfo;
import com.android.tools.idea.npw.project.AndroidProjectPaths;
import com.android.tools.idea.npw.project.AndroidSourceSet;
import com.android.tools.idea.npw.template.TemplateHandle;
import com.android.tools.idea.templates.Template;
import com.android.tools.idea.templates.TemplateUtils;
import com.android.tools.idea.templates.recipe.RenderingContext;
import com.android.tools.idea.ui.properties.core.ObjectProperty;
import com.android.tools.idea.ui.properties.core.ObjectValueProperty;
import com.android.tools.idea.ui.properties.core.OptionalProperty;
import com.android.tools.idea.ui.properties.core.OptionalValueProperty;
import com.android.tools.idea.ui.properties.core.StringProperty;
import com.android.tools.idea.ui.properties.core.StringValueProperty;
import com.android.tools.idea.wizard.model.WizardModel;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RenderTemplateModel
extends WizardModel {
    @NotNull
    private final String myCommandName;
    @NotNull
    private final OptionalProperty<Project> myProject;
    @NotNull
    private final ObjectProperty<AndroidSourceSet> mySourceSet;
    @NotNull
    private final OptionalProperty<AndroidVersionsInfo.VersionItem> myAndroidSdkInfo;
    @NotNull
    private final StringProperty myPackageName;
    @NotNull
    private final Map<String, Object> myTemplateValues;
    @NotNull
    private TemplateHandle myTemplateHandle;
    @Nullable
    private AndroidIconGenerator myIconGenerator;

    public RenderTemplateModel(@NotNull Project project, @NotNull TemplateHandle templateHandle, @NotNull String initialPackageSuggestion, @NotNull AndroidSourceSet sourceSet, @NotNull String commandName) {
        if (project == null) {
            RenderTemplateModel.$$$reportNull$$$0(0);
        }
        if (templateHandle == null) {
            RenderTemplateModel.$$$reportNull$$$0(1);
        }
        if (initialPackageSuggestion == null) {
            RenderTemplateModel.$$$reportNull$$$0(2);
        }
        if (sourceSet == null) {
            RenderTemplateModel.$$$reportNull$$$0(3);
        }
        if (commandName == null) {
            RenderTemplateModel.$$$reportNull$$$0(4);
        }
        this.myAndroidSdkInfo = new OptionalValueProperty<AndroidVersionsInfo.VersionItem>();
        this.myTemplateValues = Maps.newHashMap();
        this.myProject = new OptionalValueProperty<Project>(project);
        this.myPackageName = new StringValueProperty(initialPackageSuggestion);
        this.mySourceSet = new ObjectValueProperty<AndroidSourceSet>(sourceSet);
        this.myTemplateHandle = templateHandle;
        this.myCommandName = commandName;
    }

    public RenderTemplateModel(@NotNull OptionalProperty<Project> project, @NotNull StringProperty packageName, @NotNull TemplateHandle templateHandle, @NotNull AndroidSourceSet sourceSet, @NotNull String commandName) {
        if (project == null) {
            RenderTemplateModel.$$$reportNull$$$0(5);
        }
        if (packageName == null) {
            RenderTemplateModel.$$$reportNull$$$0(6);
        }
        if (templateHandle == null) {
            RenderTemplateModel.$$$reportNull$$$0(7);
        }
        if (sourceSet == null) {
            RenderTemplateModel.$$$reportNull$$$0(8);
        }
        if (commandName == null) {
            RenderTemplateModel.$$$reportNull$$$0(9);
        }
        this.myAndroidSdkInfo = new OptionalValueProperty<AndroidVersionsInfo.VersionItem>();
        this.myTemplateValues = Maps.newHashMap();
        this.myProject = project;
        this.myPackageName = packageName;
        this.mySourceSet = new ObjectValueProperty<AndroidSourceSet>(sourceSet);
        this.myTemplateHandle = templateHandle;
        this.myCommandName = commandName;
    }

    private static Logger getLog() {
        return Logger.getInstance(RenderTemplateModel.class);
    }

    @NotNull
    public Map<String, Object> getTemplateValues() {
        Map<String, Object> map = this.myTemplateValues;
        if (map == null) {
            RenderTemplateModel.$$$reportNull$$$0(10);
        }
        return map;
    }

    @NotNull
    public ObjectProperty<AndroidSourceSet> getSourceSet() {
        ObjectProperty<AndroidSourceSet> objectProperty = this.mySourceSet;
        if (objectProperty == null) {
            RenderTemplateModel.$$$reportNull$$$0(11);
        }
        return objectProperty;
    }

    @NotNull
    public StringProperty packageName() {
        StringProperty stringProperty = this.myPackageName;
        if (stringProperty == null) {
            RenderTemplateModel.$$$reportNull$$$0(12);
        }
        return stringProperty;
    }

    public void setTemplateHandle(@NotNull TemplateHandle templateHandle) {
        if (templateHandle == null) {
            RenderTemplateModel.$$$reportNull$$$0(13);
        }
        this.myTemplateHandle = templateHandle;
    }

    @NotNull
    public TemplateHandle getTemplateHandle() {
        TemplateHandle templateHandle = this.myTemplateHandle;
        if (templateHandle == null) {
            RenderTemplateModel.$$$reportNull$$$0(14);
        }
        return templateHandle;
    }

    @NotNull
    public OptionalProperty<Project> getProject() {
        OptionalProperty<Project> optionalProperty = this.myProject;
        if (optionalProperty == null) {
            RenderTemplateModel.$$$reportNull$$$0(15);
        }
        return optionalProperty;
    }

    public OptionalProperty<AndroidVersionsInfo.VersionItem> androidSdkInfo() {
        return this.myAndroidSdkInfo;
    }

    public void setIconGenerator(@NotNull AndroidIconGenerator iconGenerator) {
        if (iconGenerator == null) {
            RenderTemplateModel.$$$reportNull$$$0(16);
        }
        this.myIconGenerator = iconGenerator;
    }

    @Override
    protected void handleFinished() {
        ArrayList filesToReformat;
        if (!((Optional)this.myProject.get()).isPresent()) {
            RenderTemplateModel.getLog().error("RenderTemplateModel did not collect expected information and will not complete. Please report this error.");
            return;
        }
        final AndroidProjectPaths paths = ((AndroidSourceSet)this.mySourceSet.get()).getPaths();
        final Project project = this.myProject.getValue();
        boolean canRender = this.renderTemplate(true, project, paths, null, null);
        if (!canRender) {
            return;
        }
        final ArrayList filesToOpen = Lists.newArrayListWithExpectedSize((int)3);
        boolean success = (Boolean)new WriteCommandAction<Boolean>(project, this.myCommandName, new PsiFile[0], (List)(filesToReformat = Lists.newArrayList())){
            final /* synthetic */ List val$filesToReformat;
            {
                this.val$filesToReformat = list2;
                super(arg0, arg1, arg2);
            }

            protected void run(@NotNull Result<Boolean> result) throws Throwable {
                boolean success;
                if (result == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((success = RenderTemplateModel.this.renderTemplate(false, project, paths, filesToOpen, this.val$filesToReformat)) && RenderTemplateModel.this.myIconGenerator != null) {
                    RenderTemplateModel.this.myIconGenerator.generateImageIconsIntoPath(paths);
                }
                result.setResult((Object)success);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/npw/template/RenderTemplateModel$1", "run"));
            }
        }.execute().getResultObject();
        if (success) {
            ApplicationManager.getApplication().invokeLater(() -> TemplateUtils.openEditors(project, filesToOpen, true));
        }
    }

    private boolean renderTemplate(boolean dryRun, @NotNull Project project, @NotNull AndroidProjectPaths paths, @Nullable List<File> filesToOpen, @Nullable List<File> filesToReformat) {
        if (project == null) {
            RenderTemplateModel.$$$reportNull$$$0(17);
        }
        if (paths == null) {
            RenderTemplateModel.$$$reportNull$$$0(18);
        }
        Template template = this.myTemplateHandle.getTemplate();
        File moduleRoot = paths.getModuleRoot();
        if (moduleRoot == null) {
            return false;
        }
        RenderingContext context = RenderingContext.Builder.newContext(template, project).withCommandName(this.myCommandName).withDryRun(dryRun).withShowErrors(true).withModuleRoot(paths.getModuleRoot()).withParams(this.myTemplateValues).intoOpenFiles(filesToOpen).intoTargetFiles(filesToReformat).build();
        return template.render(context);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 7: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateHandle";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialPackageSuggestion";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceSet";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/npw/template/RenderTemplateModel";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iconGenerator";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/npw/template/RenderTemplateModel";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateValues";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceSet";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "packageName";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateHandle";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setTemplateHandle";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setIconGenerator";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "renderTemplate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

