/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.project;

import com.android.builder.model.SourceProvider;
import com.google.common.collect.Iterables;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.IdeaSourceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public final class AndroidProjectPaths {
    @Nullable
    private File myModuleRoot;
    @Nullable
    private File mySrcDirectory;
    @Nullable
    private File myTestDirectory;
    @Nullable
    private File myResDirectory;
    @Nullable
    private File myAidlDirectory;
    @Nullable
    private File myManifestDirectory;

    @NotNull
    static List<SourceProvider> getSourceProviders(@NotNull AndroidFacet androidFacet, @Nullable VirtualFile targetDirectory) {
        if (androidFacet == null) {
            AndroidProjectPaths.$$$reportNull$$$0(0);
        }
        if (targetDirectory != null) {
            List<SourceProvider> list = IdeaSourceProvider.getSourceProvidersForFile(androidFacet, targetDirectory, androidFacet.getMainSourceProvider());
            if (list == null) {
                AndroidProjectPaths.$$$reportNull$$$0(1);
            }
            return list;
        }
        List<SourceProvider> list = IdeaSourceProvider.getAllSourceProviders(androidFacet);
        if (list == null) {
            AndroidProjectPaths.$$$reportNull$$$0(2);
        }
        return list;
    }

    public AndroidProjectPaths(@NotNull File moduleRoot) {
        if (moduleRoot == null) {
            AndroidProjectPaths.$$$reportNull$$$0(3);
        }
        this.myModuleRoot = moduleRoot;
        File baseSrcDir = new File(moduleRoot, "src");
        File baseFlavourDir = new File(baseSrcDir, "main");
        this.mySrcDirectory = new File(baseFlavourDir, "java");
        this.myTestDirectory = Paths.get(baseSrcDir.getPath(), "androidTest", "java").toFile();
        this.myResDirectory = new File(baseFlavourDir, "res");
        this.myAidlDirectory = new File(baseFlavourDir, "aidl");
        this.myManifestDirectory = baseFlavourDir;
    }

    public AndroidProjectPaths(@NotNull AndroidFacet androidFacet) {
        if (androidFacet == null) {
            AndroidProjectPaths.$$$reportNull$$$0(4);
        }
        this(androidFacet, AndroidProjectPaths.getSourceProviders(androidFacet, null).get(0));
    }

    public AndroidProjectPaths(@NotNull AndroidFacet androidFacet, @NotNull SourceProvider sourceProvider) {
        List testsRoot;
        if (androidFacet == null) {
            AndroidProjectPaths.$$$reportNull$$$0(5);
        }
        if (sourceProvider == null) {
            AndroidProjectPaths.$$$reportNull$$$0(6);
        }
        this.init(sourceProvider);
        Module module = androidFacet.getModule();
        VirtualFile[] roots = ModuleRootManager.getInstance((Module)module).getContentRoots();
        if (roots.length > 0) {
            this.myModuleRoot = VfsUtilCore.virtualToIoFile((VirtualFile)roots[0]);
        }
        this.myTestDirectory = (testsRoot = ModuleRootManager.getInstance((Module)module).getSourceRoots(JavaModuleSourceRootTypes.TESTS)).size() == 0 ? null : VfsUtilCore.virtualToIoFile((VirtualFile)((VirtualFile)testsRoot.get(0)));
    }

    public AndroidProjectPaths(@NotNull File moduleRoot, @NotNull File testDirectory, @NotNull SourceProvider sourceProvider) {
        if (moduleRoot == null) {
            AndroidProjectPaths.$$$reportNull$$$0(7);
        }
        if (testDirectory == null) {
            AndroidProjectPaths.$$$reportNull$$$0(8);
        }
        if (sourceProvider == null) {
            AndroidProjectPaths.$$$reportNull$$$0(9);
        }
        this.init(sourceProvider);
        this.myModuleRoot = moduleRoot;
        this.myTestDirectory = testDirectory;
    }

    private void init(@NotNull SourceProvider sourceProvider) {
        Collection aidlDirectories;
        if (sourceProvider == null) {
            AndroidProjectPaths.$$$reportNull$$$0(10);
        }
        this.mySrcDirectory = (File)Iterables.getFirst((Iterable)sourceProvider.getJavaDirectories(), null);
        Collection resDirectories = sourceProvider.getResDirectories();
        if (!resDirectories.isEmpty()) {
            this.myResDirectory = (File)resDirectories.iterator().next();
        }
        if (!(aidlDirectories = sourceProvider.getAidlDirectories()).isEmpty()) {
            this.myAidlDirectory = (File)aidlDirectories.iterator().next();
        }
        this.myManifestDirectory = sourceProvider.getManifestFile().getParentFile();
    }

    @Nullable
    public File getModuleRoot() {
        return this.myModuleRoot;
    }

    @Nullable
    public File getSrcDirectory() {
        return this.mySrcDirectory;
    }

    @Nullable
    public File getTestDirectory() {
        return this.myTestDirectory;
    }

    @Nullable
    public File getResDirectory() {
        return this.myResDirectory;
    }

    @Nullable
    public File getAidlDirectory() {
        return this.myAidlDirectory;
    }

    @Nullable
    public File getManifestDirectory() {
        return this.myManifestDirectory;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidFacet";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/npw/project/AndroidProjectPaths";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleRoot";
                break;
            }
            case 6: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceProvider";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testDirectory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/npw/project/AndroidProjectPaths";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceProviders";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSourceProviders";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

