/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.module;

import com.android.tools.idea.templates.Template;
import com.android.tools.idea.templates.recipe.RenderingContext;
import com.android.tools.idea.ui.properties.core.BoolProperty;
import com.android.tools.idea.ui.properties.core.BoolValueProperty;
import com.android.tools.idea.ui.properties.core.OptionalProperty;
import com.android.tools.idea.ui.properties.core.OptionalValueProperty;
import com.android.tools.idea.ui.properties.core.StringProperty;
import com.android.tools.idea.ui.properties.core.StringValueProperty;
import com.android.tools.idea.wizard.model.WizardModel;
import com.google.common.collect.Maps;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public final class NewModuleModel
extends WizardModel {
    private final StringProperty myApplicationName;
    private final StringProperty myModuleName;
    private final BoolProperty myIsLibrary;
    private final BoolProperty myInstAppEnabled;
    private final OptionalProperty<File> myTemplateFile;
    private final OptionalProperty<Map<String, Object>> myRenderTemplateValues;
    private final Map<String, Object> myTemplateValues;
    @NotNull
    private final StringProperty myPackageName;
    @NotNull
    private final OptionalProperty<Project> myProject;

    public NewModuleModel(@NotNull Project project) {
        if (project == null) {
            NewModuleModel.$$$reportNull$$$0(0);
        }
        this.myApplicationName = new StringValueProperty();
        this.myModuleName = new StringValueProperty();
        this.myIsLibrary = new BoolValueProperty();
        this.myInstAppEnabled = new BoolValueProperty();
        this.myTemplateFile = new OptionalValueProperty<File>();
        this.myRenderTemplateValues = new OptionalValueProperty<Map<String, Object>>();
        this.myTemplateValues = Maps.newHashMap();
        this.myApplicationName.set(AndroidBundle.message("android.wizard.module.config.new.application", new Object[0]));
        this.myIsLibrary.addListener(sender -> this.myApplicationName.set(AndroidBundle.message((Boolean)this.myIsLibrary.get() != false ? "android.wizard.module.config.new.library" : "android.wizard.module.config.new.application", new Object[0])));
        this.myApplicationName.addConstraint(String::trim);
        this.myModuleName.addConstraint(String::trim);
        this.myProject = new OptionalValueProperty<Project>(project);
        this.myPackageName = new StringValueProperty();
    }

    public NewModuleModel(@NotNull OptionalProperty<Project> project, @NotNull StringProperty packageName, @NotNull File templateFile) {
        if (project == null) {
            NewModuleModel.$$$reportNull$$$0(1);
        }
        if (packageName == null) {
            NewModuleModel.$$$reportNull$$$0(2);
        }
        if (templateFile == null) {
            NewModuleModel.$$$reportNull$$$0(3);
        }
        this.myApplicationName = new StringValueProperty();
        this.myModuleName = new StringValueProperty();
        this.myIsLibrary = new BoolValueProperty();
        this.myInstAppEnabled = new BoolValueProperty();
        this.myTemplateFile = new OptionalValueProperty<File>();
        this.myRenderTemplateValues = new OptionalValueProperty<Map<String, Object>>();
        this.myTemplateValues = Maps.newHashMap();
        this.myApplicationName.set(AndroidBundle.message("android.wizard.module.config.new.application", new Object[0]));
        this.myIsLibrary.addListener(sender -> this.myApplicationName.set(AndroidBundle.message((Boolean)this.myIsLibrary.get() != false ? "android.wizard.module.config.new.library" : "android.wizard.module.config.new.application", new Object[0])));
        this.myApplicationName.addConstraint(String::trim);
        this.myModuleName.addConstraint(String::trim);
        this.myProject = project;
        this.myPackageName = packageName;
        this.myTemplateFile.setValue(templateFile);
    }

    @NotNull
    public OptionalProperty<Project> getProject() {
        OptionalProperty<Project> optionalProperty = this.myProject;
        if (optionalProperty == null) {
            NewModuleModel.$$$reportNull$$$0(4);
        }
        return optionalProperty;
    }

    @NotNull
    public StringProperty applicationName() {
        StringProperty stringProperty = this.myApplicationName;
        if (stringProperty == null) {
            NewModuleModel.$$$reportNull$$$0(5);
        }
        return stringProperty;
    }

    @NotNull
    public StringProperty moduleName() {
        StringProperty stringProperty = this.myModuleName;
        if (stringProperty == null) {
            NewModuleModel.$$$reportNull$$$0(6);
        }
        return stringProperty;
    }

    @NotNull
    public StringProperty packageName() {
        StringProperty stringProperty = this.myPackageName;
        if (stringProperty == null) {
            NewModuleModel.$$$reportNull$$$0(7);
        }
        return stringProperty;
    }

    @NotNull
    public BoolProperty isLibrary() {
        BoolProperty boolProperty = this.myIsLibrary;
        if (boolProperty == null) {
            NewModuleModel.$$$reportNull$$$0(8);
        }
        return boolProperty;
    }

    @NotNull
    public BoolProperty isInstAppEnabled() {
        BoolProperty boolProperty = this.myInstAppEnabled;
        if (boolProperty == null) {
            NewModuleModel.$$$reportNull$$$0(9);
        }
        return boolProperty;
    }

    @NotNull
    public OptionalProperty<File> templateFile() {
        OptionalProperty<File> optionalProperty = this.myTemplateFile;
        if (optionalProperty == null) {
            NewModuleModel.$$$reportNull$$$0(10);
        }
        return optionalProperty;
    }

    @NotNull
    public Map<String, Object> getTemplateValues() {
        Map<String, Object> map = this.myTemplateValues;
        if (map == null) {
            NewModuleModel.$$$reportNull$$$0(11);
        }
        return map;
    }

    @NotNull
    public OptionalProperty<Map<String, Object>> getRenderTemplateValues() {
        OptionalProperty<Map<String, Object>> optionalProperty = this.myRenderTemplateValues;
        if (optionalProperty == null) {
            NewModuleModel.$$$reportNull$$$0(12);
        }
        return optionalProperty;
    }

    @Override
    protected void handleFinished() {
        if (this.myTemplateFile.getValueOrNull() == null) {
            return;
        }
        if (!((Optional)this.myProject.get()).isPresent()) {
            NewModuleModel.getLog().error("NewModuleModel did not collect expected information and will not complete. Please report this error.");
            return;
        }
        Map<String, Object> renderTemplateValues = this.myRenderTemplateValues.getValueOrNull();
        final HashMap<String, Object> templateValues = new HashMap<String, Object>();
        if (renderTemplateValues != null) {
            templateValues.putAll(renderTemplateValues);
        }
        templateValues.putAll(this.myTemplateValues);
        templateValues.put("isLibraryProject", this.myIsLibrary.get());
        final Project project = this.myProject.getValue();
        boolean canRender = this.renderModule(true, templateValues, project);
        if (!canRender) {
            return;
        }
        boolean success = (Boolean)new WriteCommandAction<Boolean>(project, "New Module", new PsiFile[0]){

            protected void run(@NotNull Result<Boolean> result) throws Throwable {
                if (result == null) {
                    1.$$$reportNull$$$0(0);
                }
                boolean success = NewModuleModel.this.renderModule(false, templateValues, project);
                result.setResult((Object)success);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/npw/module/NewModuleModel$1", "run"));
            }
        }.execute().getResultObject();
        if (!success) {
            NewModuleModel.getLog().warn("A problem occurred while creating a new Module. Please check the log file for possible errors.");
        }
    }

    private boolean renderModule(boolean dryRun, @NotNull Map<String, Object> templateState, @NotNull Project project) {
        if (templateState == null) {
            NewModuleModel.$$$reportNull$$$0(13);
        }
        if (project == null) {
            NewModuleModel.$$$reportNull$$$0(14);
        }
        File projectRoot = new File(project.getBasePath());
        File moduleRoot = new File(projectRoot, (String)this.myModuleName.get());
        Template template = Template.createFromPath(this.myTemplateFile.getValue());
        RenderingContext context = RenderingContext.Builder.newContext(template, project).withCommandName("New Module").withDryRun(dryRun).withShowErrors(true).withOutputRoot(projectRoot).withModuleRoot(moduleRoot).withParams(templateState).build();
        return template.render(context);
    }

    @NotNull
    private static Logger getLog() {
        Logger logger = Logger.getInstance(NewModuleModel.class);
        if (logger == null) {
            NewModuleModel.$$$reportNull$$$0(15);
        }
        return logger;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateFile";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/npw/module/NewModuleModel";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/npw/module/NewModuleModel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "applicationName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "moduleName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "packageName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "isLibrary";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "isInstAppEnabled";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "templateFile";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateValues";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getRenderTemplateValues";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getLog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: {
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "renderModule";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

