/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.module;

import com.android.tools.idea.npw.FormFactor;
import com.android.tools.idea.npw.module.ConfigureAndroidModuleStep;
import com.android.tools.idea.npw.module.ModuleDescriptionProvider;
import com.android.tools.idea.npw.module.ModuleTemplateGalleryEntry;
import com.android.tools.idea.npw.module.NewModuleModel;
import com.android.tools.idea.templates.TemplateManager;
import com.android.tools.idea.templates.TemplateMetadata;
import com.android.tools.idea.wizard.model.SkippableWizardStep;
import icons.AndroidIcons;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NewAndroidModuleDescriptionProvider
implements ModuleDescriptionProvider {
    public Collection<ModuleTemplateGalleryEntry> getDescriptions() {
        ArrayList<ModuleTemplateGalleryEntry> res = new ArrayList<ModuleTemplateGalleryEntry>();
        TemplateManager manager = TemplateManager.getInstance();
        List<File> applicationTemplates = manager.getTemplatesInCategory("Application");
        for (File templateFile : applicationTemplates) {
            TemplateMetadata metadata = manager.getTemplateMetadata(templateFile);
            if (metadata == null || metadata.getFormFactor() == null) continue;
            int minSdk = metadata.getMinSdk();
            FormFactor formFactor = FormFactor.get(metadata.getFormFactor());
            if (formFactor == FormFactor.CAR || formFactor == FormFactor.GLASS && !AndroidSdkUtils.isGlassInstalled()) continue;
            if (formFactor.equals((Object)FormFactor.MOBILE)) {
                res.add(new AndroidModuleTemplateGalleryEntry(templateFile, formFactor, minSdk, false, AndroidIcons.ModuleTemplates.Mobile, AndroidBundle.message("android.wizard.module.new.mobile", new Object[0]), metadata.getTitle()));
                res.add(new AndroidModuleTemplateGalleryEntry(templateFile, formFactor, minSdk, true, AndroidIcons.ModuleTemplates.Android, AndroidBundle.message("android.wizard.module.new.library", new Object[0]), metadata.getDescription()));
                continue;
            }
            res.add(new AndroidModuleTemplateGalleryEntry(templateFile, formFactor, minSdk, false, NewAndroidModuleDescriptionProvider.getModuleTypeIcon(formFactor), metadata.getTitle(), metadata.getDescription()));
        }
        return res;
    }

    private static Icon getModuleTypeIcon(@NotNull FormFactor enumValue) {
        if (enumValue == null) {
            NewAndroidModuleDescriptionProvider.$$$reportNull$$$0(0);
        }
        switch (enumValue) {
            case CAR: {
                return AndroidIcons.ModuleTemplates.Car;
            }
            case GLASS: {
                return AndroidIcons.ModuleTemplates.Glass;
            }
            case MOBILE: {
                return AndroidIcons.ModuleTemplates.Mobile;
            }
            case TV: {
                return AndroidIcons.ModuleTemplates.Tv;
            }
            case WEAR: {
                return AndroidIcons.ModuleTemplates.Wear;
            }
        }
        throw new IllegalArgumentException(enumValue.name());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumValue", "com/android/tools/idea/npw/module/NewAndroidModuleDescriptionProvider", "getModuleTypeIcon"));
    }

    private static class AndroidModuleTemplateGalleryEntry
    implements ModuleTemplateGalleryEntry {
        private final File myTemplateFile;
        private final FormFactor myFormFactor;
        private final int myMinSdkLevel;
        private final boolean myIsLibrary;
        private final Icon myIcon;
        private final String myName;
        private final String myDescription;

        AndroidModuleTemplateGalleryEntry(File templateFile, FormFactor formFactor, int minSdkLevel, boolean isLibrary, Icon icon, String name, String description) {
            this.myTemplateFile = templateFile;
            this.myFormFactor = formFactor;
            this.myMinSdkLevel = minSdkLevel;
            this.myIsLibrary = isLibrary;
            this.myIcon = icon;
            this.myName = name;
            this.myDescription = description;
        }

        @Override
        @NotNull
        public File getTemplateFile() {
            File file = this.myTemplateFile;
            if (file == null) {
                AndroidModuleTemplateGalleryEntry.$$$reportNull$$$0(0);
            }
            return file;
        }

        @Override
        @NotNull
        public FormFactor getFormFactor() {
            FormFactor formFactor = this.myFormFactor;
            if (formFactor == null) {
                AndroidModuleTemplateGalleryEntry.$$$reportNull$$$0(1);
            }
            return formFactor;
        }

        @Override
        public boolean isLibrary() {
            return this.myIsLibrary;
        }

        @Override
        @Nullable
        public Icon getIcon() {
            return this.myIcon;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                AndroidModuleTemplateGalleryEntry.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        @Nullable
        public String getDescription() {
            return this.myDescription;
        }

        @Override
        @NotNull
        public SkippableWizardStep createStep(@NotNull NewModuleModel model) {
            if (model == null) {
                AndroidModuleTemplateGalleryEntry.$$$reportNull$$$0(3);
            }
            ConfigureAndroidModuleStep configureAndroidModuleStep = new ConfigureAndroidModuleStep(model, this.myFormFactor, this.myMinSdkLevel, this.myName);
            if (configureAndroidModuleStep == null) {
                AndroidModuleTemplateGalleryEntry.$$$reportNull$$$0(4);
            }
            return configureAndroidModuleStep;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/npw/module/NewAndroidModuleDescriptionProvider$AndroidModuleTemplateGalleryEntry";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTemplateFile";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFormFactor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/npw/module/NewAndroidModuleDescriptionProvider$AndroidModuleTemplateGalleryEntry";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createStep";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "createStep";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

