/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.module;

import com.android.tools.idea.npw.FormFactor;
import com.android.tools.idea.npw.platform.AndroidVersionsInfo;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.intellij.ide.util.PropertiesComponent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.JComboBox;
import org.jetbrains.annotations.NotNull;

public final class FormFactorApiComboBox
extends JComboBox<AndroidVersionsInfo.VersionItem> {
    private final ItemListener myItemListener = this::saveSelectedApi;
    private FormFactor myFormFactor;

    public void init(@NotNull FormFactor formFactor, @NotNull List<AndroidVersionsInfo.VersionItem> items) {
        if (formFactor == null) {
            FormFactorApiComboBox.$$$reportNull$$$0(0);
        }
        if (items == null) {
            FormFactorApiComboBox.$$$reportNull$$$0(1);
        }
        this.myFormFactor = formFactor;
        this.removeItemListener(this.myItemListener);
        this.removeAllItems();
        for (AndroidVersionsInfo.VersionItem item : items) {
            this.addItem(item);
        }
        this.loadSavedApi();
        this.addItemListener(this.myItemListener);
    }

    private void loadSavedApi() {
        String savedApiLevel = PropertiesComponent.getInstance().getValue(FormFactorApiComboBox.getPropertiesComponentMinSdkKey(this.myFormFactor), Integer.toString(this.myFormFactor.defaultApi));
        int index = this.getItemCount() > 0 ? 0 : -1;
        for (int i = 0; i < this.getItemCount(); ++i) {
            AndroidVersionsInfo.VersionItem item = (AndroidVersionsInfo.VersionItem)this.getItemAt(i);
            if (!Objects.equal((Object)item.getApiLevelStr(), (Object)savedApiLevel)) continue;
            index = i;
            break;
        }
        this.setSelectedIndex(index);
    }

    private void saveSelectedApi(ItemEvent e) {
        if (e.getStateChange() == 1 && e.getItem() != null) {
            AndroidVersionsInfo.VersionItem item = (AndroidVersionsInfo.VersionItem)e.getItem();
            PropertiesComponent.getInstance().setValue(FormFactorApiComboBox.getPropertiesComponentMinSdkKey(this.myFormFactor), item.getApiLevelStr());
        }
    }

    @VisibleForTesting
    static String getPropertiesComponentMinSdkKey(@NotNull FormFactor formFactor) {
        if (formFactor == null) {
            FormFactorApiComboBox.$$$reportNull$$$0(2);
        }
        return formFactor.id + "minApi";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formFactor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/npw/module/FormFactorApiComboBox";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "init";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getPropertiesComponentMinSdkKey";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

