/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.module;

import com.android.tools.idea.npw.FormFactor;
import com.android.tools.idea.npw.module.ModuleGalleryEntry;
import com.android.tools.idea.npw.module.ModuleTemplateGalleryEntry;
import com.android.tools.idea.npw.module.NewModuleModel;
import com.android.tools.idea.ui.ASGallery;
import com.android.tools.idea.wizard.WizardConstants;
import com.android.tools.idea.wizard.model.ModelWizard;
import com.android.tools.idea.wizard.model.ModelWizardStep;
import com.android.tools.idea.wizard.model.SkippableWizardStep;
import com.android.tools.swing.util.FormScalingUtil;
import com.google.common.collect.Lists;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.IconUtil;
import com.intellij.util.containers.HashMap;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.ListModel;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChooseModuleTypeStep
extends ModelWizardStep<NewModuleModel> {
    private final List<ModuleGalleryEntry> myModuleGalleryEntryList;
    private final JComponent myRootPanel;
    private ASGallery<ModuleGalleryEntry> myFormFactorGallery;
    private Map<ModuleGalleryEntry, SkippableWizardStep> myModuleDescriptionToStepMap;

    public ChooseModuleTypeStep(@NotNull NewModuleModel model, @NotNull List<ModuleGalleryEntry> moduleGalleryEntries) {
        if (model == null) {
            ChooseModuleTypeStep.$$$reportNull$$$0(0);
        }
        if (moduleGalleryEntries == null) {
            ChooseModuleTypeStep.$$$reportNull$$$0(1);
        }
        super(model, AndroidBundle.message("android.wizard.module.new.module.header", new Object[0]));
        this.myModuleGalleryEntryList = ChooseModuleTypeStep.sortModuleEntries(moduleGalleryEntries);
        this.myRootPanel = this.createGallery();
        FormScalingUtil.scaleComponentTree(this.getClass(), this.myRootPanel);
    }

    @Override
    @NotNull
    protected JComponent getComponent() {
        JComponent jComponent = this.myRootPanel;
        if (jComponent == null) {
            ChooseModuleTypeStep.$$$reportNull$$$0(2);
        }
        return jComponent;
    }

    @Override
    @NotNull
    public Collection<? extends ModelWizardStep> createDependentSteps() {
        ArrayList allSteps = Lists.newArrayList();
        this.myModuleDescriptionToStepMap = new HashMap();
        for (ModuleGalleryEntry moduleGalleryEntry : this.myModuleGalleryEntryList) {
            SkippableWizardStep step = moduleGalleryEntry.createStep((NewModuleModel)this.getModel());
            allSteps.add(step);
            this.myModuleDescriptionToStepMap.put(moduleGalleryEntry, step);
        }
        ArrayList arrayList = allSteps;
        if (arrayList == null) {
            ChooseModuleTypeStep.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @NotNull
    private JComponent createGallery() {
        this.myFormFactorGallery = new ASGallery<ModuleGalleryEntry>((ListModel)JBList.createDefaultListModel((Object[])new Object[0]), image -> image.getIcon() == null ? null : IconUtil.toImage((Icon)image.getIcon()), label -> label == null ? AndroidBundle.message("android.wizard.gallery.item.none", new Object[0]) : label.getName(), WizardConstants.DEFAULT_GALLERY_THUMBNAIL_SIZE, null){

            public Dimension getPreferredScrollableViewportSize() {
                Dimension cellSize = this.computeCellSize();
                int heightInsets = this.getInsets().top + this.getInsets().bottom;
                int widthInsets = this.getInsets().left + this.getInsets().right;
                return new Dimension(cellSize.width * 5 + widthInsets, (int)((double)cellSize.height * 2.2) + heightInsets);
            }
        };
        this.myFormFactorGallery.setBorder(BorderFactory.createLineBorder(JBColor.border()));
        AccessibleContext accessibleContext = this.myFormFactorGallery.getAccessibleContext();
        if (accessibleContext != null) {
            accessibleContext.setAccessibleDescription(this.getTitle());
        }
        JBScrollPane jBScrollPane = new JBScrollPane(this.myFormFactorGallery);
        if (jBScrollPane == null) {
            ChooseModuleTypeStep.$$$reportNull$$$0(4);
        }
        return jBScrollPane;
    }

    @Override
    protected void onWizardStarting(final @NotNull ModelWizard.Facade wizard) {
        if (wizard == null) {
            ChooseModuleTypeStep.$$$reportNull$$$0(5);
        }
        this.myFormFactorGallery.setModel(JBList.createDefaultListModel((Object[])this.myModuleGalleryEntryList.toArray()));
        this.myFormFactorGallery.setDefaultAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                wizard.goForward();
            }
        });
        this.myFormFactorGallery.setSelectedIndex(0);
    }

    @Override
    protected void onProceeding() {
        Map<String, Object> templateValues = ((NewModuleModel)this.getModel()).getTemplateValues();
        templateValues.clear();
        ModuleGalleryEntry selectedEntry = this.myFormFactorGallery.getSelectedElement();
        this.myModuleDescriptionToStepMap.forEach((galleryEntry, step) -> {
            boolean shouldShow = galleryEntry == selectedEntry;
            step.setShouldShow(shouldShow);
            if (galleryEntry instanceof ModuleTemplateGalleryEntry) {
                FormFactor formFactor = ((ModuleTemplateGalleryEntry)galleryEntry).getFormFactor();
                templateValues.put(formFactor.id + "included", shouldShow);
            }
        });
        ModuleTemplateGalleryEntry templateEntry = selectedEntry instanceof ModuleTemplateGalleryEntry ? (ModuleTemplateGalleryEntry)selectedEntry : null;
        ((NewModuleModel)this.getModel()).isLibrary().set(templateEntry == null ? false : templateEntry.isLibrary());
        ((NewModuleModel)this.getModel()).templateFile().setNullableValue(templateEntry == null ? null : templateEntry.getTemplateFile());
    }

    @Override
    @Nullable
    protected JComponent getPreferredFocusComponent() {
        return this.myFormFactorGallery;
    }

    @NotNull
    private static List<ModuleGalleryEntry> sortModuleEntries(@NotNull List<ModuleGalleryEntry> moduleTypesProviders) {
        if (moduleTypesProviders == null) {
            ChooseModuleTypeStep.$$$reportNull$$$0(6);
        }
        ArrayList<ModuleGalleryEntry> res = new ArrayList<ModuleGalleryEntry>(moduleTypesProviders);
        Collections.sort(res, (t1, t2) -> {
            FormFactor f2;
            FormFactor f1 = t1 instanceof ModuleTemplateGalleryEntry ? ((ModuleTemplateGalleryEntry)t1).getFormFactor() : null;
            FormFactor formFactor = f2 = t2 instanceof ModuleTemplateGalleryEntry ? ((ModuleTemplateGalleryEntry)t2).getFormFactor() : null;
            if (f1 != null && f2 != null) {
                return f1.compareTo(f2);
            }
            if (f1 != null) {
                return -1;
            }
            if (f2 != null) {
                return 1;
            }
            return StringUtil.naturalCompare((String)t1.getName(), (String)t2.getName());
        });
        ArrayList<ModuleGalleryEntry> arrayList = res;
        if (arrayList == null) {
            ChooseModuleTypeStep.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleGalleryEntries";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/npw/module/ChooseModuleTypeStep";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wizard";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleTypesProviders";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/npw/module/ChooseModuleTypeStep";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createDependentSteps";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createGallery";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "sortModuleEntries";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "onWizardStarting";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "sortModuleEntries";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

