/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.assetstudio.assets;

import com.android.assetstudiolib.TextRenderUtil;
import com.android.tools.idea.npw.assetstudio.assets.BaseAsset;
import com.android.tools.idea.ui.properties.core.IntProperty;
import com.android.tools.idea.ui.properties.core.IntValueProperty;
import com.android.tools.idea.ui.properties.core.StringProperty;
import com.android.tools.idea.ui.properties.core.StringValueProperty;
import com.google.common.collect.Lists;
import java.awt.Color;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class TextAsset
extends BaseAsset {
    private static final String PREFERRED_FONT = "Roboto";
    private final StringProperty myText = new StringValueProperty("Aa");
    private final StringProperty myFontFamily = new StringValueProperty();
    private final IntProperty myFontSize = new IntValueProperty(144);

    public TextAsset() {
        List<String> fontFamilies = TextAsset.getAllFontFamilies();
        assert (fontFamilies.size() > 0);
        if (fontFamilies.contains(PREFERRED_FONT)) {
            this.myFontFamily.set(PREFERRED_FONT);
        } else {
            this.myFontFamily.set(fontFamilies.get(0));
        }
    }

    @NotNull
    public static List<String> getAllFontFamilies() {
        ArrayList arrayList = Lists.newArrayList((Object[])GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames());
        if (arrayList == null) {
            TextAsset.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    @NotNull
    public StringProperty text() {
        StringProperty stringProperty = this.myText;
        if (stringProperty == null) {
            TextAsset.$$$reportNull$$$0(1);
        }
        return stringProperty;
    }

    @NotNull
    public StringProperty fontFamily() {
        StringProperty stringProperty = this.myFontFamily;
        if (stringProperty == null) {
            TextAsset.$$$reportNull$$$0(2);
        }
        return stringProperty;
    }

    @Override
    @NotNull
    protected BufferedImage createAsImage(@NotNull Color color) {
        if (color == null) {
            TextAsset.$$$reportNull$$$0(3);
        }
        TextRenderUtil.Options options = new TextRenderUtil.Options();
        options.font = Font.decode(this.myFontFamily + " " + this.myFontSize.get());
        options.foregroundColor = color.getRGB();
        BufferedImage bufferedImage = TextRenderUtil.renderTextImage((String)((String)this.myText.get()), (int)1, (TextRenderUtil.Options)options);
        if (bufferedImage == null) {
            TextAsset.$$$reportNull$$$0(4);
        }
        return bufferedImage;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/npw/assetstudio/assets/TextAsset";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllFontFamilies";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "text";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "fontFamily";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/npw/assetstudio/assets/TextAsset";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createAsImage";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createAsImage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

