/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw;

import com.android.tools.idea.npw.AddAndroidActivityPath;
import com.android.tools.idea.npw.FormFactor;
import com.android.tools.idea.npw.TemplateEntry;
import com.android.tools.idea.templates.TemplateManager;
import com.android.tools.idea.templates.TemplateMetadata;
import com.android.tools.idea.wizard.WizardConstants;
import com.android.tools.idea.wizard.dynamic.ScopedDataBinder;
import com.android.tools.idea.wizard.dynamic.ScopedStateStore;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class TemplateListProvider
extends ScopedDataBinder.ValueDeriver<TemplateEntry[]> {
    private final TemplateEntry[] myTemplates;

    public TemplateListProvider(@NotNull FormFactor formFactor, @NotNull Set<String> categories, @NotNull Set<String> excluded) {
        if (formFactor == null) {
            TemplateListProvider.$$$reportNull$$$0(0);
        }
        if (categories == null) {
            TemplateListProvider.$$$reportNull$$$0(1);
        }
        if (excluded == null) {
            TemplateListProvider.$$$reportNull$$$0(2);
        }
        ArrayList templates = Lists.newArrayList();
        for (String category : categories) {
            templates.addAll(Arrays.asList(TemplateListProvider.getTemplateList(formFactor, category, excluded)));
        }
        if (formFactor == FormFactor.WEAR) {
            templates.addAll(Arrays.asList(TemplateListProvider.getTemplateList(formFactor, "Wear", excluded)));
        }
        if (formFactor == FormFactor.CAR) {
            templates.addAll(Arrays.asList(TemplateListProvider.getTemplateList(formFactor, "Android Auto", excluded)));
        }
        Collections.sort(templates, (o1, o2) -> {
            TemplateMetadata m1 = o1.getMetadata();
            TemplateMetadata m2 = o2.getMetadata();
            return StringUtil.naturalCompare((String)m1.getTitle(), (String)m2.getTitle());
        });
        this.myTemplates = templates.toArray(new TemplateEntry[templates.size()]);
    }

    private static TemplateEntry[] getTemplateList(@NotNull FormFactor formFactor, @NotNull String category, @Nullable Set<String> excluded) {
        if (formFactor == null) {
            TemplateListProvider.$$$reportNull$$$0(3);
        }
        if (category == null) {
            TemplateListProvider.$$$reportNull$$$0(4);
        }
        TemplateManager manager = TemplateManager.getInstance();
        List<File> templates = manager.getTemplatesInCategory(category);
        ArrayList<TemplateEntry> metadataList = new ArrayList<TemplateEntry>(templates.size());
        for (File template : templates) {
            TemplateMetadata metadata = manager.getTemplateMetadata(template);
            if (metadata == null || !metadata.isSupported() || excluded != null && excluded.contains(metadata.getTitle()) || !formFactor.id.equalsIgnoreCase(metadata.getFormFactor())) continue;
            metadataList.add(new TemplateEntry(template, metadata));
        }
        return (TemplateEntry[])ArrayUtil.toObjectArray(metadataList, TemplateEntry.class);
    }

    @Override
    @Nullable
    public Set<ScopedStateStore.Key<?>> getTriggerKeys() {
        return ImmutableSet.of(AddAndroidActivityPath.KEY_IS_LAUNCHER);
    }

    @Override
    @NotNull
    public TemplateEntry[] deriveValue(@NotNull ScopedStateStore state, ScopedStateStore.Key changedKey, @Nullable TemplateEntry[] currentValue) {
        Boolean isLauncher;
        boolean hasCppSupport;
        if (state == null) {
            TemplateListProvider.$$$reportNull$$$0(5);
        }
        if (hasCppSupport = state.getNotNull(WizardConstants.INCLUDE_CPP_SUPPORT_KEY, false).booleanValue()) {
            ArrayList filtered = Lists.newArrayList();
            for (TemplateEntry template : this.myTemplates) {
                String title = template.getTitle();
                if (!"Empty Activity".equals(title) && !"Basic Activity".equals(title)) continue;
                filtered.add(template);
            }
            if (!filtered.isEmpty()) {
                TemplateEntry[] templateEntryArray = filtered.toArray(new TemplateEntry[filtered.size()]);
                if (templateEntryArray == null) {
                    TemplateListProvider.$$$reportNull$$$0(6);
                }
                return templateEntryArray;
            }
        }
        if (!Boolean.TRUE.equals(isLauncher = state.get(AddAndroidActivityPath.KEY_IS_LAUNCHER))) {
            if (this.myTemplates == null) {
                TemplateListProvider.$$$reportNull$$$0(7);
            }
            return this.myTemplates;
        }
        ArrayList list = Lists.newArrayListWithExpectedSize((int)this.myTemplates.length);
        for (TemplateEntry entry : Arrays.asList(this.myTemplates)) {
            if (entry.getMetadata().getParameter("isLauncher") == null) continue;
            list.add(entry);
        }
        TemplateEntry[] templateEntryArray = (TemplateEntry[])ArrayUtil.toObjectArray((Collection)list, TemplateEntry.class);
        if (templateEntryArray == null) {
            TemplateListProvider.$$$reportNull$$$0(8);
        }
        return templateEntryArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formFactor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "categories";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excluded";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "category";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/npw/TemplateListProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/npw/TemplateListProvider";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "deriveValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getTemplateList";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "deriveValue";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

