/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw;

import com.android.builder.model.SourceProvider;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.model.MergedManifest;
import com.android.tools.idea.npw.ActivityGalleryStep;
import com.android.tools.idea.npw.FormFactor;
import com.android.tools.idea.npw.FormFactorUtils;
import com.android.tools.idea.npw.IconStep;
import com.android.tools.idea.npw.TemplateEntry;
import com.android.tools.idea.npw.TemplateParameterStep2;
import com.android.tools.idea.templates.KeystoreUtils;
import com.android.tools.idea.templates.Parameter;
import com.android.tools.idea.templates.Template;
import com.android.tools.idea.templates.TemplateManager;
import com.android.tools.idea.templates.TemplateMetadata;
import com.android.tools.idea.templates.TemplateUtils;
import com.android.tools.idea.templates.recipe.RenderingContext;
import com.android.tools.idea.wizard.WizardConstants;
import com.android.tools.idea.wizard.dynamic.DynamicWizardPath;
import com.android.tools.idea.wizard.dynamic.ScopedStateStore;
import com.android.tools.idea.wizard.template.TemplateWizard;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.ui.RecentsManager;
import com.intellij.util.ArrayUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.IdeaSourceProvider;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public final class AddAndroidActivityPath
extends DynamicWizardPath {
    public static final ScopedStateStore.Key<Boolean> KEY_IS_LAUNCHER = ScopedStateStore.createKey("is.launcher.activity", ScopedStateStore.Scope.PATH, Boolean.class);
    public static final ScopedStateStore.Key<TemplateEntry> KEY_SELECTED_TEMPLATE = ScopedStateStore.createKey("selected.template", ScopedStateStore.Scope.PATH, TemplateEntry.class);
    public static final ScopedStateStore.Key<AndroidVersion> KEY_MIN_SDK = ScopedStateStore.createKey("minApi", ScopedStateStore.Scope.PATH, AndroidVersion.class);
    public static final ScopedStateStore.Key<AndroidVersion> KEY_TARGET_API = ScopedStateStore.createKey("targetApi", ScopedStateStore.Scope.PATH, AndroidVersion.class);
    public static final ScopedStateStore.Key<Integer> KEY_BUILD_SDK = ScopedStateStore.createKey("buildApi", ScopedStateStore.Scope.PATH, Integer.class);
    public static final ScopedStateStore.Key<String> KEY_PACKAGE_NAME = ScopedStateStore.createKey("packageName", ScopedStateStore.Scope.PATH, String.class);
    public static final ScopedStateStore.Key<SourceProvider> KEY_SOURCE_PROVIDER = ScopedStateStore.createKey("source.provider", ScopedStateStore.Scope.PATH, SourceProvider.class);
    public static final ScopedStateStore.Key<String> KEY_SOURCE_PROVIDER_NAME = ScopedStateStore.createKey("sourceProviderName", ScopedStateStore.Scope.PATH, String.class);
    public static final Set<String> PACKAGE_NAME_PARAMETERS = ImmutableSet.of((Object)"packageName");
    public static final Set<String> CLASS_NAME_PARAMETERS = ImmutableSet.of((Object)"parentActivityClass");
    public static final ScopedStateStore.Key<Boolean> KEY_OPEN_EDITORS = ScopedStateStore.createKey("open.editors", ScopedStateStore.Scope.WIZARD, Boolean.class);
    public static final Set<ScopedStateStore.Key<?>> IMPLICIT_PARAMETERS = ImmutableSet.of(KEY_PACKAGE_NAME, KEY_SOURCE_PROVIDER_NAME, WizardConstants.IS_INSTANT_APP_KEY);
    private static final Logger LOG = Logger.getInstance(AddAndroidActivityPath.class);
    public static final String CUSTOMIZE_ACTIVITY_TITLE = "Customize the Activity";
    private TemplateParameterStep2 myParameterStep;
    private final boolean myIsNewModule;
    private IconStep myAssetStudioStep;
    private final VirtualFile myTargetFolder;
    @Nullable
    private final File myTemplate;
    private final Disposable myParentDisposable;

    public AddAndroidActivityPath(@Nullable VirtualFile targetFolder, @Nullable File template, Disposable parentDisposable) {
        this.myTemplate = template;
        this.myParentDisposable = parentDisposable;
        this.myIsNewModule = false;
        this.myTargetFolder = targetFolder != null && !targetFolder.isDirectory() ? targetFolder.getParent() : targetFolder;
    }

    private static FormFactor getFormFactor(@Nullable VirtualFile targetFolder) {
        return FormFactor.MOBILE;
    }

    @Nullable
    private static File findSrcDirectory(@NotNull SourceProvider sourceProvider) {
        if (sourceProvider == null) {
            AddAndroidActivityPath.$$$reportNull$$$0(0);
        }
        return (File)Iterables.getFirst((Iterable)sourceProvider.getJavaDirectories(), null);
    }

    @Nullable
    private static File findTestDirectory(@NotNull Module module) {
        List testsRoot;
        if (module == null) {
            AddAndroidActivityPath.$$$reportNull$$$0(1);
        }
        return (testsRoot = ModuleRootManager.getInstance((Module)module).getSourceRoots(JavaModuleSourceRootTypes.TESTS)).size() == 0 ? null : VfsUtilCore.virtualToIoFile((VirtualFile)((VirtualFile)testsRoot.get(0)));
    }

    @Nullable
    private static File findResDirectory(@NotNull SourceProvider sourceProvider) {
        if (sourceProvider == null) {
            AddAndroidActivityPath.$$$reportNull$$$0(2);
        }
        Collection resDirectories = sourceProvider.getResDirectories();
        File resDir = null;
        if (!resDirectories.isEmpty()) {
            resDir = (File)resDirectories.iterator().next();
        }
        return resDir;
    }

    @Nullable
    private static File findAidlDir(@NotNull SourceProvider sourceProvider) {
        if (sourceProvider == null) {
            AddAndroidActivityPath.$$$reportNull$$$0(3);
        }
        Collection aidlDirectories = sourceProvider.getAidlDirectories();
        File resDir = null;
        if (!aidlDirectories.isEmpty()) {
            resDir = (File)aidlDirectories.iterator().next();
        }
        return resDir;
    }

    @Nullable
    private static File findManifestDirectory(@NotNull SourceProvider sourceProvider) {
        File manifestFile;
        File manifestDir;
        if (sourceProvider == null) {
            AddAndroidActivityPath.$$$reportNull$$$0(4);
        }
        if ((manifestDir = (manifestFile = sourceProvider.getManifestFile()).getParentFile()) != null) {
            return manifestDir;
        }
        return null;
    }

    @Nullable
    private static File getModuleRoot(@Nullable Module module) {
        if (module == null) {
            return null;
        }
        VirtualFile[] roots = ModuleRootManager.getInstance((Module)module).getContentRoots();
        if (roots.length > 0) {
            return VfsUtilCore.virtualToIoFile((VirtualFile)roots[0]);
        }
        return null;
    }

    private static Map<String, Object> selectSourceProvider(@NotNull SourceProvider sourceProvider, @NotNull AndroidModel androidModel, @NotNull Module module, @NotNull String packageName) {
        File aidlDir;
        File manifestDir;
        if (sourceProvider == null) {
            AddAndroidActivityPath.$$$reportNull$$$0(5);
        }
        if (androidModel == null) {
            AddAndroidActivityPath.$$$reportNull$$$0(6);
        }
        if (module == null) {
            AddAndroidActivityPath.$$$reportNull$$$0(7);
        }
        if (packageName == null) {
            AddAndroidActivityPath.$$$reportNull$$$0(8);
        }
        HashMap paths = Maps.newHashMap();
        File moduleDirPath = androidModel.getRootDirPath();
        File javaDir = AddAndroidActivityPath.findSrcDirectory(sourceProvider);
        File testDir = AddAndroidActivityPath.findTestDirectory(module);
        String javaPath = AddAndroidActivityPath.getJavaPath(moduleDirPath, javaDir);
        paths.put("srcDir", javaPath);
        File resDir = AddAndroidActivityPath.findResDirectory(sourceProvider);
        if (resDir != null) {
            String resPath = FileUtil.getRelativePath((File)moduleDirPath, (File)resDir);
            if (resPath != null) {
                resPath = FileUtil.toSystemIndependentName((String)resPath);
            }
            paths.put("resDir", resPath);
            paths.put("resOut", FileUtil.toSystemIndependentName((String)resDir.getPath()));
        }
        if ((manifestDir = AddAndroidActivityPath.findManifestDirectory(sourceProvider)) != null) {
            String manifestPath = FileUtil.getRelativePath((File)moduleDirPath, (File)manifestDir);
            paths.put("manifestDir", manifestPath);
            paths.put("manifestOut", FileUtil.toSystemIndependentName((String)manifestDir.getPath()));
        }
        if ((aidlDir = AddAndroidActivityPath.findAidlDir(sourceProvider)) != null) {
            String aidlPath = FileUtil.getRelativePath((File)moduleDirPath, (File)aidlDir);
            paths.put("aidlDir", aidlPath);
            paths.put("aidlOut", FileUtil.toSystemIndependentName((String)aidlDir.getPath()));
        }
        if (testDir == null) {
            VirtualFile rootDir = androidModel.getRootDir();
            String absolutePath = Joiner.on((char)'/').join((Object)rootDir.getPath(), (Object)TemplateWizard.TEST_SOURCE_PATH, new Object[]{"java"});
            testDir = new File(FileUtil.toSystemDependentName((String)absolutePath));
        }
        assert (javaPath != null);
        String sourceRootPackagePrefix = AddAndroidActivityPath.getSourceDirectoryPackagePrefix(module, javaDir);
        String relativePackageName = AddAndroidActivityPath.removeCommonPackagePrefix(sourceRootPackagePrefix, packageName);
        paths.put("packageName", packageName);
        String relativePackageDir = relativePackageName.replace('.', File.separatorChar);
        File srcOut = new File(javaDir, relativePackageDir);
        File testOut = new File(testDir, relativePackageDir);
        paths.put("testDir", FileUtil.toSystemIndependentName((String)testDir.getAbsolutePath()));
        paths.put("testOut", FileUtil.toSystemIndependentName((String)testOut.getAbsolutePath()));
        paths.put("applicationPackage", MergedManifest.get(module).getPackage());
        paths.put("srcOut", FileUtil.toSystemIndependentName((String)srcOut.getAbsolutePath()));
        return paths;
    }

    @NotNull
    private static String getSourceDirectoryPackagePrefix(@NotNull Module module, File javaDir) {
        VirtualFile javaVirtualFile;
        if (module == null) {
            AddAndroidActivityPath.$$$reportNull$$$0(9);
        }
        if ((javaVirtualFile = LocalFileSystem.getInstance().findFileByIoFile(javaDir)) == null) {
            if ("" == null) {
                AddAndroidActivityPath.$$$reportNull$$$0(10);
            }
            return "";
        }
        SourceFolder sourceFolder = ProjectRootsUtil.findSourceFolder((Module)module, (VirtualFile)javaVirtualFile);
        if (sourceFolder == null) {
            if ("" == null) {
                AddAndroidActivityPath.$$$reportNull$$$0(11);
            }
            return "";
        }
        String string = sourceFolder.getPackagePrefix();
        if (string == null) {
            AddAndroidActivityPath.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    static String removeCommonPackagePrefix(@NotNull String packagePrefix, @NotNull String packageName) {
        if (packagePrefix == null) {
            AddAndroidActivityPath.$$$reportNull$$$0(13);
        }
        if (packageName == null) {
            AddAndroidActivityPath.$$$reportNull$$$0(14);
        }
        String relativePackageName = packageName;
        if (packageName.equals(packagePrefix)) {
            relativePackageName = "";
        } else if (packageName.length() > packagePrefix.length() && packageName.startsWith(packagePrefix) && packageName.charAt(packagePrefix.length()) == '.') {
            relativePackageName = relativePackageName.substring(packagePrefix.length() + 1);
        }
        String string = relativePackageName;
        if (string == null) {
            AddAndroidActivityPath.$$$reportNull$$$0(15);
        }
        return string;
    }

    @Nullable
    private static String getJavaPath(File ioModuleDir, @Nullable File javaDir) {
        String javaPath = null;
        if (javaDir != null && (javaPath = FileUtil.getRelativePath((File)ioModuleDir, (File)javaDir)) != null) {
            javaPath = FileUtil.toSystemIndependentName((String)javaPath);
        }
        return javaPath;
    }

    public static List<String> getParameterValueHistory(@NotNull Parameter parameter, Project project) {
        List entries;
        if (parameter == null) {
            AddAndroidActivityPath.$$$reportNull$$$0(16);
        }
        return (entries = RecentsManager.getInstance((Project)project).getRecentEntries(AddAndroidActivityPath.getRecentHistoryKey(parameter.id))) == null ? ImmutableList.of() : entries;
    }

    public static String getRecentHistoryKey(@Nullable String parameter) {
        return "android.template." + parameter;
    }

    private static void saveRecentValues(@NotNull Project project, @NotNull Map<String, Object> state) {
        if (project == null) {
            AddAndroidActivityPath.$$$reportNull$$$0(17);
        }
        if (state == null) {
            AddAndroidActivityPath.$$$reportNull$$$0(18);
        }
        for (String id : Iterables.concat(PACKAGE_NAME_PARAMETERS, CLASS_NAME_PARAMETERS)) {
            String value = (String)state.get(id);
            if (StringUtil.isEmpty((String)value)) continue;
            RecentsManager.getInstance((Project)project).registerRecentEntry(AddAndroidActivityPath.getRecentHistoryKey(id), value);
        }
    }

    @Override
    protected void init() {
        Module module = this.getModule();
        assert (module != null);
        AndroidFacet facet = AndroidFacet.getInstance(module);
        assert (facet != null);
        AndroidPlatform platform = AndroidPlatform.getInstance(module);
        if (platform != null) {
            this.myState.put(KEY_BUILD_SDK, platform.getTarget().getVersion().getFeatureLevel());
        }
        AndroidModuleInfo moduleInfo = AndroidModuleInfo.get(facet);
        AndroidVersion minSdkVersion = moduleInfo.getMinSdkVersion();
        this.myState.put(KEY_MIN_SDK, minSdkVersion);
        this.myState.put(KEY_TARGET_API, moduleInfo.getTargetSdkVersion());
        this.myState.put(KEY_PACKAGE_NAME, this.getInitialPackageName(module, facet));
        this.myState.put(KEY_OPEN_EDITORS, true);
        if (this.myTemplate == null) {
            FormFactor formFactor = AddAndroidActivityPath.getFormFactor(this.myTargetFolder);
            this.myState.put(FormFactorUtils.getMinApiLevelKey(formFactor), minSdkVersion.getApiLevel());
            this.myState.put(FormFactorUtils.getBuildApiLevelKey(formFactor), moduleInfo.getTargetSdkVersion().getApiLevel());
            ActivityGalleryStep galleryStep = new ActivityGalleryStep(formFactor, false, KEY_SELECTED_TEMPLATE, module, this.myParentDisposable);
            this.addStep(galleryStep);
        } else {
            TemplateMetadata templateMetadata = TemplateManager.getInstance().getTemplateMetadata(this.myTemplate);
            assert (templateMetadata != null);
            this.myState.put(KEY_SELECTED_TEMPLATE, new TemplateEntry(this.myTemplate, templateMetadata));
        }
        SourceProvider[] sourceProviders = AddAndroidActivityPath.getSourceProviders(module, this.myTargetFolder);
        boolean isInstantAppModule = facet.getProjectType() == 3;
        this.myState.put(WizardConstants.IS_INSTANT_APP_KEY, isInstantAppModule);
        this.myParameterStep = new TemplateParameterStep2(AddAndroidActivityPath.getFormFactor(this.myTargetFolder), (Map<String, Object>)ImmutableMap.of(), this.myParentDisposable, KEY_PACKAGE_NAME, sourceProviders, CUSTOMIZE_ACTIVITY_TITLE);
        this.myAssetStudioStep = new IconStep(KEY_SELECTED_TEMPLATE, KEY_SOURCE_PROVIDER, this.myParentDisposable);
        this.addStep(this.myParameterStep);
        this.addStep(this.myAssetStudioStep);
    }

    @NotNull
    private static SourceProvider[] getSourceProviders(@Nullable Module module, @Nullable VirtualFile targetDirectory) {
        AndroidFacet facet;
        if (module != null && (facet = AndroidFacet.getInstance(module)) != null) {
            List<SourceProvider> providers = targetDirectory != null ? IdeaSourceProvider.getSourceProvidersForFile(facet, targetDirectory, facet.getMainSourceProvider()) : IdeaSourceProvider.getAllSourceProviders(facet);
            SourceProvider[] sourceProviderArray = (SourceProvider[])ArrayUtil.toObjectArray(providers, SourceProvider.class);
            if (sourceProviderArray == null) {
                AddAndroidActivityPath.$$$reportNull$$$0(19);
            }
            return sourceProviderArray;
        }
        SourceProvider[] sourceProviderArray = new SourceProvider[]{};
        if (sourceProviderArray == null) {
            AddAndroidActivityPath.$$$reportNull$$$0(20);
        }
        return sourceProviderArray;
    }

    private String getInitialPackageName(Module module, AndroidFacet facet) {
        if (this.myTargetFolder != null) {
            String packageName;
            File srcDirectory;
            List<SourceProvider> sourceProviders = IdeaSourceProvider.getSourceProvidersForFile(facet, this.myTargetFolder, facet.getMainSourceProvider());
            File targetDirectoryFile = VfsUtilCore.virtualToIoFile((VirtualFile)this.myTargetFolder);
            if (sourceProviders.size() > 0 && IdeaSourceProvider.containsFile(sourceProviders.get(0), targetDirectoryFile) && (srcDirectory = AddAndroidActivityPath.findSrcDirectory(sourceProviders.get(0))) != null && (packageName = ProjectRootManager.getInstance((Project)module.getProject()).getFileIndex().getPackageNameByDirectory(this.myTargetFolder)) != null) {
                return packageName;
            }
        }
        return this.getApplicationPackageName();
    }

    @Override
    @NotNull
    public String getPathName() {
        if ("Add Android activity" == null) {
            AddAndroidActivityPath.$$$reportNull$$$0(21);
        }
        return "Add Android activity";
    }

    @Override
    public boolean canPerformFinishingActions() {
        return this.performFinishingOperation(true, null, null);
    }

    @Override
    public boolean performFinishingActions() {
        ArrayList filesToReformat;
        final Project project = this.getProject();
        assert (project != null);
        final ArrayList filesToOpen = Lists.newArrayList();
        boolean success = (Boolean)new WriteCommandAction<Boolean>(project, "New Activity", new PsiFile[0], (List)(filesToReformat = Lists.newArrayList())){
            final /* synthetic */ List val$filesToReformat;
            {
                this.val$filesToReformat = list2;
                super(arg0, arg1, arg2);
            }

            protected void run(@NotNull Result<Boolean> result) throws Throwable {
                boolean success;
                if (result == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (success = AddAndroidActivityPath.this.performFinishingOperation(false, filesToOpen, this.val$filesToReformat)) {
                    AddAndroidActivityPath.this.myAssetStudioStep.createAssets();
                }
                result.setResult((Object)success);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/npw/AddAndroidActivityPath$1", "run"));
            }
        }.execute().getResultObject();
        if (!success) {
            return false;
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                if (Boolean.TRUE.equals(AddAndroidActivityPath.this.myState.get(KEY_OPEN_EDITORS))) {
                    TemplateUtils.openEditors(project, filesToOpen, true);
                }
            }
        });
        return true;
    }

    private boolean performFinishingOperation(boolean dryRun, @Nullable List<File> filesToOpen, @Nullable List<File> filesToReformat) {
        TemplateEntry templateEntry = this.myState.get(KEY_SELECTED_TEMPLATE);
        Project project = this.getProject();
        Module module = this.getModule();
        assert (templateEntry != null);
        assert (project != null && module != null);
        Template template = templateEntry.getTemplate();
        File moduleRoot = AddAndroidActivityPath.getModuleRoot(module);
        if (moduleRoot == null) {
            return false;
        }
        Map<String, Object> parameterMap = this.getTemplateParameterMap(templateEntry.getMetadata());
        AddAndroidActivityPath.saveRecentValues(project, parameterMap);
        RenderingContext context = RenderingContext.Builder.newContext(template, project).withCommandName("New Activity").withDryRun(dryRun).withShowErrors(true).withModule(module).withParams(parameterMap).intoOpenFiles(filesToOpen).intoTargetFiles(filesToReformat).build();
        return template.render(context);
    }

    @NotNull
    private Map<String, Object> getTemplateParameterMap(@NotNull TemplateMetadata template) {
        if (template == null) {
            AddAndroidActivityPath.$$$reportNull$$$0(22);
        }
        HashMap parameterValueMap = Maps.newHashMap();
        parameterValueMap.put("isNewProject", this.myIsNewModule);
        parameterValueMap.putAll(this.getDirectories());
        for (ScopedStateStore.Key<?> key : IMPLICIT_PARAMETERS) {
            parameterValueMap.put(key.name, this.myState.get(key));
        }
        for (Parameter parameter : template.getParameters()) {
            parameterValueMap.put(parameter.id, this.myState.get(this.myParameterStep.getParameterKey(parameter)));
        }
        try {
            parameterValueMap.put("debugKeystoreSha1", KeystoreUtils.sha1(KeystoreUtils.getOrCreateDefaultDebugKeystore()));
        }
        catch (Exception e) {
            LOG.info("Could not compute SHA1 hash of debug keystore.", (Throwable)e);
        }
        File moduleRoot = AddAndroidActivityPath.getModuleRoot(this.getModule());
        if (moduleRoot != null) {
            parameterValueMap.put("projectOut", FileUtil.toSystemIndependentName((String)moduleRoot.getAbsolutePath()));
        }
        if (Objects.equal((Object)this.getApplicationPackageName(), parameterValueMap.get("packageName"))) {
            parameterValueMap.remove("applicationPackage");
        }
        HashMap hashMap = parameterValueMap;
        if (hashMap == null) {
            AddAndroidActivityPath.$$$reportNull$$$0(23);
        }
        return hashMap;
    }

    private String getApplicationPackageName() {
        AndroidModel androidModel = AndroidFacet.getInstance(this.getModule()).getAndroidModel();
        assert (androidModel != null);
        return androidModel.getApplicationId();
    }

    private Map<String, Object> getDirectories() {
        HashMap templateParameters = Maps.newHashMap();
        Module module = this.getModule();
        assert (module != null);
        AndroidFacet facet = AndroidFacet.getInstance(module);
        assert (facet != null);
        AndroidPlatform platform = AndroidPlatform.getInstance(module);
        if (platform != null) {
            templateParameters.put("buildApi", platform.getTarget().getVersion().getFeatureLevel());
            templateParameters.put("buildApiString", TemplateMetadata.getBuildApiString(platform.getTarget().getVersion()));
        }
        AndroidModuleInfo moduleInfo = AndroidModuleInfo.get(facet);
        AndroidModel androidModel = facet.getAndroidModel();
        SourceProvider sourceProvider1 = this.myState.get(KEY_SOURCE_PROVIDER);
        if (sourceProvider1 != null && androidModel != null) {
            String packageName = this.myState.get(KEY_PACKAGE_NAME);
            assert (packageName != null);
            templateParameters.putAll(AddAndroidActivityPath.selectSourceProvider(sourceProvider1, androidModel, module, packageName));
        }
        AndroidVersion minSdkVersion = moduleInfo.getMinSdkVersion();
        String minSdkName = minSdkVersion.getApiString();
        templateParameters.put("minApi", minSdkName);
        templateParameters.put("targetApi", moduleInfo.getTargetSdkVersion().getApiLevel());
        templateParameters.put("minApiLevel", minSdkVersion.getFeatureLevel());
        templateParameters.put("isLibraryProject", facet.isLibraryProject());
        try {
            templateParameters.put("debugKeystoreSha1", KeystoreUtils.sha1(KeystoreUtils.getDebugKeystore(facet)));
        }
        catch (Exception e) {
            LOG.info("Could not compute SHA1 hash of debug keystore.", (Throwable)e);
            templateParameters.put("debugKeystoreSha1", "");
        }
        String projectLocation = "projectLocation";
        Project project = this.getProject();
        assert (project != null);
        templateParameters.put(projectLocation, project.getBasePath());
        String moduleName = new File(module.getModuleFilePath()).getParentFile().getName();
        templateParameters.put("projectName", moduleName);
        return templateParameters;
    }

    public String getActionDescription() {
        TemplateEntry template = this.myState.get(KEY_SELECTED_TEMPLATE);
        return String.format("Add %1$s", template == null ? "Template" : template.getTitle());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 19: 
            case 20: 
            case 21: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 19: 
            case 20: 
            case 21: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceProvider";
                break;
            }
            case 1: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidModel";
                break;
            }
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 19: 
            case 20: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/npw/AddAndroidActivityPath";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packagePrefix";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/npw/AddAndroidActivityPath";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceDirectoryPackagePrefix";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "removeCommonPackagePrefix";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceProviders";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathName";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateParameterMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findSrcDirectory";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findTestDirectory";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findResDirectory";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findAidlDir";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findManifestDirectory";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "selectSourceProvider";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getSourceDirectoryPackagePrefix";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 19: 
            case 20: 
            case 21: 
            case 23: {
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "removeCommonPackagePrefix";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getParameterValueHistory";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "saveRecentValues";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getTemplateParameterMap";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 19: 
            case 20: 
            case 21: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

