/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.ProjectViewDirectoryHelper;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.ui.SimpleTextAttributes;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class NativeAndroidSourceDirectoryNode
extends PsiDirectoryNode {
    @NotNull
    private final Collection<String> myFileExtensions;
    @NotNull
    private final Collection<VirtualFile> mySourceFolders;
    @NotNull
    private final Collection<VirtualFile> mySourceFiles;
    private boolean myShowDirectoryPath;

    public NativeAndroidSourceDirectoryNode(@NotNull Project project, @NotNull PsiDirectory dir, @NotNull ViewSettings settings, @NotNull Collection<String> fileExtensions, @NotNull Collection<VirtualFile> sourceFolders, @NotNull Collection<VirtualFile> sourceFiles) {
        if (project == null) {
            NativeAndroidSourceDirectoryNode.$$$reportNull$$$0(0);
        }
        if (dir == null) {
            NativeAndroidSourceDirectoryNode.$$$reportNull$$$0(1);
        }
        if (settings == null) {
            NativeAndroidSourceDirectoryNode.$$$reportNull$$$0(2);
        }
        if (fileExtensions == null) {
            NativeAndroidSourceDirectoryNode.$$$reportNull$$$0(3);
        }
        if (sourceFolders == null) {
            NativeAndroidSourceDirectoryNode.$$$reportNull$$$0(4);
        }
        if (sourceFiles == null) {
            NativeAndroidSourceDirectoryNode.$$$reportNull$$$0(5);
        }
        super(project, dir, settings);
        this.myFileExtensions = fileExtensions;
        this.mySourceFolders = sourceFolders;
        this.mySourceFiles = sourceFiles;
    }

    protected boolean shouldShowModuleName() {
        return false;
    }

    protected boolean shouldShowSourcesRoot() {
        return false;
    }

    protected void updateImpl(PresentationData presentation) {
        VirtualFile directoryFile = this.getVirtualFile();
        assert (directoryFile != null);
        presentation.setPresentableText(directoryFile.getName());
        presentation.addText(directoryFile.getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        if (this.myShowDirectoryPath) {
            presentation.addText(" (" + FileUtil.getLocationRelativeToUserHome((String)directoryFile.getPresentableUrl()) + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
        presentation.setIcon(AllIcons.Nodes.Folder);
    }

    public Collection<AbstractTreeNode> getChildrenImpl() {
        PsiDirectory psiDirectory = (PsiDirectory)this.getValue();
        if (psiDirectory == null) {
            return ImmutableList.of();
        }
        Collection directoryChildren = ProjectViewDirectoryHelper.getInstance((Project)this.myProject).getDirectoryChildren(psiDirectory, this.getSettings(), true);
        ArrayList result = Lists.newArrayList();
        for (AbstractTreeNode child : directoryChildren) {
            Object value = child.getValue();
            if (value instanceof PsiFile) {
                VirtualFile file = ((PsiFile)value).getVirtualFile();
                if ((!this.mySourceFolders.contains(psiDirectory.getVirtualFile()) || !this.myFileExtensions.contains(file.getExtension())) && !this.mySourceFiles.contains(file)) continue;
                result.add(child);
                continue;
            }
            if (!(value instanceof PsiDirectory)) continue;
            VirtualFile dir = ((PsiDirectory)value).getVirtualFile();
            if (this.mySourceFolders.contains(dir) || this.mySourceFolders.contains(psiDirectory.getVirtualFile())) {
                result.add(new NativeAndroidSourceDirectoryNode(this.myProject, (PsiDirectory)value, this.getSettings(), this.myFileExtensions, (Collection<VirtualFile>)ImmutableList.of((Object)dir), (Collection<VirtualFile>)ImmutableList.of()));
                continue;
            }
            ArrayList childDirs = Lists.newArrayList();
            for (VirtualFile sourceFolder : this.mySourceFolders) {
                if (!VfsUtilCore.isAncestor((VirtualFile)dir, (VirtualFile)sourceFolder, (boolean)true)) continue;
                childDirs.add(sourceFolder);
            }
            ArrayList childFiles = Lists.newArrayList();
            for (VirtualFile file : this.mySourceFiles) {
                if (!VfsUtilCore.isAncestor((VirtualFile)dir, (VirtualFile)file, (boolean)true)) continue;
                childFiles.add(file);
            }
            if (childDirs.isEmpty() && childFiles.isEmpty()) continue;
            result.add(new NativeAndroidSourceDirectoryNode(this.myProject, (PsiDirectory)value, this.getSettings(), this.myFileExtensions, childDirs, childFiles));
        }
        return result;
    }

    void setShowDirectoryPath(boolean showDirectoryPath) {
        this.myShowDirectoryPath = showDirectoryPath;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "dir";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "settings";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "fileExtensions";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "sourceFolders";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[0] = "sourceFiles";
                break;
            }
        }
        objectArray[1] = "com/android/tools/idea/navigator/nodes/NativeAndroidSourceDirectoryNode";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

