/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes;

import com.android.resources.ResourceFolderType;
import com.android.tools.idea.navigator.AndroidProjectViewPane;
import com.android.tools.idea.navigator.nodes.AndroidResFileNode;
import com.android.tools.idea.navigator.nodes.AndroidResGroupNode;
import com.android.tools.idea.navigator.nodes.DirectoryGroupNode;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.PlatformIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidResFolderTypeNode
extends ProjectViewNode<List<PsiDirectory>>
implements DirectoryGroupNode {
    @NotNull
    private final AndroidFacet myFacet;
    @NotNull
    private final ResourceFolderType myFolderType;
    @NotNull
    private final AndroidProjectViewPane myProjectViewPane;

    public AndroidResFolderTypeNode(@NotNull Project project, @NotNull AndroidFacet facet, @NotNull List<PsiDirectory> folders, @NotNull ViewSettings settings, @NotNull ResourceFolderType folderType, @NotNull AndroidProjectViewPane projectViewPane) {
        if (project == null) {
            AndroidResFolderTypeNode.$$$reportNull$$$0(0);
        }
        if (facet == null) {
            AndroidResFolderTypeNode.$$$reportNull$$$0(1);
        }
        if (folders == null) {
            AndroidResFolderTypeNode.$$$reportNull$$$0(2);
        }
        if (settings == null) {
            AndroidResFolderTypeNode.$$$reportNull$$$0(3);
        }
        if (folderType == null) {
            AndroidResFolderTypeNode.$$$reportNull$$$0(4);
        }
        if (projectViewPane == null) {
            AndroidResFolderTypeNode.$$$reportNull$$$0(5);
        }
        super(project, folders, settings);
        this.myFacet = facet;
        this.myFolderType = folderType;
        this.myProjectViewPane = projectViewPane;
    }

    @Override
    @NotNull
    public PsiDirectory[] getDirectories() {
        List dirs = (List)this.getValue();
        PsiDirectory[] psiDirectoryArray = dirs.toArray(new PsiDirectory[dirs.size()]);
        if (psiDirectoryArray == null) {
            AndroidResFolderTypeNode.$$$reportNull$$$0(6);
        }
        return psiDirectoryArray;
    }

    public boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            AndroidResFolderTypeNode.$$$reportNull$$$0(7);
        }
        for (PsiDirectory psiDirectory : (List)this.getValue()) {
            VirtualFile folder = psiDirectory.getVirtualFile();
            if (!VfsUtilCore.isAncestor((VirtualFile)folder, (VirtualFile)file, (boolean)true)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public Collection<? extends AbstractTreeNode> getChildren() {
        List folders = (List)this.getValue();
        HashMultimap multimap = HashMultimap.create();
        for (PsiDirectory res : folders) {
            for (PsiFile file : res.getFiles()) {
                String resName = file.getName();
                multimap.put((Object)resName, (Object)file);
            }
        }
        ArrayList children = Lists.newArrayListWithExpectedSize((int)multimap.size());
        for (String resName : multimap.keySet()) {
            ArrayList files = Lists.newArrayList((Iterable)multimap.get((Object)resName));
            if (files.size() > 1) {
                children.add(new AndroidResGroupNode(this.myProject, this.myFacet, files, resName, this.getSettings()));
                continue;
            }
            children.add(new AndroidResFileNode(this.myProject, (PsiFile)files.get(0), this.getSettings(), this.myFacet));
        }
        ArrayList arrayList = children;
        if (arrayList == null) {
            AndroidResFolderTypeNode.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    protected void update(PresentationData presentation) {
        presentation.addText(this.myFolderType.getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        presentation.setIcon(PlatformIcons.PACKAGE_ICON);
        presentation.setPresentableText(this.myFolderType.getName());
    }

    @Nullable
    public Comparable getSortKey() {
        return this.myFolderType;
    }

    @Nullable
    public Comparable getTypeSortKey() {
        return this.myFolderType;
    }

    @Nullable
    public String toTestString(@Nullable Queryable.PrintInfo printInfo) {
        return this.myFolderType.getName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folders";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folderType";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectViewPane";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/navigator/nodes/AndroidResFolderTypeNode";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/navigator/nodes/AndroidResFolderTypeNode";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectories";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 8: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

