/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes;

import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.tools.idea.navigator.AndroidProjectViewPane;
import com.android.tools.idea.navigator.nodes.AndroidResComparator;
import com.google.common.base.Joiner;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.ui.SimpleTextAttributes;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.IdeaSourceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidResFileNode
extends PsiFileNode
implements Comparable {
    private final AndroidFacet myFacet;

    public AndroidResFileNode(@NotNull Project project, @NotNull PsiFile psiFile, @NotNull ViewSettings settings, @NotNull AndroidFacet facet) {
        if (project == null) {
            AndroidResFileNode.$$$reportNull$$$0(0);
        }
        if (psiFile == null) {
            AndroidResFileNode.$$$reportNull$$$0(1);
        }
        if (settings == null) {
            AndroidResFileNode.$$$reportNull$$$0(2);
        }
        if (facet == null) {
            AndroidResFileNode.$$$reportNull$$$0(3);
        }
        super(project, psiFile, settings);
        this.myFacet = facet;
    }

    public void update(PresentationData data) {
        super.update(data);
        String text = data.getPresentableText();
        data.addText(text, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        data.setPresentableText(text);
        String qualifier = this.getQualifier();
        if (qualifier != null) {
            data.addText(qualifier, SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
    }

    @Nullable
    public String toTestString(@Nullable Queryable.PrintInfo printInfo) {
        PsiFile psiFile = (PsiFile)this.getValue();
        String qualifier = this.getQualifier();
        return psiFile.getName() + (qualifier == null ? "" : qualifier);
    }

    @Nullable
    String getQualifier() {
        IdeaSourceProvider ideaSourceProvider;
        PsiFile resFile = (PsiFile)this.getValue();
        if (resFile == null) {
            return null;
        }
        PsiDirectory resTypeFolder = resFile.getParent();
        if (resTypeFolder == null) {
            return null;
        }
        String folderName = resTypeFolder.getName();
        int index = folderName.indexOf("-");
        String qualifier = index < 0 ? null : folderName.substring(index + 1);
        String providerName = null;
        PsiDirectory resFolder = resTypeFolder.getParent();
        if (resFolder != null && (ideaSourceProvider = this.findSourceProviderForResFolder(resFolder)) != null && "main".equals(providerName = ideaSourceProvider.getName())) {
            providerName = null;
        }
        if (qualifier == null && providerName == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(10);
        sb.append(" (");
        sb.append(Joiner.on((String)", ").skipNulls().join((Object)qualifier, (Object)providerName, new Object[0]));
        sb.append(')');
        return sb.toString();
    }

    @Nullable
    public FolderConfiguration getFolderConfiguration() {
        PsiFile psiFile = (PsiFile)this.getValue();
        if (psiFile == null) {
            return null;
        }
        PsiDirectory folder = psiFile.getParent();
        return folder == null ? null : FolderConfiguration.getConfigForFolder((String)folder.getName());
    }

    @Nullable
    public Comparable getSortKey() {
        return this;
    }

    public Comparable getTypeSortKey() {
        return this;
    }

    public int compareTo(@NotNull Object obj) {
        if (obj == null) {
            AndroidResFileNode.$$$reportNull$$$0(4);
        }
        return AndroidResComparator.INSTANCE.compare(this, obj);
    }

    @Nullable
    public String getResName() {
        PsiFile f = (PsiFile)this.getValue();
        return f == null || !f.isValid() ? null : f.getName();
    }

    @Nullable
    private IdeaSourceProvider findSourceProviderForResFolder(@NotNull PsiDirectory resDirectory) {
        if (resDirectory == null) {
            AndroidResFileNode.$$$reportNull$$$0(5);
        }
        for (IdeaSourceProvider provider : AndroidProjectViewPane.getSourceProviders(this.myFacet)) {
            if (!provider.getResDirectories().contains(resDirectory.getVirtualFile())) continue;
            return provider;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "obj";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resDirectory";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/navigator/nodes/AndroidResFileNode";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "compareTo";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "findSourceProviderForResFolder";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

