/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.monitor.ui.network.view;

import com.android.tools.adtui.AccordionLayout;
import com.android.tools.adtui.Animatable;
import com.android.tools.adtui.Choreographer;
import com.android.tools.adtui.model.Range;
import com.android.tools.datastore.Poller;
import com.android.tools.datastore.SeriesDataStore;
import com.android.tools.idea.monitor.tool.ProfilerEventListener;
import com.android.tools.idea.monitor.ui.BaseProfilerUiManager;
import com.android.tools.idea.monitor.ui.BaseSegment;
import com.android.tools.idea.monitor.ui.network.model.HttpDataCache;
import com.android.tools.idea.monitor.ui.network.model.NetworkDataPoller;
import com.android.tools.idea.monitor.ui.network.model.RpcNetworkCaptureModel;
import com.android.tools.idea.monitor.ui.network.view.NetworkCaptureSegment;
import com.android.tools.idea.monitor.ui.network.view.NetworkDetailedView;
import com.android.tools.idea.monitor.ui.network.view.NetworkRadioSegment;
import com.android.tools.idea.monitor.ui.network.view.NetworkSegment;
import com.google.common.collect.Sets;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.EventDispatcher;
import java.awt.Component;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public final class NetworkProfilerUiManager
extends BaseProfilerUiManager {
    public static final int NETWORK_CONNECTIVITY_HEIGHT = 40;
    private NetworkRadioSegment myRadioSegment;
    private NetworkCaptureSegment myCaptureSegment;
    private NetworkDetailedView myDetailedView;
    @NotNull
    private final HttpDataCache myDataCache;

    public NetworkProfilerUiManager(@NotNull Range timeCurrentRangeUs, @NotNull Choreographer choreographer, @NotNull SeriesDataStore dataStore, @NotNull EventDispatcher<ProfilerEventListener> eventDispatcher, @NotNull Project project) {
        if (timeCurrentRangeUs == null) {
            NetworkProfilerUiManager.$$$reportNull$$$0(0);
        }
        if (choreographer == null) {
            NetworkProfilerUiManager.$$$reportNull$$$0(1);
        }
        if (dataStore == null) {
            NetworkProfilerUiManager.$$$reportNull$$$0(2);
        }
        if (eventDispatcher == null) {
            NetworkProfilerUiManager.$$$reportNull$$$0(3);
        }
        if (project == null) {
            NetworkProfilerUiManager.$$$reportNull$$$0(4);
        }
        super(timeCurrentRangeUs, choreographer, dataStore, eventDispatcher);
        this.myDataCache = new HttpDataCache(this.myDataStore.getDeviceProfilerService().getDevice());
        this.myDetailedView = new NetworkDetailedView(project);
    }

    @Override
    @NotNull
    public Set<Poller> createPollers(int pid) {
        HashSet hashSet = Sets.newHashSet((Object[])new Poller[]{new NetworkDataPoller(this.myDataStore, pid)});
        if (hashSet == null) {
            NetworkProfilerUiManager.$$$reportNull$$$0(5);
        }
        return hashSet;
    }

    @Override
    @NotNull
    protected BaseSegment createOverviewSegment(@NotNull Range timeCurrentRangeUs, @NotNull SeriesDataStore dataStore, @NotNull EventDispatcher<ProfilerEventListener> eventDispatcher) {
        if (timeCurrentRangeUs == null) {
            NetworkProfilerUiManager.$$$reportNull$$$0(6);
        }
        if (dataStore == null) {
            NetworkProfilerUiManager.$$$reportNull$$$0(7);
        }
        if (eventDispatcher == null) {
            NetworkProfilerUiManager.$$$reportNull$$$0(8);
        }
        NetworkSegment networkSegment = new NetworkSegment(timeCurrentRangeUs, dataStore, eventDispatcher);
        if (networkSegment == null) {
            NetworkProfilerUiManager.$$$reportNull$$$0(9);
        }
        return networkSegment;
    }

    @Override
    public void setupDetailedViewUi(@NotNull JPanel toolbar, @NotNull JPanel detailPanel) {
        if (toolbar == null) {
            NetworkProfilerUiManager.$$$reportNull$$$0(10);
        }
        if (detailPanel == null) {
            NetworkProfilerUiManager.$$$reportNull$$$0(11);
        }
        super.setupDetailedViewUi(toolbar, detailPanel);
        detailPanel.add((Component)this.myDetailedView, "Center");
    }

    @Override
    public boolean isDetailedViewVerticallySplit() {
        return false;
    }

    @Override
    public void setupExtendedOverviewUi(@NotNull JPanel toolbar, @NotNull JPanel overviewPanel) {
        if (toolbar == null) {
            NetworkProfilerUiManager.$$$reportNull$$$0(12);
        }
        if (overviewPanel == null) {
            NetworkProfilerUiManager.$$$reportNull$$$0(13);
        }
        super.setupExtendedOverviewUi(toolbar, overviewPanel);
        this.myRadioSegment = new NetworkRadioSegment(this.myTimeCurrentRangeUs, this.myDataStore, (EventDispatcher<ProfilerEventListener>)this.myEventDispatcher);
        this.setupAndRegisterSegment(this.myRadioSegment, 40, 40, 40);
        overviewPanel.add(this.myRadioSegment);
        RpcNetworkCaptureModel captureModel = new RpcNetworkCaptureModel(this.myDataStore.getDeviceProfilerService(), this.myDataCache);
        this.myCaptureSegment = new NetworkCaptureSegment(this.myTimeCurrentRangeUs, captureModel, httpData -> {
            VirtualFile virtualFile;
            String responseFilePath = httpData.getHttpResponsePayloadId();
            File file = !StringUtil.isEmptyOrSpaces((String)responseFilePath) ? this.myDataCache.getFile(responseFilePath) : null;
            VirtualFile virtualFile2 = virtualFile = file != null ? LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file) : null;
            if (virtualFile != null) {
                this.myDetailedView.showConnectionDetails(virtualFile);
                ((ProfilerEventListener)this.myEventDispatcher.getMulticaster()).profilerExpanded(BaseProfilerUiManager.ProfilerType.NETWORK);
            }
        }, (EventDispatcher<ProfilerEventListener>)this.myEventDispatcher);
        this.setupAndRegisterSegment(this.myCaptureSegment, DEFAULT_MONITOR_MIN_HEIGHT, DEFAULT_MONITOR_PREFERRED_HEIGHT, DEFAULT_MONITOR_MAX_HEIGHT);
        overviewPanel.add(this.myCaptureSegment);
        this.myChoreographer.register((Animatable)this.myCaptureSegment);
        NetworkProfilerUiManager.setSegmentState(overviewPanel, this.myCaptureSegment, AccordionLayout.AccordionState.MAXIMIZE);
    }

    @Override
    public void resetProfiler(@NotNull JPanel toolbar, @NotNull JPanel overviewPanel, @NotNull JPanel detailPanel) {
        if (toolbar == null) {
            NetworkProfilerUiManager.$$$reportNull$$$0(14);
        }
        if (overviewPanel == null) {
            NetworkProfilerUiManager.$$$reportNull$$$0(15);
        }
        if (detailPanel == null) {
            NetworkProfilerUiManager.$$$reportNull$$$0(16);
        }
        super.resetProfiler(toolbar, overviewPanel, detailPanel);
        if (this.myRadioSegment != null) {
            overviewPanel.remove(this.myRadioSegment);
            this.myRadioSegment = null;
        }
        if (this.myCaptureSegment != null) {
            overviewPanel.remove(this.myCaptureSegment);
            this.myChoreographer.unregister((Animatable)this.myCaptureSegment);
            this.myCaptureSegment = null;
        }
        if (this.myDetailedView != null) {
            detailPanel.remove(this.myDetailedView);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timeCurrentRangeUs";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "choreographer";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStore";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventDispatcher";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/monitor/ui/network/view/NetworkProfilerUiManager";
                break;
            }
            case 10: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolbar";
                break;
            }
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "detailPanel";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "overviewPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/monitor/ui/network/view/NetworkProfilerUiManager";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createPollers";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createOverviewSegment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 9: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createOverviewSegment";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setupDetailedViewUi";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setupExtendedOverviewUi";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "resetProfiler";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

