/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.monitor.ui.network.view;

import com.android.tools.adtui.Animatable;
import com.android.tools.adtui.chart.StateChart;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.DefaultDataSeries;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangedSeries;
import com.android.tools.idea.monitor.tool.ProfilerEventListener;
import com.android.tools.idea.monitor.ui.BaseSegment;
import com.android.tools.idea.monitor.ui.network.model.HttpData;
import com.android.tools.idea.monitor.ui.network.model.NetworkCaptureModel;
import com.android.tools.idea.monitor.ui.network.view.Constants;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.JBTable;
import com.intellij.util.EventDispatcher;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;

public class NetworkCaptureSegment
extends BaseSegment
implements Animatable {
    private static final String SEGMENT_NAME = "Network Capture";
    private static final int ROW_HEIGHT_PADDING = 5;
    private static final EnumMap<NetworkState, Color> NETWORK_STATE_COLORS = new EnumMap(NetworkState.class);
    private int myRowHeight;
    @NotNull
    private final List<StateChart<NetworkState>> myCharts;
    @NotNull
    private List<HttpData> myDataList;
    @NotNull
    private final DetailedViewListener myDetailedViewListener;
    @NotNull
    private final NetworkCaptureModel myModel;
    private JTable myCaptureTable;

    public NetworkCaptureSegment(@NotNull Range timeCurrentRangeUs, @NotNull NetworkCaptureModel model, @NotNull DetailedViewListener detailedViewListener, @NotNull EventDispatcher<ProfilerEventListener> dispatcher) {
        if (timeCurrentRangeUs == null) {
            NetworkCaptureSegment.$$$reportNull$$$0(0);
        }
        if (model == null) {
            NetworkCaptureSegment.$$$reportNull$$$0(1);
        }
        if (detailedViewListener == null) {
            NetworkCaptureSegment.$$$reportNull$$$0(2);
        }
        if (dispatcher == null) {
            NetworkCaptureSegment.$$$reportNull$$$0(3);
        }
        super(SEGMENT_NAME, timeCurrentRangeUs, dispatcher);
        this.myDetailedViewListener = detailedViewListener;
        this.myCharts = new ArrayList<StateChart<NetworkState>>();
        this.myDataList = new ArrayList<HttpData>();
        this.myModel = model;
        int defaultFontHeight = this.getFontMetrics((Font)AdtUiUtils.DEFAULT_FONT).getHeight();
        this.myRowHeight = defaultFontHeight + 5;
    }

    @NotNull
    private JTable createCaptureTable() {
        final JBTable table = new JBTable((TableModel)new NetworkCaptureTableModel());
        table.setDefaultRenderer(StateChart.class, (t, value, isSelected, hasFocus, row, column) -> this.myCharts.get(row));
        table.setSelectionMode(0);
        table.getSelectionModel().addListSelectionListener(e -> {
            if (table.getSelectedRow() < this.myDataList.size()) {
                this.myDetailedViewListener.showDetailedConnection(this.myDataList.get(table.getSelectedRow()));
            }
        });
        table.setFont((Font)AdtUiUtils.DEFAULT_FONT);
        table.setRowHeight(this.myRowHeight);
        table.addComponentListener((ComponentListener)new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                table.getColumnModel().getColumn(Column.TIMELINE.ordinal()).setPreferredWidth(NetworkCaptureSegment.this.myCaptureTable.getWidth() / 2);
            }
        });
        JBTable jBTable = table;
        if (jBTable == null) {
            NetworkCaptureSegment.$$$reportNull$$$0(4);
        }
        return jBTable;
    }

    @Override
    protected void setCenterContent(@NotNull JPanel panel) {
        if (panel == null) {
            NetworkCaptureSegment.$$$reportNull$$$0(5);
        }
        this.myCaptureTable = this.createCaptureTable();
        panel.add((Component)new JBScrollPane((Component)this.myCaptureTable), "Center");
    }

    public void animate(float frameLength) {
        this.myDataList = this.myModel.getData(this.myTimeCurrentRangeUs);
        this.myCharts.clear();
        for (HttpData data : this.myDataList) {
            DefaultDataSeries series = new DefaultDataSeries();
            series.add(0L, (Object)NetworkState.NONE);
            series.add(data.getStartTimeUs(), (Object)NetworkState.SENDING);
            if (data.getDownloadingTimeUs() > 0L) {
                series.add(data.getDownloadingTimeUs(), (Object)NetworkState.RECEIVING);
            }
            if (data.getEndTimeUs() > 0L) {
                series.add(data.getEndTimeUs(), (Object)NetworkState.NONE);
            }
            StateChart chart = new StateChart(NETWORK_STATE_COLORS);
            chart.addSeries(new RangedSeries(this.myTimeCurrentRangeUs, (DataSeries)series));
            chart.animate(frameLength);
            this.myCharts.add((StateChart<NetworkState>)chart);
        }
    }

    static {
        NETWORK_STATE_COLORS.put(NetworkState.SENDING, Constants.NETWORK_SENDING_COLOR);
        NETWORK_STATE_COLORS.put(NetworkState.RECEIVING, Constants.NETWORK_RECEIVING_COLOR);
        NETWORK_STATE_COLORS.put(NetworkState.WAITING, Constants.NETWORK_WAITING_COLOR);
        NETWORK_STATE_COLORS.put(NetworkState.NONE, AdtUiUtils.DEFAULT_BACKGROUND_COLOR);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timeCurrentRangeUs";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "detailedViewListener";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dispatcher";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/monitor/ui/network/view/NetworkCaptureSegment";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/monitor/ui/network/view/NetworkCaptureSegment";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createCaptureTable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setCenterContent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class NetworkCaptureTableModel
    extends AbstractTableModel {
        private NetworkCaptureTableModel() {
        }

        @Override
        public int getRowCount() {
            return NetworkCaptureSegment.this.myDataList.size();
        }

        @Override
        public int getColumnCount() {
            return Column.values().length;
        }

        @Override
        public String getColumnName(int column) {
            return StringUtil.capitalize((String)Column.values()[column].toString().toLowerCase());
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (Column.values()[columnIndex]) {
                case TIMELINE: {
                    return StateChart.class;
                }
            }
            return Object.class;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (Column.values()[columnIndex]) {
                case INDEX: {
                    return String.valueOf(rowIndex);
                }
                case URL: {
                    return ((HttpData)NetworkCaptureSegment.this.myDataList.get(rowIndex)).getUrl();
                }
                case SIZE: {
                    long bytes = ((HttpData)NetworkCaptureSegment.this.myDataList.get(rowIndex)).getHttpResponseBodySize();
                    return bytes >= 0L ? String.valueOf(bytes / 1024L) + " K" : "";
                }
                case DURATION: {
                    HttpData httpData = (HttpData)NetworkCaptureSegment.this.myDataList.get(rowIndex);
                    if (httpData.getEndTimeUs() < httpData.getStartTimeUs()) break;
                    long durationMs = TimeUnit.MICROSECONDS.toMillis(httpData.getEndTimeUs() - httpData.getStartTimeUs());
                    return String.valueOf(durationMs) + " ms";
                }
                case TIMELINE: {
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unexpected getValueAt called with: " + (Object)((Object)Column.values()[columnIndex]));
                }
            }
            return "";
        }
    }

    private static enum Column {
        INDEX,
        URL,
        SIZE,
        DURATION,
        TIMELINE;

    }

    public static enum NetworkState {
        SENDING,
        RECEIVING,
        WAITING,
        NONE;

    }

    public static interface DetailedViewListener {
        public void showDetailedConnection(HttpData var1);
    }
}

