/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.monitor.ui.network.model;

import gnu.trove.TDoubleArrayList;
import gnu.trove.TLongArrayList;
import java.util.concurrent.TimeUnit;

public final class SpeedData {
    private static final double SEC_TO_US = TimeUnit.SECONDS.toMicros(1L);
    private final TLongArrayList myTrafficTimeData = new TLongArrayList();
    private final TLongArrayList mySentSpeeds = new TLongArrayList();
    private final TLongArrayList myReceivedSpeeds = new TLongArrayList();
    private long myLastSentSoFar = Long.MIN_VALUE;
    private long myLastReceivedSoFar = Long.MIN_VALUE;

    private static double calcTrapezoidMaxWidth(double maxWidth, double baseLength, double area) {
        if (area == 0.0) {
            return 0.0;
        }
        if (maxWidth * baseLength / 2.0 > area) {
            return area * 2.0 / baseLength;
        }
        return maxWidth;
    }

    private static double interpolate(double val1, double val2, double percent) {
        return val1 + (val2 - val1) * percent;
    }

    public TLongArrayList getTimeData() {
        return this.myTrafficTimeData;
    }

    public TLongArrayList getSent() {
        return this.mySentSpeeds;
    }

    public TLongArrayList getReceived() {
        return this.myReceivedSpeeds;
    }

    public void add(long sentBytesSoFar, long receivedBytesSoFar, long timestampUs) {
        if (this.myTrafficTimeData.isEmpty()) {
            this.myTrafficTimeData.add(timestampUs);
            this.myReceivedSpeeds.add(0L);
            this.mySentSpeeds.add(0L);
        } else {
            this.convertTrafficsToSpeeds(timestampUs, sentBytesSoFar - this.myLastSentSoFar, receivedBytesSoFar - this.myLastReceivedSoFar);
        }
        this.myLastSentSoFar = sentBytesSoFar;
        this.myLastReceivedSoFar = receivedBytesSoFar;
    }

    private void convertTrafficsToSpeeds(long timestampUs, long sentBytes, long receivedBytes) {
        double timeDeltaSec;
        int i;
        long lastTimeUs = this.myTrafficTimeData.get(this.myTrafficTimeData.size() - 1);
        long lastReceivedSpeed = this.myReceivedSpeeds.get(this.myReceivedSpeeds.size() - 1);
        long lastSentSpeed = this.mySentSpeeds.get(this.mySentSpeeds.size() - 1);
        double timestampDeltaSec = (double)(timestampUs - lastTimeUs) / SEC_TO_US;
        double receivedTimeDeltaSec = SpeedData.calcTrapezoidMaxWidth(timestampDeltaSec, lastReceivedSpeed, receivedBytes);
        double sentTimeDeltaSec = SpeedData.calcTrapezoidMaxWidth(timestampDeltaSec, lastSentSpeed, sentBytes);
        TDoubleArrayList timeDeltasSec = new TDoubleArrayList(3);
        timeDeltasSec.add(receivedTimeDeltaSec);
        timeDeltasSec.add(sentTimeDeltaSec);
        timeDeltasSec.add(timestampDeltaSec);
        timeDeltasSec.sort();
        long[] receivedSpeeds = new long[timeDeltasSec.size()];
        long[] sentSpeeds = new long[timeDeltasSec.size()];
        for (i = 0; i < timeDeltasSec.size(); ++i) {
            timeDeltaSec = timeDeltasSec.get(i);
            if (timeDeltaSec <= receivedTimeDeltaSec) {
                double receivedSpeed = 2.0 * (double)receivedBytes / receivedTimeDeltaSec - (double)lastReceivedSpeed;
                receivedSpeeds[i] = (long)SpeedData.interpolate(lastReceivedSpeed, receivedSpeed, timeDeltaSec / receivedTimeDeltaSec);
                continue;
            }
            receivedSpeeds[i] = 0L;
        }
        for (i = 0; i < timeDeltasSec.size(); ++i) {
            timeDeltaSec = timeDeltasSec.get(i);
            if (timeDeltaSec <= sentTimeDeltaSec) {
                double sentSpeed = 2.0 * (double)sentBytes / sentTimeDeltaSec - (double)lastSentSpeed;
                sentSpeeds[i] = (long)SpeedData.interpolate(lastSentSpeed, sentSpeed, timeDeltaSec / sentTimeDeltaSec);
                continue;
            }
            sentSpeeds[i] = 0L;
        }
        for (i = 0; i < timeDeltasSec.size(); ++i) {
            double timeIntervalSec = timeDeltasSec.get(i);
            if (i > 0 && timeIntervalSec == timeDeltasSec.get(i - 1)) continue;
            this.myTrafficTimeData.add((long)(timeIntervalSec * SEC_TO_US + (double)lastTimeUs));
            this.mySentSpeeds.add(sentSpeeds[i]);
            this.myReceivedSpeeds.add(receivedSpeeds[i]);
        }
    }
}

