/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.monitor.ui.network.model;

import com.android.tools.adtui.model.Range;
import com.android.tools.datastore.profilerclient.DeviceProfilerService;
import com.android.tools.idea.monitor.ui.network.model.HttpData;
import com.android.tools.idea.monitor.ui.network.model.HttpDataCache;
import com.android.tools.idea.monitor.ui.network.model.NetworkCaptureModel;
import com.android.tools.profiler.proto.NetworkProfiler;
import com.android.tools.profiler.proto.NetworkServiceGrpc;
import io.grpc.StatusRuntimeException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public final class RpcNetworkCaptureModel
implements NetworkCaptureModel {
    @NotNull
    private final NetworkServiceGrpc.NetworkServiceBlockingStub myNetworkService;
    @NotNull
    private final HttpDataCache myDataCache;
    private final int myPid;

    public RpcNetworkCaptureModel(@NotNull DeviceProfilerService service, @NotNull HttpDataCache dataCache) {
        if (service == null) {
            RpcNetworkCaptureModel.$$$reportNull$$$0(0);
        }
        if (dataCache == null) {
            RpcNetworkCaptureModel.$$$reportNull$$$0(1);
        }
        this.myNetworkService = service.getNetworkService();
        this.myDataCache = dataCache;
        this.myPid = service.getSelectedProcessId();
    }

    @Override
    @NotNull
    public List<HttpData> getData(@NotNull Range timeCurrentRangeUs) {
        NetworkProfiler.HttpRangeResponse response;
        if (timeCurrentRangeUs == null) {
            RpcNetworkCaptureModel.$$$reportNull$$$0(2);
        }
        NetworkProfiler.HttpRangeRequest request = NetworkProfiler.HttpRangeRequest.newBuilder().setAppId(this.myPid).setStartTimestamp(TimeUnit.MICROSECONDS.toNanos((long)timeCurrentRangeUs.getMin())).setEndTimestamp(TimeUnit.MICROSECONDS.toNanos((long)timeCurrentRangeUs.getMax())).build();
        try {
            response = this.myNetworkService.getHttpRange(request);
        }
        catch (StatusRuntimeException e) {
            List<HttpData> list = Collections.emptyList();
            if (list == null) {
                RpcNetworkCaptureModel.$$$reportNull$$$0(3);
            }
            return list;
        }
        ArrayList<HttpData> httpDataList = new ArrayList<HttpData>(response.getDataList().size());
        for (NetworkProfiler.HttpConnectionData connection : response.getDataList()) {
            HttpData httpData = new HttpData();
            httpData.setId(connection.getConnId());
            httpData.setStartTimeUs(TimeUnit.NANOSECONDS.toMicros(connection.getStartTimestamp()));
            this.requestHttpRequest(httpData);
            if (connection.getEndTimestamp() != 0L) {
                httpData.setEndTimeUs(TimeUnit.NANOSECONDS.toMicros(connection.getEndTimestamp()));
                httpData.setDownloadingTimeUs(TimeUnit.NANOSECONDS.toMicros(connection.getDownloadingTimestamp()));
                this.requestHttpResponseBody(httpData);
            }
            httpDataList.add(httpData);
        }
        ArrayList<HttpData> arrayList = httpDataList;
        if (arrayList == null) {
            RpcNetworkCaptureModel.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    private void requestHttpRequest(@NotNull HttpData data) {
        NetworkProfiler.HttpDetailsResponse.Request result;
        if (data == null) {
            RpcNetworkCaptureModel.$$$reportNull$$$0(5);
        }
        NetworkProfiler.HttpDetailsRequest request = NetworkProfiler.HttpDetailsRequest.newBuilder().setConnId(data.getId()).setType(NetworkProfiler.HttpDetailsRequest.Type.REQUEST).build();
        try {
            result = this.myNetworkService.getHttpDetails(request).getRequest();
        }
        catch (StatusRuntimeException e) {
            return;
        }
        data.setUrl(result.getUrl());
        data.setMethod(result.getMethod());
    }

    private void requestHttpResponseBody(@NotNull HttpData data) {
        NetworkProfiler.HttpDetailsResponse response;
        if (data == null) {
            RpcNetworkCaptureModel.$$$reportNull$$$0(6);
        }
        NetworkProfiler.HttpDetailsRequest request = NetworkProfiler.HttpDetailsRequest.newBuilder().setConnId(data.getId()).setType(NetworkProfiler.HttpDetailsRequest.Type.RESPONSE_BODY).build();
        try {
            response = this.myNetworkService.getHttpDetails(request);
        }
        catch (StatusRuntimeException e) {
            return;
        }
        String responseFilePath = response.getResponseBody().getPayloadId();
        data.setHttpResponsePayloadId(responseFilePath);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataCache";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timeCurrentRangeUs";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/monitor/ui/network/model/RpcNetworkCaptureModel";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/monitor/ui/network/model/RpcNetworkCaptureModel";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "requestHttpRequest";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "requestHttpResponseBody";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

