/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.monitor.ui.memory.model;

import com.android.tools.adtui.model.DefaultDurationData;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.datastore.DataAdapter;
import com.android.tools.datastore.Poller;
import com.android.tools.datastore.SeriesDataStore;
import com.android.tools.datastore.SeriesDataType;
import com.android.tools.idea.monitor.ui.memory.model.AllocationTrackingSample;
import com.android.tools.idea.monitor.ui.memory.model.MemoryDataCache;
import com.android.tools.profiler.proto.MemoryProfiler;
import com.google.protobuf3jarjar.ByteString;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.util.containers.HashMap;
import io.grpc.StatusRuntimeException;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MemoryPoller
extends Poller {
    @NotNull
    private final MemoryDataCache myDataCache;
    private long myStartTimestampNs;
    private final int myAppId;
    private boolean myHasPendingHeapDumpSample;

    public MemoryPoller(@NotNull SeriesDataStore dataStore, @NotNull MemoryDataCache dataCache, int appId) {
        if (dataStore == null) {
            MemoryPoller.$$$reportNull$$$0(0);
        }
        if (dataCache == null) {
            MemoryPoller.$$$reportNull$$$0(1);
        }
        super(dataStore, POLLING_DELAY_NS);
        this.myStartTimestampNs = Long.MIN_VALUE;
        this.myDataCache = dataCache;
        this.myAppId = appId;
        this.myHasPendingHeapDumpSample = false;
    }

    public Map<SeriesDataType, DataAdapter> createAdapters() {
        HashMap adapters = new HashMap();
        adapters.put(SeriesDataType.MEMORY_TOTAL, new MemorySampleAdapter<Long>(){

            @Override
            public Long getSampleValue(MemoryProfiler.MemoryData.MemorySample sample) {
                return sample.getTotalMem();
            }
        });
        adapters.put(SeriesDataType.MEMORY_JAVA, new MemorySampleAdapter<Long>(){

            @Override
            public Long getSampleValue(MemoryProfiler.MemoryData.MemorySample sample) {
                return sample.getJavaMem();
            }
        });
        adapters.put(SeriesDataType.MEMORY_NATIVE, new MemorySampleAdapter<Long>(){

            @Override
            public Long getSampleValue(MemoryProfiler.MemoryData.MemorySample sample) {
                return sample.getNativeMem();
            }
        });
        adapters.put(SeriesDataType.MEMORY_GRAPHICS, new MemorySampleAdapter<Long>(){

            @Override
            public Long getSampleValue(MemoryProfiler.MemoryData.MemorySample sample) {
                return sample.getGraphicsMem();
            }
        });
        adapters.put(SeriesDataType.MEMORY_CODE, new MemorySampleAdapter<Long>(){

            @Override
            public Long getSampleValue(MemoryProfiler.MemoryData.MemorySample sample) {
                return sample.getCodeMem();
            }
        });
        adapters.put(SeriesDataType.MEMORY_OTHERS, new MemorySampleAdapter<Long>(){

            @Override
            public Long getSampleValue(MemoryProfiler.MemoryData.MemorySample sample) {
                return sample.getOthersMem();
            }
        });
        adapters.put(SeriesDataType.MEMORY_OBJECT_COUNT, new VmStatsSampleAdapter<Long>(){

            @Override
            public Long getSampleValue(MemoryProfiler.MemoryData.VmStatsSample sample) {
                return new Long(sample.getJavaAllocationCount() - sample.getJavaFreeCount());
            }
        });
        adapters.put(SeriesDataType.MEMORY_HEAPDUMP_EVENT, new HeapDumpSampleAdapter());
        adapters.put(SeriesDataType.MEMORY_ALLOCATION_TRACKING_EVENT, new AllocationTrackingSampleAdapter());
        return adapters;
    }

    protected void asyncInit() throws StatusRuntimeException {
        this.myService.getMemoryService().startMonitoringApp(MemoryProfiler.MemoryStartRequest.newBuilder().setAppId(this.myAppId).build());
    }

    protected void asyncShutdown() throws StatusRuntimeException {
        this.myService.getMemoryService().stopMonitoringApp(MemoryProfiler.MemoryStopRequest.newBuilder().setAppId(this.myAppId).build());
    }

    protected void poll() throws StatusRuntimeException {
        MemoryProfiler.MemoryRequest request = MemoryProfiler.MemoryRequest.newBuilder().setAppId(this.myAppId).setStartTime(this.myStartTimestampNs).setEndTime(Long.MAX_VALUE).build();
        MemoryProfiler.MemoryData result = this.myService.getMemoryService().getData(request);
        this.myDataCache.appendMemorySamples(result.getMemSamplesList());
        this.myDataCache.appendVmStatsSamples(result.getVmStatsSamplesList());
        ArrayList<MemoryProfiler.HeapDumpInfo> pendingFetch = new ArrayList<MemoryProfiler.HeapDumpInfo>();
        for (int i = 0; i < result.getHeapDumpInfosCount(); ++i) {
            MemoryProfiler.HeapDumpInfo info = result.getHeapDumpInfos(i);
            if (this.myHasPendingHeapDumpSample) {
                assert (i == 0 && info.getEndTime() != -1L);
                MemoryProfiler.HeapDumpInfo previousLastInfo = this.myDataCache.swapLastHeapDumpInfo(info);
                assert (previousLastInfo.getFilePath().equals(info.getFilePath()));
                this.myHasPendingHeapDumpSample = false;
                pendingFetch.add(info);
                continue;
            }
            this.myDataCache.appendHeapDumpInfo(info);
            if (info.getEndTime() == -1L) {
                assert (i == result.getHeapDumpInfosCount() - 1);
                this.myHasPendingHeapDumpSample = true;
                continue;
            }
            pendingFetch.add(info);
        }
        if (!pendingFetch.isEmpty()) {
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                for (MemoryProfiler.HeapDumpInfo info : pendingFetch) {
                    ByteString heapDumpData = this.pullHeapDumpData(info);
                    if (heapDumpData == null) continue;
                    this.myDataCache.addPulledHeapDumpData(info, heapDumpData);
                }
            });
        }
        if (result.getEndTimestamp() > this.myStartTimestampNs) {
            this.myStartTimestampNs = result.getEndTimestamp();
        }
    }

    public boolean requestHeapDump() {
        MemoryProfiler.TriggerHeapDumpRequest.Builder builder = MemoryProfiler.TriggerHeapDumpRequest.newBuilder();
        builder.setAppId(this.myAppId);
        builder.setRequestTime(this.myStartTimestampNs);
        switch (this.myService.getMemoryService().triggerHeapDump(builder.build()).getStatus()) {
            case SUCCESS: {
                return true;
            }
        }
        return false;
    }

    @Nullable
    private ByteString pullHeapDumpData(@NotNull MemoryProfiler.HeapDumpInfo info) {
        if (info == null) {
            MemoryPoller.$$$reportNull$$$0(2);
        }
        if (!info.getSuccess()) {
            return null;
        }
        MemoryProfiler.HeapDumpDataRequest dataRequest = MemoryProfiler.HeapDumpDataRequest.newBuilder().setAppId(this.myAppId).setDumpId(info.getDumpId()).build();
        MemoryProfiler.DumpDataResponse response = this.myService.getMemoryService().getHeapDump(dataRequest);
        if (response.getStatus() == MemoryProfiler.DumpDataResponse.Status.SUCCESS) {
            return response.getData();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStore";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataCache";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/monitor/ui/memory/model/MemoryPoller";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "pullHeapDumpData";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class AllocationTrackingSampleAdapter
    implements DataAdapter<DefaultDurationData> {
        private AllocationTrackingSampleAdapter() {
        }

        public int getClosestTimeIndex(long timeUs, boolean leftClosest) {
            return MemoryPoller.this.myDataCache.getLatestPriorAllocationTrackingSampleIndex(TimeUnit.MICROSECONDS.toNanos(timeUs), leftClosest);
        }

        public SeriesData<DefaultDurationData> get(int index) {
            AllocationTrackingSample sample = MemoryPoller.this.myDataCache.getAllocationTrackingSample(index);
            long startTimeUs = TimeUnit.NANOSECONDS.toMicros(sample.getStartTime());
            long durationUs = sample.getEndTime() == -1L ? -1L : TimeUnit.NANOSECONDS.toMicros(sample.getEndTime() - sample.getStartTime());
            return new SeriesData(startTimeUs, (Object)new DefaultDurationData(durationUs));
        }

        public void reset() {
            MemoryPoller.this.myDataCache.reset();
        }

        public void stop() {
            MemoryPoller.this.stop();
        }
    }

    private class HeapDumpSampleAdapter
    implements DataAdapter<DefaultDurationData> {
        private HeapDumpSampleAdapter() {
        }

        public int getClosestTimeIndex(long timeUs, boolean leftClosest) {
            return MemoryPoller.this.myDataCache.getLatestPriorHeapDumpInfoIndex(TimeUnit.MICROSECONDS.toNanos(timeUs), leftClosest);
        }

        public void reset() {
            MemoryPoller.this.myDataCache.reset();
        }

        public void stop() {
            MemoryPoller.this.stop();
        }

        public SeriesData<DefaultDurationData> get(int index) {
            MemoryProfiler.HeapDumpInfo info = MemoryPoller.this.myDataCache.getHeapDumpInfo(index);
            long startTimeUs = TimeUnit.NANOSECONDS.toMicros(info.getStartTime());
            long durationUs = info.getEndTime() == -1L ? -1L : TimeUnit.NANOSECONDS.toMicros(info.getEndTime() - info.getStartTime());
            return new SeriesData(startTimeUs, (Object)new DefaultDurationData(durationUs));
        }
    }

    private abstract class VmStatsSampleAdapter<T>
    implements DataAdapter<T> {
        private VmStatsSampleAdapter() {
        }

        public int getClosestTimeIndex(long time, boolean leftClosest) {
            return MemoryPoller.this.myDataCache.getLatestPriorVmStatsSampleIndex(TimeUnit.MICROSECONDS.toNanos(time), leftClosest);
        }

        public void reset() {
            MemoryPoller.this.myDataCache.reset();
        }

        public void stop() {
            MemoryPoller.this.stop();
        }

        public SeriesData<T> get(int index) {
            MemoryProfiler.MemoryData.VmStatsSample sample = MemoryPoller.this.myDataCache.getVmStatsSample(index);
            return new SeriesData(TimeUnit.NANOSECONDS.toMicros(sample.getTimestamp()), this.getSampleValue(sample));
        }

        public abstract T getSampleValue(MemoryProfiler.MemoryData.VmStatsSample var1);
    }

    private abstract class MemorySampleAdapter<T>
    implements DataAdapter<T> {
        private MemorySampleAdapter() {
        }

        public int getClosestTimeIndex(long timeUs, boolean leftClosest) {
            return MemoryPoller.this.myDataCache.getLatestPriorMemorySampleIndex(TimeUnit.MICROSECONDS.toNanos(timeUs), leftClosest);
        }

        public void reset() {
            MemoryPoller.this.myDataCache.reset();
        }

        public void stop() {
            MemoryPoller.this.stop();
        }

        public SeriesData<T> get(int index) {
            MemoryProfiler.MemoryData.MemorySample sample = MemoryPoller.this.myDataCache.getMemorySample(index);
            return new SeriesData(TimeUnit.NANOSECONDS.toMicros(sample.getTimestamp()), this.getSampleValue(sample));
        }

        public abstract T getSampleValue(MemoryProfiler.MemoryData.MemorySample var1);
    }
}

