/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.monitor.ui.cpu.view;

import com.android.tools.adtui.AccordionLayout;
import com.android.tools.adtui.Animatable;
import com.android.tools.adtui.AnimatedRange;
import com.android.tools.adtui.Choreographer;
import com.android.tools.adtui.chart.hchart.HRenderer;
import com.android.tools.adtui.chart.hchart.HTreeChart;
import com.android.tools.adtui.chart.hchart.JavaMethodHRenderer;
import com.android.tools.adtui.chart.hchart.JavaMethodUsageHRenderer;
import com.android.tools.adtui.chart.hchart.Method;
import com.android.tools.adtui.chart.hchart.MethodUsage;
import com.android.tools.adtui.chart.hchart.NativeMethodHRenderer;
import com.android.tools.adtui.chart.hchart.NativeMethodUsageHRenderer;
import com.android.tools.adtui.model.HNode;
import com.android.tools.adtui.model.Range;
import com.android.tools.datastore.Poller;
import com.android.tools.datastore.SeriesDataStore;
import com.android.tools.datastore.profilerclient.DeviceProfilerService;
import com.android.tools.idea.ddms.DeviceContext;
import com.android.tools.idea.monitor.tool.ProfilerEventListener;
import com.android.tools.idea.monitor.tool.TraceRequestHandler;
import com.android.tools.idea.monitor.ui.BaseProfilerUiManager;
import com.android.tools.idea.monitor.ui.BaseSegment;
import com.android.tools.idea.monitor.ui.cpu.model.AppTrace;
import com.android.tools.idea.monitor.ui.cpu.model.TraceDataStore;
import com.android.tools.idea.monitor.ui.cpu.view.CPUTraceController;
import com.android.tools.idea.monitor.ui.cpu.view.CpuUsageSegment;
import com.android.tools.idea.monitor.ui.cpu.view.ThreadsSegment;
import com.android.tools.profilers.cpu.ThreadStateDataSeries;
import com.android.utils.SparseArray;
import com.google.common.collect.Sets;
import com.intellij.openapi.project.Project;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.util.EventDispatcher;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public final class CpuProfilerUiManager
extends BaseProfilerUiManager
implements ThreadsSegment.ThreadSelectedListener {
    static final Dimension DEFAULT_DIMENSION = new Dimension(2000, 2000);
    private ThreadsSegment myThreadSegment;
    private AnimatedRange myTimeSelectionRangeUs;
    private HTreeChart<Method> myExecutionChart;
    private HTreeChart<MethodUsage> myFlameChart;
    private JBTabbedPane myTabbedPane;
    private final DeviceProfilerService mySelectedDeviceProfilerService;
    private final DeviceContext myDeviceContext;
    private final Project myProject;
    private JPanel myTopdownJpanel;
    private JPanel myBottomupJPanel;
    private CPUTraceController myCpuTraceControlsUi;
    private AnimatedRange myFlameChartRange;

    public CpuProfilerUiManager(@NotNull Range timeCurrentRangeUs, @NotNull AnimatedRange timeSelectionRangeUs, @NotNull Choreographer choreographer, @NotNull SeriesDataStore dataStore, @NotNull EventDispatcher<ProfilerEventListener> eventDispatcher, @NotNull DeviceProfilerService selectedDeviceProfilerService, @NotNull DeviceContext deviceContext, Project project) {
        if (timeCurrentRangeUs == null) {
            CpuProfilerUiManager.$$$reportNull$$$0(0);
        }
        if (timeSelectionRangeUs == null) {
            CpuProfilerUiManager.$$$reportNull$$$0(1);
        }
        if (choreographer == null) {
            CpuProfilerUiManager.$$$reportNull$$$0(2);
        }
        if (dataStore == null) {
            CpuProfilerUiManager.$$$reportNull$$$0(3);
        }
        if (eventDispatcher == null) {
            CpuProfilerUiManager.$$$reportNull$$$0(4);
        }
        if (selectedDeviceProfilerService == null) {
            CpuProfilerUiManager.$$$reportNull$$$0(5);
        }
        if (deviceContext == null) {
            CpuProfilerUiManager.$$$reportNull$$$0(6);
        }
        super(timeCurrentRangeUs, choreographer, dataStore, eventDispatcher);
        this.myTimeSelectionRangeUs = timeSelectionRangeUs;
        this.mySelectedDeviceProfilerService = selectedDeviceProfilerService;
        this.myDeviceContext = deviceContext;
        this.myProject = project;
        this.createDetailedViewCharts();
    }

    private void createDetailedViewCharts() {
        this.myExecutionChart = new HTreeChart();
        this.myExecutionChart.setXRange((Range)this.myTimeSelectionRangeUs);
        this.myFlameChart = new HTreeChart(HTreeChart.Orientation.BOTTOM_UP);
    }

    @Override
    @NotNull
    public Set<Poller> createPollers(int pid) {
        HashSet hashSet = Sets.newHashSet();
        if (hashSet == null) {
            CpuProfilerUiManager.$$$reportNull$$$0(7);
        }
        return hashSet;
    }

    @Override
    public void setupExtendedOverviewUi(@NotNull JPanel toolbar, @NotNull JPanel overviewPanel) {
        if (toolbar == null) {
            CpuProfilerUiManager.$$$reportNull$$$0(8);
        }
        if (overviewPanel == null) {
            CpuProfilerUiManager.$$$reportNull$$$0(9);
        }
        super.setupExtendedOverviewUi(toolbar, overviewPanel);
        this.myThreadSegment = new ThreadsSegment(this.myTimeCurrentRangeUs, this.myDataStore, (EventDispatcher<ProfilerEventListener>)this.myEventDispatcher, this);
        this.myChoreographer.register((Animatable)this.myThreadSegment);
        this.setupAndRegisterSegment(this.myThreadSegment, DEFAULT_MONITOR_MIN_HEIGHT, DEFAULT_MONITOR_PREFERRED_HEIGHT, DEFAULT_MONITOR_MAX_HEIGHT);
        overviewPanel.add(this.myThreadSegment);
        CpuProfilerUiManager.setSegmentState(overviewPanel, this.myThreadSegment, AccordionLayout.AccordionState.MAXIMIZE);
        this.myTabbedPane = new JBTabbedPane();
        this.myTopdownJpanel = new JPanel(new BorderLayout());
        this.myBottomupJPanel = new JPanel(new BorderLayout());
        this.createTracingButton(toolbar);
    }

    private void createTracingButton(@NotNull JPanel toolbar) {
        if (toolbar == null) {
            CpuProfilerUiManager.$$$reportNull$$$0(10);
        }
        TraceRequestHandler traceRequestHandler = new TraceRequestHandler(this.mySelectedDeviceProfilerService, this.myDeviceContext, this.myProject);
        this.myCpuTraceControlsUi = new CPUTraceController(traceRequestHandler);
        toolbar.add(this.myCpuTraceControlsUi);
    }

    @Override
    public void setupDetailedViewUi(@NotNull JPanel toolbar, @NotNull JPanel detailPanel) {
        if (toolbar == null) {
            CpuProfilerUiManager.$$$reportNull$$$0(11);
        }
        if (detailPanel == null) {
            CpuProfilerUiManager.$$$reportNull$$$0(12);
        }
        super.setupDetailedViewUi(toolbar, detailPanel);
        this.myExecutionChart.setPreferredSize(DEFAULT_DIMENSION);
        this.myChoreographer.register(this.myExecutionChart);
        this.myTabbedPane.add("Execution Chart", this.myExecutionChart);
        this.myFlameChart.setPreferredSize(DEFAULT_DIMENSION);
        this.myChoreographer.register(this.myFlameChart);
        this.myTabbedPane.add("Flame Chart", this.myFlameChart);
        this.myTabbedPane.add("Top-down stats", (Component)this.myTopdownJpanel);
        this.myTabbedPane.add("Bottom-up stats", (Component)this.myBottomupJPanel);
        detailPanel.add((Component)this.myTabbedPane);
        this.myFlameChartRange = new AnimatedRange();
        this.myChoreographer.register((Animatable)this.myFlameChartRange);
    }

    @Override
    public void resetProfiler(@NotNull JPanel toolbar, @NotNull JPanel overviewPanel, @NotNull JPanel detailPanel) {
        if (toolbar == null) {
            CpuProfilerUiManager.$$$reportNull$$$0(13);
        }
        if (overviewPanel == null) {
            CpuProfilerUiManager.$$$reportNull$$$0(14);
        }
        if (detailPanel == null) {
            CpuProfilerUiManager.$$$reportNull$$$0(15);
        }
        super.resetProfiler(toolbar, overviewPanel, detailPanel);
        if (this.myThreadSegment != null) {
            this.myChoreographer.unregister((Animatable)this.myThreadSegment);
            overviewPanel.remove(this.myThreadSegment);
            this.myThreadSegment = null;
        }
        if (this.myFlameChartRange != null) {
            this.myChoreographer.unregister((Animatable)this.myFlameChartRange);
            this.myFlameChartRange = null;
        }
        if (this.myTabbedPane != null) {
            detailPanel.remove((Component)this.myTabbedPane);
        }
        if (this.myCpuTraceControlsUi != null) {
            toolbar.remove(this.myCpuTraceControlsUi);
            this.myCpuTraceControlsUi = null;
        }
        this.myChoreographer.unregister(this.myFlameChart);
        this.myChoreographer.unregister(this.myExecutionChart);
    }

    private void resetDetailedComponents() {
        this.myBottomupJPanel.removeAll();
        this.myTopdownJpanel.removeAll();
        this.myExecutionChart.setHTree(null);
        this.myFlameChart.setHTree(null);
    }

    @Override
    @NotNull
    protected BaseSegment createOverviewSegment(@NotNull Range timeCurrentRangeUs, @NotNull SeriesDataStore dataStore, @NotNull EventDispatcher<ProfilerEventListener> eventDispatcher) {
        if (timeCurrentRangeUs == null) {
            CpuProfilerUiManager.$$$reportNull$$$0(16);
        }
        if (dataStore == null) {
            CpuProfilerUiManager.$$$reportNull$$$0(17);
        }
        if (eventDispatcher == null) {
            CpuProfilerUiManager.$$$reportNull$$$0(18);
        }
        CpuUsageSegment cpuUsageSegment = new CpuUsageSegment(timeCurrentRangeUs, dataStore, eventDispatcher);
        if (cpuUsageSegment == null) {
            CpuProfilerUiManager.$$$reportNull$$$0(19);
        }
        return cpuUsageSegment;
    }

    @Override
    public void onSelected(@NotNull List<ThreadStateDataSeries> selectedThreads) {
        if (selectedThreads == null) {
            CpuProfilerUiManager.$$$reportNull$$$0(20);
        }
        if (selectedThreads.size() != 1) {
            return;
        }
        ((ProfilerEventListener)this.myEventDispatcher.getMulticaster()).profilerExpanded(BaseProfilerUiManager.ProfilerType.CPU);
        this.resetDetailedComponents();
        ThreadStateDataSeries selectedThread = selectedThreads.get(0);
        int threadId = selectedThread.getProcessId();
        AppTrace trace = TraceDataStore.getInstance().getLastThreadsActivity(this.myProject.getName());
        if (trace == null) {
            return;
        }
        SparseArray<HNode<Method>> availableThreads = trace.getThreadsGraph();
        if (availableThreads.get(threadId) == null) {
            return;
        }
        SparseArray<JComponent> topDownTrees = trace.getTopDownTrees();
        this.myTopdownJpanel.add((Component)topDownTrees.get(threadId), "Center");
        SparseArray<JComponent> bottomUpTrees = trace.getBottomUpTrees();
        this.myBottomupJPanel.add((Component)bottomUpTrees.get(threadId), "Center");
        HNode executionTree = (HNode)availableThreads.get(threadId);
        this.myExecutionChart.setHTree(executionTree);
        if (AppTrace.Source.ART == trace.getSource()) {
            this.myExecutionChart.setHRenderer((HRenderer)new NativeMethodHRenderer());
        } else {
            this.myExecutionChart.setHRenderer((HRenderer)new JavaMethodHRenderer());
        }
        SparseArray<HNode<MethodUsage>> usageTrees = trace.getTopdownStats();
        HNode usageTree = (HNode)usageTrees.get(threadId);
        this.myFlameChart.setHTree(usageTree);
        this.myFlameChartRange.set((double)usageTree.getStart(), (double)usageTree.getEnd());
        this.myFlameChart.setXRange((Range)this.myFlameChartRange);
        if (AppTrace.Source.ART == trace.getSource()) {
            this.myFlameChart.setHRenderer((HRenderer)new NativeMethodUsageHRenderer());
        } else {
            this.myFlameChart.setHRenderer((HRenderer)new JavaMethodUsageHRenderer());
        }
        this.myTimeSelectionRangeUs.set((double)executionTree.getStart(), (double)executionTree.getEnd());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timeCurrentRangeUs";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timeSelectionRangeUs";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "choreographer";
                break;
            }
            case 3: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStore";
                break;
            }
            case 4: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventDispatcher";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedDeviceProfilerService";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deviceContext";
                break;
            }
            case 7: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/monitor/ui/cpu/view/CpuProfilerUiManager";
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolbar";
                break;
            }
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "overviewPanel";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "detailPanel";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedThreads";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/monitor/ui/cpu/view/CpuProfilerUiManager";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createPollers";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createOverviewSegment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: 
            case 19: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setupExtendedOverviewUi";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createTracingButton";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setupDetailedViewUi";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "resetProfiler";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createOverviewSegment";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "onSelected";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

