/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.monitor.ui.cpu.view;

import com.android.tools.idea.monitor.tool.TraceRequestHandler;
import com.intellij.openapi.ui.ComboBox;
import icons.AndroidIcons;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;

public class CPUTraceController
extends JPanel
implements ItemListener,
ActionListener {
    private static final String PROFILER_ART = "ART";
    private static final String PROFILER_SIMPLE_PERF = "Simpleperf";
    private static final String MODE_SAMPLING = "Sampling";
    private static final String MODE_INSTRUMENTING = "Instrumenting";
    private static final String START_TRACING = "Start tracing";
    private static final String STOP_TRACING = "Stop tracing";
    private JButton myActionButtion;
    private JComboBox<String> myProfilers;
    private JComboBox<String> myProfilingModes;
    private final TraceRequestHandler myTraceRequestHandler;
    private boolean myTracing;

    public CPUTraceController(TraceRequestHandler traceRequestHandler) {
        this.setLayout(new BoxLayout(this, 0));
        this.myTraceRequestHandler = traceRequestHandler;
        this.myActionButtion = new JButton();
        this.myActionButtion.setVisible(true);
        this.myActionButtion.setIcon(AndroidIcons.Ddms.StartMethodProfiling);
        this.myActionButtion.setText(START_TRACING);
        this.myActionButtion.addActionListener(this);
        this.add(this.myActionButtion);
        this.myProfilers = new ComboBox();
        this.myProfilers.addItem(PROFILER_ART);
        this.myProfilers.addItem(PROFILER_SIMPLE_PERF);
        this.myProfilers.addItemListener(this);
        this.add(this.myProfilers);
        this.myProfilingModes = new ComboBox();
        this.myProfilingModes.addItem(MODE_SAMPLING);
        this.myProfilingModes.addItem(MODE_INSTRUMENTING);
        this.add(this.myProfilingModes);
        this.myTracing = false;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (this.myProfilers.getSelectedItem().equals(PROFILER_SIMPLE_PERF)) {
            this.myProfilingModes.setSelectedItem(MODE_SAMPLING);
            this.myProfilingModes.setEnabled(false);
        } else {
            this.myProfilingModes.setEnabled(true);
        }
    }

    private void startTracing() {
        TraceRequestHandler.Profiler profiler = this.myProfilers.getSelectedItem().equals(PROFILER_ART) ? TraceRequestHandler.Profiler.ART : TraceRequestHandler.Profiler.SIMPLEPERF;
        TraceRequestHandler.Mode mode = this.myProfilingModes.getSelectedItem().equals(MODE_SAMPLING) ? TraceRequestHandler.Mode.SAMPLING : TraceRequestHandler.Mode.INSTRUMENTING;
        this.myTraceRequestHandler.startTracing(profiler, mode);
        this.myActionButtion.setText(STOP_TRACING);
        this.myTracing = true;
    }

    private void stopTracing() {
        this.myActionButtion.setText(START_TRACING);
        this.myTracing = false;
        TraceRequestHandler.Profiler profiler = this.myProfilers.getSelectedItem().equals(PROFILER_ART) ? TraceRequestHandler.Profiler.ART : TraceRequestHandler.Profiler.SIMPLEPERF;
        this.myTraceRequestHandler.stopTracing(profiler);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (this.myTracing) {
            this.stopTracing();
        } else {
            this.startTracing();
        }
    }
}

