/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.monitor.ui.cpu.model;

import com.android.tools.adtui.chart.hchart.Method;
import com.android.tools.adtui.model.HNode;
import com.android.tools.idea.monitor.ui.cpu.model.AppTrace;
import com.android.tools.profiler.proto.SimpleperfReport;
import com.android.utils.SparseArray;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class TraceSimplePerf
extends AppTrace {
    private final File myTraceFile;
    SparseArray<HNode<Method>> forest;
    private static final String KERNEL_SYMBOL = "[kernel.kallsyms]";

    public TraceSimplePerf(File traceFile) {
        this.myTraceFile = traceFile;
        this.forest = new SparseArray();
    }

    @Override
    public AppTrace.Source getSource() {
        return AppTrace.Source.SIMPLEPERF;
    }

    @Override
    public String getSeparator() {
        return "::";
    }

    @Override
    public void parse() throws IOException {
        int size;
        SparseArray maxSampleTimes = new SparseArray();
        FileInputStream in = new FileInputStream(this.myTraceFile);
        while ((size = this.readNextIntFromStream(in)) != 0) {
            byte[] buf = new byte[size];
            int read = in.read(buf);
            if (read != size) {
                throw new IOException("End of stream reached unexpectingly");
            }
            SimpleperfReport.Record record = SimpleperfReport.Record.parseFrom((byte[])buf);
            this.addRecordToModel(record, (SparseArray<Long>)maxSampleTimes);
        }
        this.markCallEnds((SparseArray<Long>)maxSampleTimes);
        in.close();
    }

    private int readNextIntFromStream(FileInputStream in) throws IOException {
        byte[] rawBuffer = new byte[4];
        int read = in.read(rawBuffer);
        if (read != 4) {
            throw new IOException("Stream is unaligned (unable to read 4 bytes).");
        }
        ByteBuffer buffer = ByteBuffer.wrap(rawBuffer);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        return buffer.getInt();
    }

    private void addRecordToModel(SimpleperfReport.Record record, SparseArray<Long> maxSampleTime) {
        SimpleperfReport.Sample.CallChainEntry invocation;
        HNode currentNode;
        SimpleperfReport.Sample sample = record.getSample();
        if (sample == null) {
            return;
        }
        if (sample.getCallchainCount() == 0) {
            return;
        }
        int threadId = sample.getThreadId();
        long sampleTime = sample.getTime();
        maxSampleTime.put(threadId, (Object)sampleTime);
        HNode tree = (HNode)this.forest.get(sample.getThreadId());
        if (tree == null) {
            tree = new HNode();
            tree.setStart(sampleTime);
            Method rootMethod = new Method();
            rootMethod.setName("root()");
            rootMethod.setNamespace("root.package.foo.bar");
            tree.setData((Object)rootMethod);
            this.forest.put(sample.getThreadId(), (Object)tree);
        }
        int depth = sample.getCallchainCount() - 1;
        HNode previousNode = tree;
        for (currentNode = previousNode.getLastChild(); currentNode != null && depth >= 0 && this.isSameMethod((Method)currentNode.getData(), sample.getCallchain(depth)); --depth, currentNode = currentNode.getLastChild()) {
            previousNode = currentNode;
        }
        this.markCallEnds(currentNode, sampleTime);
        while (depth >= 0 && !KERNEL_SYMBOL.equals((invocation = sample.getCallchain(depth)).getFile())) {
            Method m = new Method();
            this.parseInvocation(invocation, m);
            m.setFilename(invocation.getFile());
            HNode newNode = new HNode();
            newNode.setStart(sampleTime);
            newNode.setData((Object)m);
            newNode.setDepth(sample.getCallchainCount() - depth - 1);
            previousNode.addHNode(newNode);
            previousNode = newNode;
            --depth;
        }
    }

    void markCallEnds(HNode node, long endTime) {
        while (node != null) {
            node.setEnd(endTime);
            node = node.getLastChild();
        }
    }

    private boolean isSameMethod(Method method, SimpleperfReport.Sample.CallChainEntry invocation) {
        Method parseInvocation = new Method();
        this.parseInvocation(invocation, parseInvocation);
        return method.getName().equals(parseInvocation.getName()) && method.getNameSpace().equals(parseInvocation.getNameSpace());
    }

    private void parseInvocation(SimpleperfReport.Sample.CallChainEntry invocation, Method m) {
        m.setNamespace("");
        String symbol = invocation.getSymbol();
        if (symbol.startsWith("*")) {
            String file = invocation.getFile();
            if (file.contains("/")) {
                m.setName(file.substring(file.lastIndexOf("/") + 1));
            } else {
                m.setName(invocation.getFile());
            }
            m.setName("[" + m.getName() + "]");
        } else if (symbol.contains("(")) {
            if ((symbol = symbol.substring(0, symbol.indexOf("("))).contains("::")) {
                m.setNamespace(symbol.substring(0, symbol.lastIndexOf("::")));
                m.setName(symbol.substring(symbol.lastIndexOf("::") + 2));
            } else {
                m.setName(symbol);
            }
        } else {
            m.setName(invocation.getSymbol());
        }
    }

    private void markCallEnds(SparseArray<Long> maxSampleTimes) {
        for (int i = 0; i < this.forest.size(); ++i) {
            int threadId = this.forest.keyAt(i);
            HNode node = (HNode)this.forest.get(threadId);
            long sampleTime = (Long)maxSampleTimes.get(threadId);
            this.markCallEnds(node, sampleTime);
        }
    }

    @Override
    public SparseArray<HNode<Method>> getThreadsGraph() {
        return this.forest;
    }
}

