/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.monitor.ui;

import com.android.tools.adtui.AccordionLayout;
import com.android.tools.adtui.Animatable;
import com.android.tools.adtui.Choreographer;
import com.android.tools.adtui.model.Range;
import com.android.tools.datastore.Poller;
import com.android.tools.datastore.SeriesDataStore;
import com.android.tools.idea.monitor.tool.ProfilerEventListener;
import com.android.tools.idea.monitor.ui.BaseSegment;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.ui.JBColor;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseProfilerUiManager {
    protected static final int DEFAULT_MONITOR_MIN_HEIGHT = JBUI.scale((int)0);
    protected static final int DEFAULT_MONITOR_MAX_HEIGHT = JBUI.scale((int)Short.MAX_VALUE);
    protected static final int DEFAULT_MONITOR_PREFERRED_HEIGHT = JBUI.scale((int)200);
    protected BaseSegment myOverviewSegment;
    @NotNull
    protected final Range myTimeCurrentRangeUs;
    @NotNull
    protected final Choreographer myChoreographer;
    @NotNull
    protected final SeriesDataStore myDataStore;
    @NotNull
    protected final EventDispatcher<ProfilerEventListener> myEventDispatcher;
    @Nullable
    protected Set<Poller> myPollerSet;

    public BaseProfilerUiManager(@NotNull Range timeCurrentRangeUs, @NotNull Choreographer choreographer, @NotNull SeriesDataStore dataStore, @NotNull EventDispatcher<ProfilerEventListener> eventDispatcher) {
        if (timeCurrentRangeUs == null) {
            BaseProfilerUiManager.$$$reportNull$$$0(0);
        }
        if (choreographer == null) {
            BaseProfilerUiManager.$$$reportNull$$$0(1);
        }
        if (dataStore == null) {
            BaseProfilerUiManager.$$$reportNull$$$0(2);
        }
        if (eventDispatcher == null) {
            BaseProfilerUiManager.$$$reportNull$$$0(3);
        }
        this.myTimeCurrentRangeUs = timeCurrentRangeUs;
        this.myChoreographer = choreographer;
        this.myDataStore = dataStore;
        this.myEventDispatcher = eventDispatcher;
    }

    @Nullable
    public abstract Set<Poller> createPollers(int var1);

    public void startMonitoring(int pid) {
        assert (this.myPollerSet == null);
        this.myPollerSet = this.createPollers(pid);
        if (this.myPollerSet != null) {
            for (Poller poller : this.myPollerSet) {
                ApplicationManager.getApplication().executeOnPooledThread((Runnable)poller);
            }
        }
    }

    public void stopMonitoring() {
        if (this.myPollerSet != null) {
            for (Poller poller : this.myPollerSet) {
                poller.stop();
            }
            this.myPollerSet = null;
        }
    }

    public void setupOverviewUi(@NotNull JPanel toolbar, @NotNull JPanel overviewPanel) {
        if (toolbar == null) {
            BaseProfilerUiManager.$$$reportNull$$$0(4);
        }
        if (overviewPanel == null) {
            BaseProfilerUiManager.$$$reportNull$$$0(5);
        }
        this.myOverviewSegment = this.createOverviewSegment(this.myTimeCurrentRangeUs, this.myDataStore, this.myEventDispatcher);
        this.setupAndRegisterSegment(this.myOverviewSegment, DEFAULT_MONITOR_MIN_HEIGHT, DEFAULT_MONITOR_PREFERRED_HEIGHT, DEFAULT_MONITOR_MAX_HEIGHT);
        overviewPanel.add(this.myOverviewSegment);
    }

    public void setupExtendedOverviewUi(@NotNull JPanel toolbar, @NotNull JPanel overviewPanel) {
        if (toolbar == null) {
            BaseProfilerUiManager.$$$reportNull$$$0(6);
        }
        if (overviewPanel == null) {
            BaseProfilerUiManager.$$$reportNull$$$0(7);
        }
        if (this.myOverviewSegment == null) {
            return;
        }
        BaseProfilerUiManager.setSegmentState(overviewPanel, this.myOverviewSegment, AccordionLayout.AccordionState.MAXIMIZE);
        this.myOverviewSegment.toggleView(true);
    }

    public void setupDetailedViewUi(@NotNull JPanel toolbar, @NotNull JPanel detailPanel) {
        if (toolbar == null) {
            BaseProfilerUiManager.$$$reportNull$$$0(8);
        }
        if (detailPanel == null) {
            BaseProfilerUiManager.$$$reportNull$$$0(9);
        }
    }

    public boolean isDetailedViewVerticallySplit() {
        return true;
    }

    public void resetProfiler(@NotNull JPanel toolbar, @NotNull JPanel overviewPanel, @NotNull JPanel detailPanel) {
        if (toolbar == null) {
            BaseProfilerUiManager.$$$reportNull$$$0(10);
        }
        if (overviewPanel == null) {
            BaseProfilerUiManager.$$$reportNull$$$0(11);
        }
        if (detailPanel == null) {
            BaseProfilerUiManager.$$$reportNull$$$0(12);
        }
        if (this.myOverviewSegment == null) {
            return;
        }
        BaseProfilerUiManager.setSegmentState(overviewPanel, this.myOverviewSegment, AccordionLayout.AccordionState.PREFERRED);
        this.myOverviewSegment.toggleView(false);
    }

    @NotNull
    protected abstract BaseSegment createOverviewSegment(@NotNull Range var1, @NotNull SeriesDataStore var2, @NotNull EventDispatcher<ProfilerEventListener> var3);

    protected void setupAndRegisterSegment(@NotNull BaseSegment segment, int minHeight, int preferredHeight, int maxHeight) {
        if (segment == null) {
            BaseProfilerUiManager.$$$reportNull$$$0(13);
        }
        segment.setMinimumSize(new Dimension(0, minHeight));
        segment.setPreferredSize(new Dimension(0, preferredHeight));
        segment.setMaximumSize(new Dimension(0, maxHeight));
        segment.setBorder(BorderFactory.createLineBorder((Color)JBColor.GRAY));
        ArrayList<Animatable> segmentAnimatables = new ArrayList<Animatable>();
        segment.createComponentsList(segmentAnimatables);
        this.myChoreographer.register(segmentAnimatables);
        segment.initializeComponents();
    }

    protected static void setSegmentState(@NotNull JPanel accordionPanel, @NotNull BaseSegment segment, @NotNull AccordionLayout.AccordionState state) {
        AccordionLayout layout;
        if (accordionPanel == null) {
            BaseProfilerUiManager.$$$reportNull$$$0(14);
        }
        if (segment == null) {
            BaseProfilerUiManager.$$$reportNull$$$0(15);
        }
        if (state == null) {
            BaseProfilerUiManager.$$$reportNull$$$0(16);
        }
        if ((layout = (AccordionLayout)accordionPanel.getLayout()) != null) {
            layout.setState((Component)segment, state);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timeCurrentRangeUs";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "choreographer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStore";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventDispatcher";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolbar";
                break;
            }
            case 5: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "overviewPanel";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "detailPanel";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "segment";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accordionPanel";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/monitor/ui/BaseProfilerUiManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "setupOverviewUi";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "setupExtendedOverviewUi";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "setupDetailedViewUi";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "resetProfiler";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "setupAndRegisterSegment";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "setSegmentState";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum ProfilerType {
        EVENT,
        NETWORK,
        MEMORY,
        CPU,
        GPU,
        ENERGY;

    }
}

