/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.monitor.ui;

import com.android.tools.adtui.Animatable;
import com.android.tools.adtui.AnimatedRange;
import com.android.tools.adtui.AxisComponent;
import com.android.tools.adtui.GridComponent;
import com.android.tools.adtui.LegendComponent;
import com.android.tools.adtui.LegendRenderData;
import com.android.tools.adtui.chart.linechart.LineChart;
import com.android.tools.adtui.chart.linechart.LineConfig;
import com.android.tools.adtui.common.formatter.BaseAxisFormatter;
import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangedContinuousSeries;
import com.android.tools.datastore.DataStoreSeries;
import com.android.tools.datastore.SeriesDataStore;
import com.android.tools.datastore.SeriesDataType;
import com.android.tools.idea.monitor.tool.ProfilerEventListener;
import com.android.tools.idea.monitor.ui.BaseProfilerUiManager;
import com.android.tools.idea.monitor.ui.BaseSegment;
import com.intellij.ui.components.JBLayeredPane;
import com.intellij.util.EventDispatcher;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.Timer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseLineChartSegment
extends BaseSegment {
    private static final int MULTI_CLICK_INTERVAL_MS = 300;
    private static final int MOUSE_DRAG_DISTANCE_THRESHOLD_PX = 5;
    private static final int MULTI_CLICK_THRESHOLD = 2;
    @NotNull
    protected AnimatedRange mLeftAxisRange;
    @NotNull
    protected AnimatedRange mRightAxisRange;
    private AxisComponent mLeftAxis;
    private AxisComponent mRightAxis;
    @NotNull
    private final BaseAxisFormatter mLeftAxisFormatterSimple;
    @NotNull
    private final BaseAxisFormatter mLeftAxisFormatter;
    @Nullable
    private final BaseAxisFormatter mRightAxisFormatter;
    private GridComponent mGrid;
    private LineChart mLineChart;
    protected LegendComponent mLegendComponent;
    @NotNull
    protected SeriesDataStore mSeriesDataStore;
    private final ArrayDeque<MouseEvent> mDelayedEvents;
    private boolean mMultiClicked;
    private Point mMousePressedPosition;

    public BaseLineChartSegment(@NotNull String name, @NotNull Range timeCurrentRangeUs, @NotNull SeriesDataStore dataStore, @NotNull BaseAxisFormatter leftAxisFormatterSimple, @NotNull BaseAxisFormatter leftAxisFormatter, @Nullable BaseAxisFormatter rightAxisFormatter, @Nullable AnimatedRange leftAxisRange, @Nullable AnimatedRange rightAxisRange, @NotNull EventDispatcher<ProfilerEventListener> dispatcher) {
        if (name == null) {
            BaseLineChartSegment.$$$reportNull$$$0(0);
        }
        if (timeCurrentRangeUs == null) {
            BaseLineChartSegment.$$$reportNull$$$0(1);
        }
        if (dataStore == null) {
            BaseLineChartSegment.$$$reportNull$$$0(2);
        }
        if (leftAxisFormatterSimple == null) {
            BaseLineChartSegment.$$$reportNull$$$0(3);
        }
        if (leftAxisFormatter == null) {
            BaseLineChartSegment.$$$reportNull$$$0(4);
        }
        if (dispatcher == null) {
            BaseLineChartSegment.$$$reportNull$$$0(5);
        }
        super(name, timeCurrentRangeUs, dispatcher);
        this.mLeftAxisFormatterSimple = leftAxisFormatterSimple;
        this.mLeftAxisFormatter = leftAxisFormatter;
        this.mRightAxisFormatter = rightAxisFormatter;
        this.mLeftAxisRange = leftAxisRange != null ? leftAxisRange : new AnimatedRange();
        this.mRightAxisRange = rightAxisRange != null ? rightAxisRange : new AnimatedRange();
        this.mSeriesDataStore = dataStore;
        this.mDelayedEvents = new ArrayDeque();
        this.initializeListeners();
    }

    public BaseLineChartSegment(@NotNull String name, @NotNull Range timeCurrentRangeUs, @NotNull SeriesDataStore dataStore, @NotNull BaseAxisFormatter leftAxisFormatterSimple, @NotNull BaseAxisFormatter leftAxisFormatter, @Nullable BaseAxisFormatter rightAxisFormatter, @NotNull EventDispatcher<ProfilerEventListener> dispatcher) {
        if (name == null) {
            BaseLineChartSegment.$$$reportNull$$$0(6);
        }
        if (timeCurrentRangeUs == null) {
            BaseLineChartSegment.$$$reportNull$$$0(7);
        }
        if (dataStore == null) {
            BaseLineChartSegment.$$$reportNull$$$0(8);
        }
        if (leftAxisFormatterSimple == null) {
            BaseLineChartSegment.$$$reportNull$$$0(9);
        }
        if (leftAxisFormatter == null) {
            BaseLineChartSegment.$$$reportNull$$$0(10);
        }
        if (dispatcher == null) {
            BaseLineChartSegment.$$$reportNull$$$0(11);
        }
        this(name, timeCurrentRangeUs, dataStore, leftAxisFormatterSimple, leftAxisFormatter, rightAxisFormatter, null, null, dispatcher);
    }

    public abstract BaseProfilerUiManager.ProfilerType getProfilerType();

    @Override
    public void createComponentsList(@NotNull List<Animatable> animatables) {
        if (animatables == null) {
            BaseLineChartSegment.$$$reportNull$$$0(12);
        }
        AxisComponent.Builder builder = new AxisComponent.Builder((Range)this.mLeftAxisRange, this.mLeftAxisFormatterSimple, AxisComponent.AxisOrientation.LEFT).showMax(true).clampToMajorTicks(true);
        this.mLeftAxis = builder.build();
        if (this.mRightAxisFormatter != null) {
            builder = new AxisComponent.Builder((Range)this.mRightAxisRange, this.mRightAxisFormatter, AxisComponent.AxisOrientation.RIGHT).showMax(true).setParentAxis(this.mLeftAxis);
            this.mRightAxis = builder.build();
            this.mRightAxis.setParentAxis(this.mLeftAxis);
            this.mRightAxis.setVisible(false);
        }
        this.mLineChart = new LineChart();
        this.mGrid = new GridComponent();
        this.mGrid.addAxis(this.mLeftAxis);
        this.mGrid.setVisible(false);
        this.mLegendComponent = new LegendComponent(LegendComponent.Orientation.HORIZONTAL, 100);
        animatables.add((Animatable)this.mLineChart);
        animatables.add((Animatable)this.mLeftAxis);
        if (this.mRightAxis != null) {
            animatables.add((Animatable)this.mRightAxis);
        }
        animatables.add((Animatable)this.mLeftAxisRange);
        animatables.add((Animatable)this.mRightAxisRange);
        animatables.add((Animatable)this.mLegendComponent);
        animatables.add((Animatable)this.mGrid);
    }

    @Override
    protected void setLeftContent(@NotNull JPanel panel) {
        if (panel == null) {
            BaseLineChartSegment.$$$reportNull$$$0(13);
        }
        panel.add((Component)this.mLeftAxis, "Center");
    }

    @Override
    protected void setTopCenterContent(@NotNull JPanel panel) {
        if (panel == null) {
            BaseLineChartSegment.$$$reportNull$$$0(14);
        }
        panel.add((Component)this.mLegendComponent, "East");
    }

    @Override
    protected void setCenterContent(@NotNull JPanel panel) {
        if (panel == null) {
            BaseLineChartSegment.$$$reportNull$$$0(15);
        }
        JBLayeredPane layeredPane = new JBLayeredPane();
        layeredPane.add((Component)this.mLineChart);
        layeredPane.add((Component)this.mGrid);
        layeredPane.addComponentListener((ComponentListener)new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                JLayeredPane host = (JLayeredPane)e.getComponent();
                if (host != null) {
                    Dimension dim = host.getSize();
                    for (Component c : host.getComponents()) {
                        c.setBounds(0, 0, dim.width, dim.height);
                    }
                }
            }
        });
        panel.add((Component)layeredPane, "Center");
    }

    @Override
    protected void setRightContent(@NotNull JPanel panel) {
        if (panel == null) {
            BaseLineChartSegment.$$$reportNull$$$0(16);
        }
        if (this.mRightAxisFormatter != null) {
            panel.add((Component)this.mRightAxis, "Center");
            this.setRightSpacerVisible(true);
        }
    }

    private void initializeListeners() {
        this.addMouseListener(new MouseListener(){

            @Override
            public void mousePressed(MouseEvent e) {
                BaseLineChartSegment.this.mMousePressedPosition = e.getPoint();
                if (e.getClickCount() >= 2 && !BaseLineChartSegment.this.mDelayedEvents.isEmpty()) {
                    BaseLineChartSegment.this.mMultiClicked = true;
                    BaseLineChartSegment.this.handleMultiClickEvent();
                } else {
                    BaseLineChartSegment.this.mMultiClicked = false;
                    BaseLineChartSegment.this.mDelayedEvents.add(e);
                    Timer dispatchTimer = new Timer(300, e1 -> BaseLineChartSegment.this.dispatchOrAbsorbEvents());
                    dispatchTimer.setRepeats(false);
                    dispatchTimer.start();
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                BaseLineChartSegment.this.dispatchOrDelayEvent(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                BaseLineChartSegment.this.dispatchOrDelayEvent(e);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                BaseLineChartSegment.this.dispatchOrDelayEvent(e);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                BaseLineChartSegment.this.dispatchOrDelayEvent(e);
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                double distance;
                BaseLineChartSegment.this.dispatchOrDelayEvent(e);
                if (!BaseLineChartSegment.this.mDelayedEvents.isEmpty() && (distance = Point.distance(BaseLineChartSegment.this.mMousePressedPosition.getX(), BaseLineChartSegment.this.mMousePressedPosition.getY(), e.getPoint().getX(), e.getPoint().getY())) > 5.0) {
                    BaseLineChartSegment.this.dispatchOrAbsorbEvents();
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                BaseLineChartSegment.this.dispatchOrDelayEvent(e);
            }
        });
    }

    protected void handleMultiClickEvent() {
        ((ProfilerEventListener)this.mEventDispatcher.getMulticaster()).profilerExpanded(this.getProfilerType());
    }

    private void dispatchOrDelayEvent(MouseEvent e) {
        if (this.mDelayedEvents.isEmpty()) {
            this.getParent().dispatchEvent(e);
        } else {
            this.mDelayedEvents.addLast(e);
        }
    }

    private void dispatchOrAbsorbEvents() {
        if (this.mMultiClicked) {
            this.mDelayedEvents.clear();
        } else {
            while (!this.mDelayedEvents.isEmpty()) {
                this.getParent().dispatchEvent(this.mDelayedEvents.remove());
            }
        }
    }

    @Override
    public void toggleView(boolean isExpanded) {
        super.toggleView(isExpanded);
        this.mGrid.setVisible(isExpanded);
        this.mLeftAxis.setAxisFormatter(isExpanded ? this.mLeftAxisFormatter : this.mLeftAxisFormatterSimple);
        this.mLineChart.clearConfigs();
        this.updateChartLines(isExpanded);
        this.mLegendComponent.setLegendData(this.getLegendRenderDataList());
    }

    protected abstract void updateChartLines(boolean var1);

    private List<LegendRenderData> getLegendRenderDataList() {
        ArrayList<LegendRenderData> legendRenderDataList = new ArrayList<LegendRenderData>();
        for (RangedContinuousSeries series : this.mLineChart.getRangedContinuousSeries()) {
            LineConfig lineConfig = this.mLineChart.getLineConfig(series);
            LegendRenderData.IconType iconType = lineConfig.getLegendIconType();
            if (iconType == null) {
                iconType = lineConfig.isFilled() ? LegendRenderData.IconType.BOX : LegendRenderData.IconType.LINE;
            }
            legendRenderDataList.add(new LegendRenderData(iconType, lineConfig.getColor(), series.getLabel()));
        }
        return legendRenderDataList;
    }

    protected void addLeftAxisLine(SeriesDataType type, String label, LineConfig lineConfig) {
        this.addLeftAxisLine(type, label, lineConfig, (DataSeries)new DataStoreSeries(this.mSeriesDataStore, type));
    }

    protected void addLeftAxisLine(SeriesDataType type, String label, LineConfig lineConfig, DataSeries series) {
        this.mLineChart.addLine(new RangedContinuousSeries(label, this.myTimeCurrentRangeUs, (Range)this.mLeftAxisRange, series), lineConfig);
    }

    protected void addRightAxisLine(SeriesDataType type, String label, LineConfig lineConfig) {
        this.addRightAxisLine(type, label, lineConfig, (DataSeries)new DataStoreSeries(this.mSeriesDataStore, type));
    }

    protected void addRightAxisLine(SeriesDataType type, String label, LineConfig lineConfig, DataSeries series) {
        if (this.mRightAxisFormatter == null) {
            throw new IllegalComponentStateException("Right axis formatter is not defined, cannot add right axis line.");
        }
        this.mLineChart.addLine(new RangedContinuousSeries(label, this.myTimeCurrentRangeUs, (Range)this.mRightAxisRange, series), lineConfig);
        this.mRightAxis.setVisible(true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timeCurrentRangeUs";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStore";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftAxisFormatterSimple";
                break;
            }
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftAxisFormatter";
                break;
            }
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dispatcher";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "animatables";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/monitor/ui/BaseLineChartSegment";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "createComponentsList";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "setLeftContent";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "setTopCenterContent";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "setCenterContent";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "setRightContent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

