/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.monitor.tool;

import com.android.tools.datastore.profilerclient.DeviceProfilerService;
import com.android.tools.idea.ddms.DeviceContext;
import com.android.tools.idea.monitor.ui.cpu.model.AppTrace;
import com.android.tools.idea.monitor.ui.cpu.model.TraceArt;
import com.android.tools.idea.monitor.ui.cpu.model.TraceDataStore;
import com.android.tools.idea.monitor.ui.cpu.model.TraceSimplePerf;
import com.android.tools.profiler.proto.CpuProfiler;
import com.android.tools.profiler.proto.CpuServiceGrpc;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TraceRequestHandler {
    private static final Logger LOG = Logger.getInstance(TraceRequestHandler.class);
    private static final String CAPTURES_DIRECTORY_NAME = "art_trace";
    @Nullable
    private final DeviceProfilerService mySelectedDeviceProfilerService;
    @NotNull
    private final DeviceContext myDeviceContext;
    @NotNull
    private final Project myProject;

    public TraceRequestHandler(@NotNull DeviceProfilerService selectedDeviceProfilerService, @NotNull DeviceContext deviceContext, @NotNull Project project) {
        if (selectedDeviceProfilerService == null) {
            TraceRequestHandler.$$$reportNull$$$0(0);
        }
        if (deviceContext == null) {
            TraceRequestHandler.$$$reportNull$$$0(1);
        }
        if (project == null) {
            TraceRequestHandler.$$$reportNull$$$0(2);
        }
        this.mySelectedDeviceProfilerService = selectedDeviceProfilerService;
        this.myDeviceContext = deviceContext;
        this.myProject = project;
    }

    public void startTracing(Profiler profiler, Mode mode) {
        CpuServiceGrpc.CpuServiceBlockingStub cpuService = this.mySelectedDeviceProfilerService.getCpuService();
        String appPackageName = this.myDeviceContext.getSelectedClient().getClientData().getPackageName();
        CpuProfiler.CpuProfilingAppStartRequest.Builder requestBuilder = CpuProfiler.CpuProfilingAppStartRequest.newBuilder().setAppPkgName(appPackageName);
        if (profiler == Profiler.ART) {
            requestBuilder.setProfiler(CpuProfiler.CpuProfilingAppStartRequest.Profiler.ART);
        } else {
            requestBuilder.setProfiler(CpuProfiler.CpuProfilingAppStartRequest.Profiler.SIMPLE_PERF);
        }
        if (mode == Mode.SAMPLING) {
            requestBuilder.setMode(CpuProfiler.CpuProfilingAppStartRequest.Mode.SAMPLED);
        } else {
            requestBuilder.setMode(CpuProfiler.CpuProfilingAppStartRequest.Mode.INSTRUMENTED);
        }
        CpuProfiler.CpuProfilingAppStartResponse response = cpuService.startProfilingApp(requestBuilder.build());
        if (!response.getStatus().equals((Object)CpuProfiler.CpuProfilingAppStartResponse.Status.SUCCESS)) {
            LOG.error("Unable to start tracing:" + response.getStatus());
            LOG.error(response.getErrorMessage());
            return;
        }
    }

    public void stopTracing(Profiler profiler) {
        CpuServiceGrpc.CpuServiceBlockingStub cpuService = this.mySelectedDeviceProfilerService.getCpuService();
        String appPackageName = this.myDeviceContext.getSelectedClient().getClientData().getPackageName();
        CpuProfiler.CpuProfilingAppStopRequest.Builder requestBuilder = CpuProfiler.CpuProfilingAppStopRequest.newBuilder().setAppPkgName(appPackageName);
        if (profiler == Profiler.ART) {
            requestBuilder.setProfiler(CpuProfiler.CpuProfilingAppStopRequest.Profiler.ART);
        } else {
            requestBuilder.setProfiler(CpuProfiler.CpuProfilingAppStopRequest.Profiler.SIMPLE_PERF);
        }
        final CpuProfiler.CpuProfilingAppStopResponse response = cpuService.stopProfilingApp(requestBuilder.build());
        if (!response.getStatus().equals((Object)CpuProfiler.CpuProfilingAppStopResponse.Status.SUCCESS)) {
            LOG.error("Unable to stop tracing:" + response.getStatus());
            LOG.error(response.getErrorMessage());
            return;
        }
        final File[] dst = new File[]{null};
        try {
            ApplicationManager.getApplication().runWriteAction((ThrowableComputable)new ThrowableComputable<Object, IOException>(){

                public Object compute() throws IOException {
                    dst[0] = TraceRequestHandler.this.createLocalFile(TraceRequestHandler.this.createATraceFileName());
                    Files.write(dst[0].toPath(), response.getTrace().toByteArray(), new OpenOption[0]);
                    return null;
                }
            });
            AppTrace trace = profiler == Profiler.ART ? new TraceArt(dst[0]) : new TraceSimplePerf(dst[0]);
            trace.parse();
            TraceDataStore.getInstance().addTrace(this.myProject.getName(), trace);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private File createLocalFile(String captureFileName) throws IOException {
        VirtualFile dir = this.createCapturesDirectory();
        File captureFile = new File(dir.createChildData(null, captureFileName).getPath());
        captureFile.deleteOnExit();
        return captureFile;
    }

    private VirtualFile createCapturesDirectory() throws IOException {
        assert (this.myProject.getBasePath() != null);
        VirtualFile projectDir = LocalFileSystem.getInstance().findFileByPath(this.myProject.getBasePath());
        if (projectDir != null) {
            VirtualFile dir = projectDir.findChild(CAPTURES_DIRECTORY_NAME);
            if (dir == null) {
                dir = projectDir.createChildDirectory(null, CAPTURES_DIRECTORY_NAME);
            }
            return dir;
        }
        throw new IOException("Unable to create the captures directory: Project directory not found.");
    }

    private String createATraceFileName() {
        return String.format("t%d_%d.cpu_trace", Thread.currentThread().getId(), System.nanoTime());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "selectedDeviceProfilerService";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "deviceContext";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
        }
        objectArray[1] = "com/android/tools/idea/monitor/tool/TraceRequestHandler";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum Mode {
        SAMPLING,
        INSTRUMENTING;

    }

    public static enum Profiler {
        ART,
        SIMPLEPERF;

    }
}

