/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.monitor.gpu;

import com.android.ddmlib.Client;
import com.android.tools.adtui.AnimatedComponent;
import com.android.tools.adtui.Choreographer;
import com.android.tools.adtui.TimelineComponent;
import com.android.tools.adtui.TimelineData;
import com.android.tools.idea.actions.BrowserHelpAction;
import com.android.tools.idea.ddms.DeviceContext;
import com.android.tools.idea.monitor.BaseMonitorView;
import com.android.tools.idea.monitor.actions.RecordingAction;
import com.android.tools.idea.monitor.gpu.GpuSampler;
import com.android.tools.idea.monitor.gpu.ProfileStateListener;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.UIUtil;
import icons.AndroidIcons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GpuMonitorView
extends BaseMonitorView<GpuSampler>
implements ProfileStateListener {
    public static final int PRE_M_SAMPLE_FREQUENCY_MS = 33;
    private static final float PRE_M_TIMELINE_BUFFER_TIME = 0.0495f;
    private static final float PRE_M_TIMELINE_ABSOLUTE_MAX = 67.0f;
    public static final int POST_M_SAMPLE_FREQUENCY_MS = 200;
    private static final float POST_M_TIMELINE_BUFFER_TIME = 0.3f;
    private static final float POST_M_TIMELINE_ABSOLUTE_MAX = 67.0f;
    private static final float TIMELINE_INITIAL_MAX = 17.0f;
    private static final float TIMELINE_INITIAL_MARKER_SEPARATION = 3.0f;
    private static final Color BACKGROUND_COLOR = UIUtil.getTextFieldBackground();
    private static final String NEEDS_NEWER_API_LABEL = "This device does not support the minimum API level (16) for GPU monitor.";
    private static final String PROFILING_URL = "https://developer.android.com/r/studio-ui/am-gpu.html";
    private static final String NEEDS_PROFILING_ENABLED_LABEL = "GPU Profiling needs to be enabled in the device's developer options. <a href='https://developer.android.com/r/studio-ui/am-gpu.html'>Learn more</a>.";
    @NotNull
    private final JPanel myPanel;
    private int myApiLevel;
    public static final int EVENT_LAUNCH = 1;
    public static final int EVENT_TRACING = 2;

    public GpuMonitorView(@NotNull Project project, @NotNull DeviceContext deviceContext) {
        if (project == null) {
            GpuMonitorView.$$$reportNull$$$0(0);
        }
        if (deviceContext == null) {
            GpuMonitorView.$$$reportNull$$$0(1);
        }
        super(project, deviceContext, new GpuSampler(200), 0.3f, 17.0f, 67.0f, 3.0f);
        this.myApiLevel = 23;
        ((GpuSampler)this.mySampler).myProfileStateListener = this;
        this.myPanel = new JPanel(new BorderLayout());
        this.addOverlayText(NEEDS_NEWER_API_LABEL, 4);
        this.addOverlayText(NEEDS_PROFILING_ENABLED_LABEL, 6);
        this.myApiLevel = ((GpuSampler)this.mySampler).getApiLevel();
        this.configureTimelineComponent(((GpuSampler)this.mySampler).getTimelineData());
        deviceContext.addListener(this, (Disposable)project);
        this.myPanel.setBackground(BACKGROUND_COLOR);
        this.setViewComponent(this.myPanel);
    }

    @Override
    @NotNull
    public ActionGroup getToolbarActions() {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new RecordingAction(this));
        group.add((AnAction)new Separator());
        group.add((AnAction)new BrowserHelpAction("GPU monitor", PROFILING_URL));
        DefaultActionGroup defaultActionGroup = group;
        if (defaultActionGroup == null) {
            GpuMonitorView.$$$reportNull$$$0(2);
        }
        return defaultActionGroup;
    }

    public JPanel getPanel() {
        return this.myPanel;
    }

    @Override
    public void clientSelected(@Nullable Client client) {
        int newApiLevel;
        if (client != ((GpuSampler)this.mySampler).getClient()) {
            this.setOverlayEnabled(NEEDS_NEWER_API_LABEL, false);
            this.setOverlayEnabled(NEEDS_PROFILING_ENABLED_LABEL, false);
        }
        super.clientSelected(client);
        if (client != null && (newApiLevel = ((GpuSampler)this.mySampler).getApiLevel()) != this.myApiLevel) {
            this.myApiLevel = newApiLevel;
            this.configureTimelineComponent(((GpuSampler)this.mySampler).getTimelineData());
        }
    }

    @Override
    @NotNull
    public String getTitleName() {
        if ("GPU" == null) {
            GpuMonitorView.$$$reportNull$$$0(3);
        }
        return "GPU";
    }

    @Override
    @NotNull
    public Icon getTitleIcon() {
        Icon icon = AndroidIcons.GpuMonitor;
        if (icon == null) {
            GpuMonitorView.$$$reportNull$$$0(4);
        }
        return icon;
    }

    @Override
    protected boolean getPreferredPausedState() {
        return true;
    }

    @Override
    protected int getDefaultPosition() {
        return 3;
    }

    @Override
    @NotNull
    public String getMonitorName() {
        if ("GpuMonitor" == null) {
            GpuMonitorView.$$$reportNull$$$0(5);
        }
        return "GpuMonitor";
    }

    @Override
    @NotNull
    public String getDescription() {
        if ("gpu usage" == null) {
            GpuMonitorView.$$$reportNull$$$0(6);
        }
        return "gpu usage";
    }

    @Override
    public AndroidStudioEvent.MonitorType getMonitorType() {
        return AndroidStudioEvent.MonitorType.GPU;
    }

    private void configureTimelineComponent(@NotNull TimelineData data) {
        if (data == null) {
            GpuMonitorView.$$$reportNull$$$0(7);
        }
        if (this.myApiLevel >= 23) {
            this.myPanel.remove((Component)this.myTimelineComponent);
            this.myTimelineComponent = new TimelineComponent(data, this.myEvents, 0.3f, 17.0f, 67.0f, 3.0f);
            Choreographer.animate((AnimatedComponent)this.myTimelineComponent);
            this.myTimelineComponent.configureUnits("ms");
            this.myTimelineComponent.configureStream(0, "VSync Delay", (Color)new JBColor(31853, 26972));
            this.myTimelineComponent.configureStream(1, "Input Handling", (Color)new JBColor(41618, 35195));
            this.myTimelineComponent.configureStream(2, "Animation", (Color)new JBColor(45729, 38536));
            this.myTimelineComponent.configureStream(3, "Measure/Layout", (Color)new JBColor(2999734, 2533018));
            this.myTimelineComponent.configureStream(4, "Draw", (Color)new JBColor(2601727, 2201331));
            this.myTimelineComponent.configureStream(5, "Sync", (Color)new JBColor(6154239, 5227511));
            this.myTimelineComponent.configureStream(6, "Command Issue", (Color)new JBColor(0xFF4F40, 16007990));
            this.myTimelineComponent.configureStream(7, "Swap Buffers", (Color)new JBColor(16757760, 16750592));
            this.myTimelineComponent.configureStream(8, "Misc Time", (Color)new JBColor(36735, 31083));
            this.myTimelineComponent.setBackground(BACKGROUND_COLOR);
            this.setOverlayEnabled(NEEDS_NEWER_API_LABEL, false);
            this.myPanel.add((Component)this.myTimelineComponent, "Center");
        } else if (this.myApiLevel >= 16) {
            this.myPanel.remove((Component)this.myTimelineComponent);
            this.myTimelineComponent = new TimelineComponent(data, this.myEvents, 0.0495f, 17.0f, 67.0f, 3.0f);
            Choreographer.animate((AnimatedComponent)this.myTimelineComponent);
            if (this.myApiLevel >= 21) {
                this.myTimelineComponent.configureUnits("ms");
                this.myTimelineComponent.configureStream(0, "Draw", (Color)new JBColor(4815346, 4089548));
                this.myTimelineComponent.configureStream(1, "Prepare", (Color)new JBColor(11075839, 0x8F00FF));
                this.myTimelineComponent.configureStream(2, "Process", (Color)new JBColor(16728853, 14432530));
                this.myTimelineComponent.configureStream(3, "Execute", (Color)new JBColor(16757760, 15112192));
                this.myTimelineComponent.setBackground(BACKGROUND_COLOR);
            } else {
                this.myTimelineComponent.configureUnits("ms");
                this.myTimelineComponent.configureStream(0, "Draw", (Color)new JBColor(4815346, 4089548));
                this.myTimelineComponent.configureStream(1, "Process", (Color)new JBColor(16728853, 14432530));
                this.myTimelineComponent.configureStream(2, "Execute", (Color)new JBColor(16757760, 15112192));
                this.myTimelineComponent.setBackground(BACKGROUND_COLOR);
            }
            this.setOverlayEnabled(NEEDS_NEWER_API_LABEL, false);
            this.myPanel.add((Component)this.myTimelineComponent, "Center");
        } else {
            this.setOverlayEnabled(NEEDS_NEWER_API_LABEL, true);
        }
        this.myTimelineComponent.configureEvent(1, 0, AndroidIcons.Ddms.Threads, (Color)new JBColor(9612742, 7439507), (Color)new JBColor(2838156, 13100543), false);
        this.myTimelineComponent.configureEvent(2, 0, AndroidIcons.Ddms.StartMethodProfiling, (Color)new JBColor(9612742, 7439507), (Color)new JBColor(2838156, 13100543), true);
        this.myTimelineComponent.addReference(16.6f, (Color)JBColor.GREEN);
        this.myTimelineComponent.addReference(33.3f, (Color)JBColor.RED);
    }

    @Override
    public void notifyGpuProfileStateChanged(final @NotNull Client client, final boolean enabled) {
        if (client == null) {
            GpuMonitorView.$$$reportNull$$$0(8);
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                if (((GpuSampler)GpuMonitorView.this.mySampler).getClient() == client) {
                    GpuMonitorView.this.setOverlayEnabled(GpuMonitorView.NEEDS_PROFILING_ENABLED_LABEL, !enabled);
                    if (enabled) {
                        GpuMonitorView.this.configureTimelineComponent(((GpuSampler)GpuMonitorView.this.mySampler).getTimelineData());
                    } else {
                        ((GpuSampler)GpuMonitorView.this.mySampler).getTimelineData().clear();
                    }
                }
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deviceContext";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/monitor/gpu/GpuMonitorView";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "client";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/monitor/gpu/GpuMonitorView";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolbarActions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitleName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitleIcon";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getMonitorName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "configureTimelineComponent";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "notifyGpuProfileStateChanged";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

