/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.monitor.cpu;

import com.android.tools.idea.actions.BrowserHelpAction;
import com.android.tools.idea.ddms.DeviceContext;
import com.android.tools.idea.ddms.actions.ToggleMethodProfilingAction;
import com.android.tools.idea.monitor.BaseMonitorView;
import com.android.tools.idea.monitor.TimelineEventListener;
import com.android.tools.idea.monitor.actions.RecordingAction;
import com.android.tools.idea.monitor.cpu.CpuSampler;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.project.Project;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.UIUtil;
import icons.AndroidIcons;
import java.awt.Color;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class CpuMonitorView
extends BaseMonitorView<CpuSampler>
implements TimelineEventListener,
DeviceContext.DeviceSelectionListener {
    private static final Color BACKGROUND_COLOR = UIUtil.getTextFieldBackground();
    private static final int SAMPLE_FREQUENCY_MS = 500;
    private static final float TIMELINE_BUFFER_TIME = 0.75f;
    private static final float TIMELINE_INITIAL_MAX = 100.0f;
    private static final float TIMELINE_ABSOLUTE_MAX = 100.0f;
    private static final float TIMELINE_INITIAL_MARKER_SEPARATION = 10.0f;

    public CpuMonitorView(@NotNull Project project, @NotNull DeviceContext deviceContext) {
        if (project == null) {
            CpuMonitorView.$$$reportNull$$$0(0);
        }
        if (deviceContext == null) {
            CpuMonitorView.$$$reportNull$$$0(1);
        }
        super(project, deviceContext, new CpuSampler(500), 0.75f, 100.0f, 100.0f, 10.0f);
        this.myTimelineComponent.configureUnits("%");
        this.myTimelineComponent.configureStream(0, "Kernel", (Color)new JBColor(14106431, 14106431));
        this.myTimelineComponent.configureStream(1, "User", (Color)new JBColor(15441823, 10308684));
        this.myTimelineComponent.setBackground(BACKGROUND_COLOR);
        this.setViewComponent((JComponent)this.myTimelineComponent);
    }

    @Override
    @NotNull
    public ActionGroup getToolbarActions() {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new RecordingAction(this));
        group.add((AnAction)new Separator());
        group.add((AnAction)new ToggleMethodProfilingAction(this.myProject, this.myDeviceContext));
        group.add((AnAction)new Separator());
        group.add((AnAction)new BrowserHelpAction("CPU monitor", "http://developer.android.com/r/studio-ui/am-cpu.html"));
        DefaultActionGroup defaultActionGroup = group;
        if (defaultActionGroup == null) {
            CpuMonitorView.$$$reportNull$$$0(2);
        }
        return defaultActionGroup;
    }

    @Override
    @NotNull
    public String getTitleName() {
        if ("CPU" == null) {
            CpuMonitorView.$$$reportNull$$$0(3);
        }
        return "CPU";
    }

    @Override
    @NotNull
    public Icon getTitleIcon() {
        Icon icon = AndroidIcons.CpuMonitor;
        if (icon == null) {
            CpuMonitorView.$$$reportNull$$$0(4);
        }
        return icon;
    }

    @Override
    protected int getDefaultPosition() {
        return 1;
    }

    @Override
    @NotNull
    public String getMonitorName() {
        if ("CpuMonitor" == null) {
            CpuMonitorView.$$$reportNull$$$0(5);
        }
        return "CpuMonitor";
    }

    @Override
    @NotNull
    public String getDescription() {
        if ("cpu usage" == null) {
            CpuMonitorView.$$$reportNull$$$0(6);
        }
        return "cpu usage";
    }

    @Override
    public AndroidStudioEvent.MonitorType getMonitorType() {
        return AndroidStudioEvent.MonitorType.CPU;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deviceContext";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/monitor/cpu/CpuMonitorView";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/monitor/cpu/CpuMonitorView";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolbarActions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitleName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitleIcon";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getMonitorName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

