/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ex.CheckboxAction;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.FilterComponent;
import com.intellij.ui.LightColors;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ui.UIUtil;
import java.util.EventListener;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RegexFilterComponent
extends FilterComponent {
    private static final String REGEX = "Regex";
    @NotNull
    private final EventDispatcher<Listener> myMulticaster = EventDispatcher.create(Listener.class);
    @NotNull
    private final Compiled myCompiled = new Compiled();
    @NotNull
    private final JCheckBox myCheckBox;
    private boolean myIsRegex = true;

    public RegexFilterComponent(@NonNls String propertyName, int historySize) {
        super(propertyName, historySize, true);
        CheckboxAction regexToggle = new CheckboxAction(REGEX){

            public boolean isSelected(AnActionEvent e) {
                return RegexFilterComponent.this.isRegex();
            }

            public void setSelected(AnActionEvent e, boolean state) {
                RegexFilterComponent.this.setIsRegex(state);
            }
        };
        JComponent component = regexToggle.createCustomComponent(regexToggle.getTemplatePresentation());
        assert (component instanceof JCheckBox);
        this.myCheckBox = (JCheckBox)component;
        this.add(this.myCheckBox, "East");
        this.myCheckBox.setSelected(this.myIsRegex);
    }

    @Nullable
    public String getParseError() {
        return this.myCompiled.error;
    }

    public boolean isRegex() {
        return this.myIsRegex;
    }

    public void setIsRegex(boolean value) {
        this.myIsRegex = value;
        this.myCheckBox.setSelected(this.myIsRegex);
        this.filter();
    }

    public Pattern getPattern() {
        return this.myCompiled.pattern;
    }

    public void addRegexListener(Listener listener) {
        this.myMulticaster.addListener((EventListener)listener);
    }

    public static Compiled compile(String filter, boolean isRegex) {
        return new Compiled(filter, isRegex);
    }

    public static Pattern pattern(String filter, boolean isRegex) {
        return new Compiled(filter, isRegex).pattern;
    }

    public void filter() {
        this.myCompiled.compile(this.getFilter(), this.isRegex());
        this.getTextEditor().setBackground(this.myCompiled.error != null ? LightColors.RED : UIUtil.getTextFieldBackground());
        ((Listener)this.myMulticaster.getMulticaster()).filterChanged(this);
    }

    public static final class Compiled {
        @Nullable
        private Pattern pattern;
        private String error = null;

        public Compiled() {
        }

        public Compiled(String filter, boolean isRegex) {
            this.compile(filter, isRegex);
        }

        public final void compile(String filter, boolean isRegex) {
            this.pattern = null;
            this.error = null;
            if (StringUtil.isNotEmpty((String)filter)) {
                int flags;
                block6: {
                    flags = 2;
                    if (StringUtil.hasUpperCaseChar((String)filter) && StringUtil.hasLowerCaseChar((String)filter)) {
                        flags = 0;
                    }
                    if (isRegex) {
                        try {
                            this.pattern = Pattern.compile(filter, flags);
                        }
                        catch (PatternSyntaxException e) {
                            this.error = e.getMessage();
                            if ($assertionsDisabled || this.error != null) break block6;
                            throw new AssertionError();
                        }
                    }
                }
                if (this.pattern == null) {
                    this.pattern = Pattern.compile(Pattern.quote(filter), flags);
                }
            }
        }
    }

    public static interface Listener
    extends EventListener {
        public void filterChanged(RegexFilterComponent var1);
    }
}

