/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat;

import com.android.ddmlib.Log;
import com.android.ddmlib.logcat.LogCatHeader;
import com.android.ddmlib.logcat.LogCatMessage;
import com.android.ddmlib.logcat.LogCatTimestamp;
import com.android.tools.idea.logcat.AndroidLogcatPreferences;
import com.google.common.base.Strings;
import com.intellij.diagnostic.logging.DefaultLogFormatter;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AndroidLogcatFormatter
extends DefaultLogFormatter {
    private final AndroidLogcatPreferences myPreferences;
    @NonNls
    private static final Pattern MESSAGE_WITH_HEADER = Pattern.compile("^(\\d\\d-\\d\\d\\s\\d\\d:\\d\\d:\\d\\d.\\d+)\\s+(\\d+)-(\\d+)/(\\S+)\\s+([A-Z])/([^ ]+): (.*)$");
    @NonNls
    private static final Pattern CONTINUATION_PATTERN = Pattern.compile("^\\+ (.*)$");
    private static final String FULL_FORMAT = AndroidLogcatFormatter.createCustomFormat(true, true, true, true);
    private int myLastHeaderLength;

    public AndroidLogcatFormatter(@NotNull AndroidLogcatPreferences preferences) {
        if (preferences == null) {
            AndroidLogcatFormatter.$$$reportNull$$$0(0);
        }
        this.myLastHeaderLength = 0;
        this.myPreferences = preferences;
    }

    @NotNull
    public static String formatMessageFull(@NotNull LogCatHeader header, @NotNull String message) {
        if (header == null) {
            AndroidLogcatFormatter.$$$reportNull$$$0(1);
        }
        if (message == null) {
            AndroidLogcatFormatter.$$$reportNull$$$0(2);
        }
        String string = AndroidLogcatFormatter.formatMessage(FULL_FORMAT, header, message);
        if (string == null) {
            AndroidLogcatFormatter.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public static String formatContinuation(@NotNull String message) {
        if (message == null) {
            AndroidLogcatFormatter.$$$reportNull$$$0(4);
        }
        String string = String.format("+ %s", message);
        if (string == null) {
            AndroidLogcatFormatter.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public static String createCustomFormat(boolean showTime, boolean showPid, boolean showPackage, boolean showTag) {
        StringBuilder builder = new StringBuilder();
        if (showTime) {
            builder.append("%1$s ");
        }
        if (showPid) {
            builder.append("%2$s").append(showPackage ? (char)'/' : ' ');
        }
        if (showPackage) {
            builder.append("%3$s ");
        }
        builder.append("%4$c");
        if (showTag) {
            builder.append("/%5$s");
        }
        builder.append(": %6$s");
        String string = builder.toString();
        if (string == null) {
            AndroidLogcatFormatter.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    static String formatMessage(@NotNull String format, @NotNull String msg) {
        if (format == null) {
            AndroidLogcatFormatter.$$$reportNull$$$0(7);
        }
        if (msg == null) {
            AndroidLogcatFormatter.$$$reportNull$$$0(8);
        }
        if (format.isEmpty()) {
            String string = msg;
            if (string == null) {
                AndroidLogcatFormatter.$$$reportNull$$$0(9);
            }
            return string;
        }
        LogCatMessage message = AndroidLogcatFormatter.parseMessage(msg);
        String string = AndroidLogcatFormatter.formatMessage(format, message.getHeader(), message.getMessage());
        if (string == null) {
            AndroidLogcatFormatter.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    public static String formatMessage(@NotNull String format, @NotNull LogCatHeader header, @NotNull String message) {
        if (format == null) {
            AndroidLogcatFormatter.$$$reportNull$$$0(11);
        }
        if (header == null) {
            AndroidLogcatFormatter.$$$reportNull$$$0(12);
        }
        if (message == null) {
            AndroidLogcatFormatter.$$$reportNull$$$0(13);
        }
        String ids = String.format(Locale.US, "%s-%s", header.getPid(), header.getTid());
        String tag = header.getTag().replace(' ', '\u00a0');
        String string = String.format(Locale.US, format, header.getTimestamp(), ids, header.getAppName(), Character.valueOf(header.getLogLevel().getPriorityLetter()), tag, message);
        if (string == null) {
            AndroidLogcatFormatter.$$$reportNull$$$0(14);
        }
        return string;
    }

    @NotNull
    public static LogCatMessage parseMessage(@NotNull String msg) {
        LogCatMessage result;
        if (msg == null) {
            AndroidLogcatFormatter.$$$reportNull$$$0(15);
        }
        if ((result = AndroidLogcatFormatter.tryParseMessage(msg)) == null) {
            throw new IllegalArgumentException("Invalid message doesn't match expected logcat pattern: " + msg);
        }
        LogCatMessage logCatMessage = result;
        if (logCatMessage == null) {
            AndroidLogcatFormatter.$$$reportNull$$$0(16);
        }
        return logCatMessage;
    }

    @Nullable
    public static LogCatMessage tryParseMessage(@NotNull String msg) {
        Matcher matcher;
        if (msg == null) {
            AndroidLogcatFormatter.$$$reportNull$$$0(17);
        }
        if (!(matcher = MESSAGE_WITH_HEADER.matcher(msg)).matches()) {
            return null;
        }
        LogCatHeader header = new LogCatHeader(Log.LogLevel.getByLetter((char)matcher.group(5).charAt(0)), Integer.parseInt(matcher.group(2)), Integer.parseInt(matcher.group(3)), matcher.group(4), matcher.group(6), LogCatTimestamp.fromString((String)matcher.group(1)));
        String message = matcher.group(7);
        return new LogCatMessage(header, message);
    }

    @Nullable
    public static String tryParseContinuation(@NotNull String msg) {
        Matcher matcher;
        if (msg == null) {
            AndroidLogcatFormatter.$$$reportNull$$$0(18);
        }
        if (!(matcher = CONTINUATION_PATTERN.matcher(msg)).matches()) {
            return null;
        }
        return matcher.group(1);
    }

    public String formatPrefix(String prefix) {
        if (prefix.isEmpty()) {
            return prefix;
        }
        String[] lines = prefix.split("\n");
        StringBuilder sb = new StringBuilder(prefix.length() + (lines.length - 1) * this.myLastHeaderLength);
        for (String line : lines) {
            sb.append(this.formatMessage(line));
            sb.append('\n');
        }
        return sb.toString();
    }

    public String formatMessage(String msg) {
        String continuation = AndroidLogcatFormatter.tryParseContinuation(msg);
        if (continuation != null) {
            return Strings.repeat((String)" ", (int)this.myLastHeaderLength) + continuation;
        }
        LogCatMessage message = AndroidLogcatFormatter.tryParseMessage(msg);
        if (message != null) {
            String formatted = AndroidLogcatFormatter.formatMessage(this.myPreferences.LOGCAT_FORMAT_STRING, msg);
            this.myLastHeaderLength = formatted.indexOf(message.getMessage());
            return formatted;
        }
        return msg;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 14: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 14: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preferences";
                break;
            }
            case 1: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "header";
                break;
            }
            case 2: 
            case 4: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/logcat/AndroidLogcatFormatter";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 8: 
            case 15: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "msg";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/logcat/AndroidLogcatFormatter";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "formatMessageFull";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "formatContinuation";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createCustomFormat";
                break;
            }
            case 9: 
            case 10: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "formatMessage";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "parseMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "formatMessageFull";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 14: 
            case 16: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "formatContinuation";
                break;
            }
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "formatMessage";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "parseMessage";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "tryParseMessage";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "tryParseContinuation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 14: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

