/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.android.builder.model.BuildType;
import com.android.builder.model.BuildTypeContainer;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.templates.TemplateUtils;
import com.android.utils.Pair;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import java.io.IOException;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFix;
import org.jetbrains.android.inspections.lint.AndroidQuickfixContexts;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MoveToDebugManifestQuickFix
implements AndroidLintQuickFix {
    MoveToDebugManifestQuickFix() {
    }

    @Override
    public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
        XmlTag parent;
        XmlAttribute attribute;
        if (startElement == null) {
            MoveToDebugManifestQuickFix.$$$reportNull$$$0(0);
        }
        if (endElement == null) {
            MoveToDebugManifestQuickFix.$$$reportNull$$$0(1);
        }
        if (context == null) {
            MoveToDebugManifestQuickFix.$$$reportNull$$$0(2);
        }
        if ((attribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlAttribute.class)) != null && (parent = attribute.getParent()) != null && parent.getName().equals("uses-permission")) {
            AndroidFacet facet;
            Module module = MoveToDebugManifestQuickFix.getModule((PsiElement)parent);
            assert ("android.permission.ACCESS_MOCK_LOCATION".equals(parent.getAttributeValue("name", "http://schemas.android.com/apk/res/android")));
            parent.delete();
            if (module != null && (facet = AndroidFacet.getInstance(module)) != null) {
                VirtualFile mainManifest = facet.getMainIdeaSourceProvider().getManifestFile();
                AndroidModuleModel androidModel = AndroidModuleModel.get(facet);
                if (androidModel != null && mainManifest != null && mainManifest.getParent() != null && mainManifest.getParent().getParent() != null) {
                    VirtualFile src = mainManifest.getParent().getParent();
                    for (BuildTypeContainer container : androidModel.getAndroidProject().getBuildTypes()) {
                        BuildType buildType = container.getBuildType();
                        if (!buildType.isDebuggable()) continue;
                        this.addManifest(module, src, buildType.getName());
                        return;
                    }
                    Messages.showErrorDialog((Project)module.getProject(), (String)"Did not find a debug build type", (String)"Move Permission");
                }
            }
        }
    }

    private void addManifest(@NotNull Module module, final @NotNull VirtualFile src, final @NotNull String buildTypeName) {
        if (module == null) {
            MoveToDebugManifestQuickFix.$$$reportNull$$$0(3);
        }
        if (src == null) {
            MoveToDebugManifestQuickFix.$$$reportNull$$$0(4);
        }
        if (buildTypeName == null) {
            MoveToDebugManifestQuickFix.$$$reportNull$$$0(5);
        }
        Project project = module.getProject();
        final VirtualFile manifest = src.findFileByRelativePath(buildTypeName + '/' + "AndroidManifest.xml");
        Pair result = (Pair)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<Pair<String, VirtualFile>>(){

            public Pair<String, VirtualFile> compute() {
                String text;
                int index;
                if (manifest == null) {
                    try {
                        VirtualFile newParentFolder = src.findChild(buildTypeName);
                        if (newParentFolder == null && (newParentFolder = src.createChildDirectory((Object)this, buildTypeName)) == null) {
                            String message = String.format("Could not create folder %1$s in %2$s", buildTypeName, src.getPath());
                            return Pair.of((Object)message, null);
                        }
                        VirtualFile newFile = newParentFolder.createChildData((Object)this, "AndroidManifest.xml");
                        String text2 = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<manifest xmlns:android=\"http://schemas.android.com/apk/res/android\">\n    <uses-permission android:name=\"android.permission.ACCESS_MOCK_LOCATION\" />\n</manifest>\n";
                        VfsUtil.saveText((VirtualFile)newFile, (String)text2);
                        return Pair.of(null, (Object)newFile);
                    }
                    catch (IOException e) {
                        String message = String.format("Failed to create file: %1$s", e.getMessage());
                        return Pair.of((Object)message, null);
                    }
                }
                Document document = FileDocumentManager.getInstance().getDocument(manifest);
                if (document != null && (index = (text = document.getText()).lastIndexOf("</manifest>")) != -1) {
                    document.insertString(index, (CharSequence)"    <uses-permission android:name=\"android.permission.ACCESS_MOCK_LOCATION\" />\n");
                    return Pair.of(null, (Object)manifest);
                }
                return Pair.of((Object)("Could not add to " + VfsUtilCore.virtualToIoFile((VirtualFile)manifest)), null);
            }
        });
        String error = (String)result.getFirst();
        VirtualFile newFile = (VirtualFile)result.getSecond();
        if (error != null) {
            Messages.showErrorDialog((Project)project, (String)error, (String)"Move Permission");
        } else {
            TemplateUtils.openEditor(project, newFile);
            TemplateUtils.selectEditor(project, newFile);
        }
    }

    @Nullable
    private static Module getModule(PsiElement element) {
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)element.getProject()).getFileIndex();
        return index.getModuleForFile(element.getContainingFile().getVirtualFile());
    }

    @Override
    public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
        if (startElement == null) {
            MoveToDebugManifestQuickFix.$$$reportNull$$$0(6);
        }
        if (endElement == null) {
            MoveToDebugManifestQuickFix.$$$reportNull$$$0(7);
        }
        if (contextType == null) {
            MoveToDebugManifestQuickFix.$$$reportNull$$$0(8);
        }
        return PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlAttribute.class) != null;
    }

    @Override
    @NotNull
    public String getName() {
        if ("Move to debug-specific manifest" == null) {
            MoveToDebugManifestQuickFix.$$$reportNull$$$0(9);
        }
        return "Move to debug-specific manifest";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "src";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildTypeName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextType";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/lint/MoveToDebugManifestQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/lint/MoveToDebugManifestQuickFix";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addManifest";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

