/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.android.tools.idea.lint.ReplaceStringQuickFix;
import com.android.tools.lint.checks.AppIndexingApiDetector;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlAttribute;
import org.jetbrains.android.inspections.lint.AndroidLintInspectionBase;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFix;
import org.jetbrains.android.inspections.lint.SetAttributeQuickFix;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public class AndroidLintGoogleAppIndexingApiWarningInspection
extends AndroidLintInspectionBase {
    public AndroidLintGoogleAppIndexingApiWarningInspection() {
        super(AndroidBundle.message("android.lint.inspections.google.app.indexing.api.warning", new Object[0]), AppIndexingApiDetector.ISSUE_APP_INDEXING_API);
    }

    @NotNull
    static AndroidLintQuickFix[] getAppIndexingQuickFix(PsiElement startElement, String message) {
        AppIndexingApiDetector.IssueType type = AppIndexingApiDetector.IssueType.parse((String)message);
        switch (type) {
            case SCHEME_MISSING: 
            case URL_MISSING: {
                AndroidLintQuickFix[] androidLintQuickFixArray = new AndroidLintQuickFix[]{new SetAttributeQuickFix("Set scheme", "scheme", "http")};
                if (androidLintQuickFixArray == null) {
                    AndroidLintGoogleAppIndexingApiWarningInspection.$$$reportNull$$$0(0);
                }
                return androidLintQuickFixArray;
            }
            case HOST_MISSING: {
                AndroidLintQuickFix[] androidLintQuickFixArray = new AndroidLintQuickFix[]{new SetAttributeQuickFix("Set host", "host", null)};
                if (androidLintQuickFixArray == null) {
                    AndroidLintGoogleAppIndexingApiWarningInspection.$$$reportNull$$$0(1);
                }
                return androidLintQuickFixArray;
            }
            case MISSING_SLASH: {
                XmlAttribute attr;
                String path;
                PsiElement parent = startElement.getParent();
                if (!(parent instanceof XmlAttribute) || (path = (attr = (XmlAttribute)parent).getValue()) == null) break;
                AndroidLintQuickFix[] androidLintQuickFixArray = new AndroidLintQuickFix[]{new ReplaceStringQuickFix("Replace with /" + path, path, "/" + path)};
                if (androidLintQuickFixArray == null) {
                    AndroidLintGoogleAppIndexingApiWarningInspection.$$$reportNull$$$0(2);
                }
                return androidLintQuickFixArray;
            }
        }
        if (AndroidLintQuickFix.EMPTY_ARRAY == null) {
            AndroidLintGoogleAppIndexingApiWarningInspection.$$$reportNull$$$0(3);
        }
        return AndroidLintQuickFix.EMPTY_ARRAY;
    }

    @Override
    @NotNull
    public AndroidLintQuickFix[] getQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message) {
        if (startElement == null) {
            AndroidLintGoogleAppIndexingApiWarningInspection.$$$reportNull$$$0(4);
        }
        if (endElement == null) {
            AndroidLintGoogleAppIndexingApiWarningInspection.$$$reportNull$$$0(5);
        }
        if (message == null) {
            AndroidLintGoogleAppIndexingApiWarningInspection.$$$reportNull$$$0(6);
        }
        AndroidLintQuickFix[] androidLintQuickFixArray = AndroidLintGoogleAppIndexingApiWarningInspection.getAppIndexingQuickFix(startElement, message);
        if (androidLintQuickFixArray == null) {
            AndroidLintGoogleAppIndexingApiWarningInspection.$$$reportNull$$$0(7);
        }
        return androidLintQuickFixArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/lint/AndroidLintGoogleAppIndexingApiWarningInspection";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAppIndexingQuickFix";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/lint/AndroidLintGoogleAppIndexingApiWarningInspection";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuickFixes";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getQuickFixes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

