/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.android.ide.common.resources.ResourceUrl;
import com.android.tools.idea.lint.GenerateBackupDescriptorFix;
import com.android.tools.idea.lint.SetAndGenerateBackupDescriptor;
import com.android.tools.lint.checks.ManifestDetector;
import com.intellij.psi.PsiElement;
import org.jetbrains.android.inspections.lint.AndroidLintInspectionBase;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFix;
import org.jetbrains.android.inspections.lint.AndroidQuickfixContexts;
import org.jetbrains.android.inspections.lint.SetAttributeQuickFix;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public class AndroidLintAllowBackupInspection
extends AndroidLintInspectionBase {
    public AndroidLintAllowBackupInspection() {
        super(AndroidBundle.message("android.lint.inspections.allow.backup", new Object[0]), ManifestDetector.ALLOW_BACKUP);
    }

    @Override
    @NotNull
    public AndroidLintQuickFix[] getQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message) {
        ResourceUrl url;
        if (startElement == null) {
            AndroidLintAllowBackupInspection.$$$reportNull$$$0(0);
        }
        if (endElement == null) {
            AndroidLintAllowBackupInspection.$$$reportNull$$$0(1);
        }
        if (message == null) {
            AndroidLintAllowBackupInspection.$$$reportNull$$$0(2);
        }
        if ("Missing `<full-backup-content>` resource".equals(message) && (url = ResourceUrl.parse((String)startElement.getText())) != null) {
            AndroidLintQuickFix[] androidLintQuickFixArray = new AndroidLintQuickFix[]{new GenerateBackupDescriptorFix(url)};
            if (androidLintQuickFixArray == null) {
                AndroidLintAllowBackupInspection.$$$reportNull$$$0(3);
            }
            return androidLintQuickFixArray;
        }
        AndroidLintQuickFix[] androidLintQuickFixArray = new AndroidLintQuickFix[]{new SetAttributeQuickFix("Set backup attribute", "allowBackup", null), new SetAttributeQuickFix("Set fullBackupContent attribute", "fullBackupContent", null){

            @Override
            public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
                if (startElement == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (endElement == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (contextType == null) {
                    1.$$$reportNull$$$0(2);
                }
                return SetAndGenerateBackupDescriptor.isAllowBackupEnabled(startElement) && super.isApplicable(startElement, endElement, contextType);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "startElement";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "endElement";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "contextType";
                        break;
                    }
                }
                objectArray[1] = "com/android/tools/idea/lint/AndroidLintAllowBackupInspection$1";
                objectArray[2] = "isApplicable";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, new SetAndGenerateBackupDescriptor()};
        if (androidLintQuickFixArray == null) {
            AndroidLintAllowBackupInspection.$$$reportNull$$$0(4);
        }
        return androidLintQuickFixArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/lint/AndroidLintAllowBackupInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/lint/AndroidLintAllowBackupInspection";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuickFixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getQuickFixes";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

