/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.variant.view;

import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.Variant;
import com.android.tools.idea.gradle.project.build.GradleProjectBuilder;
import com.android.tools.idea.gradle.project.facet.ndk.NdkFacet;
import com.android.tools.idea.gradle.project.facet.ndk.NdkFacetConfiguration;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.model.NdkModuleModel;
import com.android.tools.idea.gradle.project.sync.setup.module.AndroidModuleSetupStep;
import com.android.tools.idea.gradle.project.sync.setup.module.NdkModuleSetupStep;
import com.android.tools.idea.gradle.project.sync.setup.post.PostSyncProjectSetup;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.gradle.variant.conflict.ConflictSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProviderImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class BuildVariantUpdater {
    private static final Logger LOG = Logger.getInstance(BuildVariantUpdater.class);

    BuildVariantUpdater() {
    }

    boolean updateSelectedVariant(@NotNull Project project, @NotNull String moduleName, @NotNull String buildVariantName) {
        if (project == null) {
            BuildVariantUpdater.$$$reportNull$$$0(0);
        }
        if (moduleName == null) {
            BuildVariantUpdater.$$$reportNull$$$0(1);
        }
        if (buildVariantName == null) {
            BuildVariantUpdater.$$$reportNull$$$0(2);
        }
        ArrayList affectedAndroidFacets = new ArrayList();
        ArrayList affectedNdkFacets = new ArrayList();
        Projects.executeProjectChanges(project, () -> {
            Module updatedModule;
            if (project == null) {
                BuildVariantUpdater.$$$reportNull$$$0(34);
            }
            if (moduleName == null) {
                BuildVariantUpdater.$$$reportNull$$$0(35);
            }
            if (buildVariantName == null) {
                BuildVariantUpdater.$$$reportNull$$$0(36);
            }
            if ((updatedModule = this.doUpdate(project, moduleName, buildVariantName, affectedAndroidFacets, affectedNdkFacets)) != null) {
                ConflictSet conflicts = ConflictSet.findConflicts(project);
                conflicts.showSelectionConflicts();
            }
            PostSyncProjectSetup.Request setupRequest = new PostSyncProjectSetup.Request();
            setupRequest.setGenerateSourcesAfterSync(false).setCleanProjectAfterSync(false);
            PostSyncProjectSetup.getInstance(project).setUpProject(setupRequest, null);
            BuildVariantUpdater.generateSourcesIfNeeded(affectedAndroidFacets);
        });
        return !affectedAndroidFacets.isEmpty() || !affectedNdkFacets.isEmpty();
    }

    @Nullable
    private Module doUpdate(@NotNull Project project, @NotNull String moduleName, @NotNull String variant, @NotNull List<AndroidFacet> affectedAndroidFacets, @NotNull List<NdkFacet> affectedNativeAndroidFacets) {
        Module moduleToUpdate;
        if (project == null) {
            BuildVariantUpdater.$$$reportNull$$$0(3);
        }
        if (moduleName == null) {
            BuildVariantUpdater.$$$reportNull$$$0(4);
        }
        if (variant == null) {
            BuildVariantUpdater.$$$reportNull$$$0(5);
        }
        if (affectedAndroidFacets == null) {
            BuildVariantUpdater.$$$reportNull$$$0(6);
        }
        if (affectedNativeAndroidFacets == null) {
            BuildVariantUpdater.$$$reportNull$$$0(7);
        }
        if ((moduleToUpdate = BuildVariantUpdater.findModule(project, moduleName)) == null) {
            BuildVariantUpdater.logAndShowUpdateFailure(variant, String.format("Cannot find module '%1$s'.", moduleName));
            return null;
        }
        AndroidFacet androidFacet = AndroidFacet.getInstance(moduleToUpdate);
        NdkFacet ndkFacet = NdkFacet.getInstance(moduleToUpdate);
        if (androidFacet == null && ndkFacet == null) {
            String msg = String.format("Cannot find 'Android' or 'Native-Android-Gradle' facets in module '%1$s'.", moduleToUpdate.getName());
            BuildVariantUpdater.logAndShowUpdateFailure(variant, msg);
        }
        if (ndkFacet != null) {
            NdkModuleModel ndkModuleModel = BuildVariantUpdater.getNativeAndroidModel(ndkFacet, variant);
            if (ndkModuleModel == null || !BuildVariantUpdater.updateSelectedVariant(ndkFacet, ndkModuleModel, variant)) {
                return null;
            }
            affectedNativeAndroidFacets.add(ndkFacet);
        }
        if (androidFacet != null) {
            AndroidModuleModel androidModel = BuildVariantUpdater.getAndroidModel(androidFacet, variant);
            if (androidModel == null || !this.updateSelectedVariant(androidFacet, androidModel, variant, affectedAndroidFacets)) {
                return null;
            }
            affectedAndroidFacets.add(androidFacet);
        }
        return moduleToUpdate;
    }

    @Nullable
    private static Module findModule(@NotNull Project project, @NotNull String moduleName) {
        if (project == null) {
            BuildVariantUpdater.$$$reportNull$$$0(8);
        }
        if (moduleName == null) {
            BuildVariantUpdater.$$$reportNull$$$0(9);
        }
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        return moduleManager.findModuleByName(moduleName);
    }

    private boolean updateSelectedVariant(@NotNull AndroidFacet androidFacet, @NotNull AndroidModuleModel androidModel, @NotNull String variantToSelect, @NotNull List<AndroidFacet> affectedFacets) {
        Variant selectedVariant;
        if (androidFacet == null) {
            BuildVariantUpdater.$$$reportNull$$$0(10);
        }
        if (androidModel == null) {
            BuildVariantUpdater.$$$reportNull$$$0(11);
        }
        if (variantToSelect == null) {
            BuildVariantUpdater.$$$reportNull$$$0(12);
        }
        if (affectedFacets == null) {
            BuildVariantUpdater.$$$reportNull$$$0(13);
        }
        if (variantToSelect.equals((selectedVariant = androidModel.getSelectedVariant()).getName())) {
            return false;
        }
        androidModel.setSelectedVariantName(variantToSelect);
        androidModel.syncSelectedVariantAndTestArtifact(androidFacet);
        Module module = BuildVariantUpdater.setUpModule(androidFacet.getModule(), androidModel);
        for (AndroidLibrary library : androidModel.getSelectedMainCompileDependencies().getLibraries()) {
            String projectVariant;
            String gradlePath = library.getProject();
            if (StringUtil.isEmpty((String)gradlePath) || !StringUtil.isNotEmpty((String)(projectVariant = library.getProjectVariant()))) continue;
            this.ensureVariantIsSelected(module.getProject(), gradlePath, projectVariant, affectedFacets);
        }
        return true;
    }

    private static boolean updateSelectedVariant(@NotNull NdkFacet ndkFacet, @NotNull NdkModuleModel ndkModuleModel, @NotNull String variantToSelect) {
        NdkModuleModel.NdkVariant selectedVariant;
        if (ndkFacet == null) {
            BuildVariantUpdater.$$$reportNull$$$0(14);
        }
        if (ndkModuleModel == null) {
            BuildVariantUpdater.$$$reportNull$$$0(15);
        }
        if (variantToSelect == null) {
            BuildVariantUpdater.$$$reportNull$$$0(16);
        }
        if (variantToSelect.equals((selectedVariant = ndkModuleModel.getSelectedVariant()).getName())) {
            return false;
        }
        ndkModuleModel.setSelectedVariantName(variantToSelect);
        ((NdkFacetConfiguration)ndkFacet.getConfiguration()).SELECTED_BUILD_VARIANT = ndkModuleModel.getSelectedVariant().getName();
        BuildVariantUpdater.setUpModule(ndkFacet.getModule(), ndkModuleModel);
        return true;
    }

    private static void generateSourcesIfNeeded(@NotNull List<AndroidFacet> affectedFacets) {
        if (affectedFacets == null) {
            BuildVariantUpdater.$$$reportNull$$$0(17);
        }
        if (!affectedFacets.isEmpty() && !ApplicationManager.getApplication().isUnitTestMode()) {
            Project project = affectedFacets.get(0).getModule().getProject();
            GradleProjectBuilder.getInstance(project).generateSourcesOnly(false);
        }
    }

    @NotNull
    private static Module setUpModule(@NotNull Module module, @NotNull AndroidModuleModel androidModel) {
        if (module == null) {
            BuildVariantUpdater.$$$reportNull$$$0(18);
        }
        if (androidModel == null) {
            BuildVariantUpdater.$$$reportNull$$$0(19);
        }
        IdeModifiableModelsProviderImpl modelsProvider = new IdeModifiableModelsProviderImpl(module.getProject());
        try {
            for (AndroidModuleSetupStep setupStep : AndroidModuleSetupStep.getExtensions()) {
                if (!setupStep.invokeOnBuildVariantChange()) continue;
                setupStep.setUpModule(module, (IdeModifiableModelsProvider)modelsProvider, androidModel, null, null);
            }
            modelsProvider.commit();
        }
        catch (Throwable t) {
            modelsProvider.dispose();
            ExceptionUtil.rethrowAllAsUnchecked((Throwable)t);
        }
        Module module2 = module;
        if (module2 == null) {
            BuildVariantUpdater.$$$reportNull$$$0(20);
        }
        return module2;
    }

    @NotNull
    private static Module setUpModule(@NotNull Module module, @NotNull NdkModuleModel ndkModuleModel) {
        if (module == null) {
            BuildVariantUpdater.$$$reportNull$$$0(21);
        }
        if (ndkModuleModel == null) {
            BuildVariantUpdater.$$$reportNull$$$0(22);
        }
        IdeModifiableModelsProviderImpl modelsProvider = new IdeModifiableModelsProviderImpl(module.getProject());
        try {
            for (NdkModuleSetupStep setupStep : NdkModuleSetupStep.getExtensions()) {
                if (!setupStep.invokeOnBuildVariantChange()) continue;
                setupStep.setUpModule(module, (IdeModifiableModelsProvider)modelsProvider, ndkModuleModel, null, null);
            }
            modelsProvider.commit();
        }
        catch (Throwable t) {
            modelsProvider.dispose();
            ExceptionUtil.rethrowAllAsUnchecked((Throwable)t);
        }
        Module module2 = module;
        if (module2 == null) {
            BuildVariantUpdater.$$$reportNull$$$0(23);
        }
        return module2;
    }

    private void ensureVariantIsSelected(@NotNull Project project, @NotNull String moduleGradlePath, @NotNull String variant, @NotNull List<AndroidFacet> affectedFacets) {
        Module module;
        if (project == null) {
            BuildVariantUpdater.$$$reportNull$$$0(24);
        }
        if (moduleGradlePath == null) {
            BuildVariantUpdater.$$$reportNull$$$0(25);
        }
        if (variant == null) {
            BuildVariantUpdater.$$$reportNull$$$0(26);
        }
        if (affectedFacets == null) {
            BuildVariantUpdater.$$$reportNull$$$0(27);
        }
        if ((module = GradleUtil.findModuleByGradlePath(project, moduleGradlePath)) == null) {
            BuildVariantUpdater.logAndShowUpdateFailure(variant, String.format("Cannot find module with Gradle path '%1$s'.", moduleGradlePath));
            return;
        }
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet == null) {
            BuildVariantUpdater.logAndShowUpdateFailure(variant, String.format("Cannot find 'Android' facet in module '%1$s'.", module.getName()));
            return;
        }
        AndroidModuleModel androidModel = BuildVariantUpdater.getAndroidModel(facet, variant);
        if (androidModel == null) {
            return;
        }
        if (!this.updateSelectedVariant(facet, androidModel, variant, affectedFacets)) {
            return;
        }
        affectedFacets.add(facet);
    }

    @Nullable
    private static AndroidModuleModel getAndroidModel(@NotNull AndroidFacet facet, @NotNull String variantToSelect) {
        AndroidModuleModel androidModel;
        if (facet == null) {
            BuildVariantUpdater.$$$reportNull$$$0(28);
        }
        if (variantToSelect == null) {
            BuildVariantUpdater.$$$reportNull$$$0(29);
        }
        if ((androidModel = AndroidModuleModel.get(facet)) == null) {
            BuildVariantUpdater.logAndShowUpdateFailure(variantToSelect, String.format("Cannot find AndroidProject for module '%1$s'.", facet.getModule().getName()));
        }
        return androidModel;
    }

    @Nullable
    private static NdkModuleModel getNativeAndroidModel(@NotNull NdkFacet facet, @NotNull String variantToSelect) {
        NdkModuleModel ndkModuleModel;
        if (facet == null) {
            BuildVariantUpdater.$$$reportNull$$$0(30);
        }
        if (variantToSelect == null) {
            BuildVariantUpdater.$$$reportNull$$$0(31);
        }
        if ((ndkModuleModel = NdkModuleModel.get(facet)) == null) {
            BuildVariantUpdater.logAndShowUpdateFailure(variantToSelect, String.format("Cannot find NativeAndroidProject for module '%1$s'.", facet.getModule().getName()));
        }
        return ndkModuleModel;
    }

    private static void logAndShowUpdateFailure(@NotNull String buildVariantName, @NotNull String reason) {
        if (buildVariantName == null) {
            BuildVariantUpdater.$$$reportNull$$$0(32);
        }
        if (reason == null) {
            BuildVariantUpdater.$$$reportNull$$$0(33);
        }
        String prefix = String.format("Unable to select build variant '%1$s':\n", buildVariantName);
        String msg = prefix + reason;
        LOG.error(msg);
        msg = msg + ".\n\nConsult IDE log for more details (Help | Show Log)";
        Messages.showErrorDialog((String)msg, (String)"Error");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 20: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 20: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 9: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 2: 
            case 32: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildVariantName";
                break;
            }
            case 5: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variant";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "affectedAndroidFacets";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "affectedNativeAndroidFacets";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidFacet";
                break;
            }
            case 11: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidModel";
                break;
            }
            case 12: 
            case 16: 
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variantToSelect";
                break;
            }
            case 13: 
            case 17: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "affectedFacets";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ndkFacet";
                break;
            }
            case 15: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ndkModuleModel";
                break;
            }
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleGradlePath";
                break;
            }
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/variant/view/BuildVariantUpdater";
                break;
            }
            case 20: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "setUpModule";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "updateSelectedVariant";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doUpdate";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findModule";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "generateSourcesIfNeeded";
                break;
            }
            case 18: 
            case 19: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "setUpModule";
                break;
            }
            case 20: 
            case 23: {
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "ensureVariantIsSelected";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getAndroidModel";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getNativeAndroidModel";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "logAndShowUpdateFailure";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "lambda$updateSelectedVariant$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 20: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

