/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.variant.conflict;

import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.variant.conflict.Conflict;
import com.android.tools.idea.gradle.variant.conflict.ConflictResolutionDialog;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public final class ConflictResolution {
    private ConflictResolution() {
    }

    public static boolean solveSelectionConflicts(@NotNull Collection<Conflict> conflicts) {
        if (conflicts == null) {
            ConflictResolution.$$$reportNull$$$0(0);
        }
        boolean atLeastOneSolved = false;
        for (Conflict conflict : conflicts) {
            if (!ConflictResolution.solveSelectionConflict(conflict, false)) continue;
            atLeastOneSolved = true;
        }
        return atLeastOneSolved;
    }

    public static boolean solveSelectionConflict(@NotNull Conflict conflict) {
        if (conflict == null) {
            ConflictResolution.$$$reportNull$$$0(1);
        }
        return ConflictResolution.solveSelectionConflict(conflict, true);
    }

    private static boolean solveSelectionConflict(@NotNull Conflict conflict, boolean showConflictResolutionDialog) {
        String selectedVariant;
        ConflictResolutionDialog dialog;
        AndroidFacet facet;
        if (conflict == null) {
            ConflictResolution.$$$reportNull$$$0(2);
        }
        if ((facet = AndroidFacet.getInstance(conflict.getSource())) == null || !facet.requiresAndroidModel()) {
            return true;
        }
        AndroidModuleModel source = AndroidModuleModel.get(facet);
        if (source == null) {
            return false;
        }
        Collection<String> variants = conflict.getVariants();
        if (variants.size() == 1) {
            String expectedVariant = (String)ContainerUtil.getFirstItem(variants);
            if (StringUtil.isNotEmpty((String)expectedVariant)) {
                source.setSelectedVariantName(expectedVariant);
                source.syncSelectedVariantAndTestArtifact(facet);
                return true;
            }
        } else if (showConflictResolutionDialog && (dialog = new ConflictResolutionDialog(conflict)).showAndGet() && StringUtil.isNotEmpty((String)(selectedVariant = dialog.getSelectedVariant()))) {
            source.setSelectedVariantName(selectedVariant);
            source.syncSelectedVariantAndTestArtifact(facet);
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflicts";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflict";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/gradle/variant/conflict/ConflictResolution";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "solveSelectionConflicts";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "solveSelectionConflict";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

