/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.util;

import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.io.File;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FilePaths {
    private FilePaths() {
    }

    @Nullable
    public static ContentEntry findParentContentEntry(@NotNull File path, @NotNull ContentEntry[] contentEntries) {
        if (path == null) {
            FilePaths.$$$reportNull$$$0(0);
        }
        if (contentEntries == null) {
            FilePaths.$$$reportNull$$$0(1);
        }
        for (ContentEntry contentEntry : contentEntries) {
            if (!FilePaths.isPathInContentEntry(path, contentEntry)) continue;
            return contentEntry;
        }
        return null;
    }

    @Nullable
    public static ContentEntry findParentContentEntry(@NotNull File path, @NotNull Collection<ContentEntry> contentEntries) {
        if (path == null) {
            FilePaths.$$$reportNull$$$0(2);
        }
        if (contentEntries == null) {
            FilePaths.$$$reportNull$$$0(3);
        }
        for (ContentEntry contentEntry : contentEntries) {
            if (!FilePaths.isPathInContentEntry(path, contentEntry)) continue;
            return contentEntry;
        }
        return null;
    }

    public static boolean isPathInContentEntry(@NotNull File path, @NotNull ContentEntry contentEntry) {
        File rootFilePath;
        VirtualFile rootFile;
        if (path == null) {
            FilePaths.$$$reportNull$$$0(4);
        }
        if (contentEntry == null) {
            FilePaths.$$$reportNull$$$0(5);
        }
        if ((rootFile = contentEntry.getFile()) == null) {
            String s = VfsUtilCore.urlToPath((String)contentEntry.getUrl());
            rootFilePath = new File(s);
        } else {
            rootFilePath = VfsUtilCore.virtualToIoFile((VirtualFile)rootFile);
        }
        return FileUtil.isAncestor((File)rootFilePath, (File)path, (boolean)false);
    }

    @NotNull
    public static String pathToIdeaUrl(@NotNull File path) {
        if (path == null) {
            FilePaths.$$$reportNull$$$0(6);
        }
        String string = FilePaths.pathToUrl(FileUtil.toSystemIndependentName((String)path.getPath()));
        if (string == null) {
            FilePaths.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public static String pathToUrl(@NotNull String path) {
        File file;
        String name;
        if (path == null) {
            FilePaths.$$$reportNull$$$0(8);
        }
        boolean isJarFile = FileUtil.extensionEquals((String)(name = (file = new File(path)).getName()), (String)"jar") || FileUtil.extensionEquals((String)name, (String)"zip");
        String protocol = isJarFile ? "jar" : "file";
        String url = VirtualFileManager.constructUrl((String)protocol, (String)FileUtil.toSystemIndependentName((String)file.getPath()));
        if (isJarFile) {
            url = url + "!/";
        }
        String string = url;
        if (string == null) {
            FilePaths.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Nullable
    public static File getJarFromJarUrl(@NotNull String url) {
        if (url == null) {
            FilePaths.$$$reportNull$$$0(10);
        }
        if (!url.startsWith("jar://")) {
            return null;
        }
        String path = url.substring("jar://".length());
        int index = path.lastIndexOf("!/");
        if (index != -1) {
            path = path.substring(0, index);
        }
        return new File(FileUtil.toSystemDependentName((String)path));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentEntries";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentEntry";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/util/FilePaths";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/util/FilePaths";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "pathToIdeaUrl";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "pathToUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findParentContentEntry";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isPathInContentEntry";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "pathToIdeaUrl";
                break;
            }
            case 7: 
            case 9: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "pathToUrl";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getJarFromJarUrl";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

