/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.util;

import com.google.common.collect.ImmutableList;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EmbeddedDistributionPaths {
    @NotNull
    public static EmbeddedDistributionPaths getInstance() {
        EmbeddedDistributionPaths embeddedDistributionPaths = (EmbeddedDistributionPaths)ServiceManager.getService(EmbeddedDistributionPaths.class);
        if (embeddedDistributionPaths == null) {
            EmbeddedDistributionPaths.$$$reportNull$$$0(0);
        }
        return embeddedDistributionPaths;
    }

    @NotNull
    public List<File> findAndroidStudioLocalMavenRepoPaths() {
        String relativePath;
        File repoPath;
        File defaultRootDirPath = EmbeddedDistributionPaths.getDefaultRootDirPath();
        if (defaultRootDirPath != null) {
            File repoPath2 = new File(defaultRootDirPath, "m2repository");
            ImmutableList immutableList = repoPath2.isDirectory() ? ImmutableList.of((Object)repoPath2) : ImmutableList.of();
            if (immutableList == null) {
                EmbeddedDistributionPaths.$$$reportNull$$$0(1);
            }
            return immutableList;
        }
        ArrayList<File> repoPaths = new ArrayList<File>();
        String studioCustomRepo = System.getenv("STUDIO_CUSTOM_REPO");
        if (studioCustomRepo != null) {
            repoPath = new File(FileUtil.toCanonicalPath((String)FileUtil.toSystemDependentName((String)studioCustomRepo)));
            if (!repoPath.isDirectory()) {
                throw new IllegalArgumentException("Invalid path in STUDIO_CUSTOM_REPO environment variable");
            }
        } else {
            relativePath = FileUtil.toSystemDependentName((String)"/../../prebuilts/tools/common/offline-m2");
            repoPath = new File(FileUtil.toCanonicalPath((String)(EmbeddedDistributionPaths.getIdeHomePath() + relativePath)));
        }
        EmbeddedDistributionPaths.getLog().info("Looking for embedded Maven repo at '" + repoPath.getPath() + "'");
        if (repoPath.isDirectory()) {
            repoPaths.add(repoPath);
        }
        relativePath = FileUtil.toSystemDependentName((String)"/../../out/studio/repo");
        repoPath = new File(PathManager.getHomePath() + relativePath);
        if (repoPath.isDirectory()) {
            repoPaths.add(repoPath);
        }
        ArrayList<File> arrayList = repoPaths;
        if (arrayList == null) {
            EmbeddedDistributionPaths.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @Nullable
    public File findEmbeddedGradleDistributionPath() {
        File distributionPath = EmbeddedDistributionPaths.getDefaultRootDirPath();
        if (distributionPath != null) {
            Logger log = EmbeddedDistributionPaths.getLog();
            File embeddedPath = new File(distributionPath, "gradle-3.3");
            log.info("Looking for embedded Gradle distribution at '" + embeddedPath.getPath() + "'");
            if (embeddedPath.isDirectory()) {
                log.info("Found embedded Gradle 3.3");
                return embeddedPath;
            }
            log.info("Unable to find embedded Gradle 3.3");
            return null;
        }
        String ideHomePath = EmbeddedDistributionPaths.getIdeHomePath();
        String relativePath = FileUtil.toSystemDependentName((String)"/../../out/gradle-dist-link");
        distributionPath = new File(FileUtil.toCanonicalPath((String)(ideHomePath + relativePath)));
        return distributionPath.isDirectory() ? distributionPath : null;
    }

    @NotNull
    private static Logger getLog() {
        Logger logger = Logger.getInstance(EmbeddedDistributionPaths.class);
        if (logger == null) {
            EmbeddedDistributionPaths.$$$reportNull$$$0(3);
        }
        return logger;
    }

    @Nullable
    private static File getDefaultRootDirPath() {
        String ideHomePath = EmbeddedDistributionPaths.getIdeHomePath();
        File rootDirPath = new File(ideHomePath, "gradle");
        return rootDirPath.isDirectory() ? rootDirPath : null;
    }

    @Nullable
    public File getEmbeddedJdkPath() {
        String ideHomePath = EmbeddedDistributionPaths.getIdeHomePath();
        File jdkRootPath = new File(ideHomePath, SystemInfo.isMac ? FileUtil.join((String[])new String[]{"jre", "jdk"}) : "jre");
        if (jdkRootPath.isDirectory()) {
            return EmbeddedDistributionPaths.getSystemSpecificJdkPath(jdkRootPath);
        }
        if (System.getProperty("android.test.embedded.jdk") != null) {
            File jdkDir = new File(System.getProperty("android.test.embedded.jdk"));
            assert (jdkDir.exists());
            return jdkDir;
        }
        String jdkDevPath = System.getProperty("studio.dev.jdk", ideHomePath + "/../../prebuilts/studio/jdk");
        String relativePath = FileUtil.toSystemDependentName((String)jdkDevPath);
        jdkRootPath = new File(FileUtil.toCanonicalPath((String)relativePath));
        if (SystemInfo.isWindows) {
            jdkRootPath = new File(jdkRootPath, "win64");
        } else if (SystemInfo.isLinux) {
            jdkRootPath = new File(jdkRootPath, "linux");
        } else if (SystemInfo.isMac) {
            jdkRootPath = new File(jdkRootPath, "mac");
        }
        return EmbeddedDistributionPaths.getSystemSpecificJdkPath(jdkRootPath);
    }

    @Nullable
    private static File getSystemSpecificJdkPath(File jdkRootPath) {
        if (SystemInfo.isMac) {
            jdkRootPath = new File(jdkRootPath, "/Contents/Home");
        }
        if (jdkRootPath.isDirectory()) {
            return jdkRootPath;
        }
        return null;
    }

    @NotNull
    private static String getIdeHomePath() {
        String string = FileUtil.toSystemDependentName((String)PathManager.getHomePath());
        if (string == null) {
            EmbeddedDistributionPaths.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/android/tools/idea/gradle/util/EmbeddedDistributionPaths";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findAndroidStudioLocalMavenRepoPaths";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLog";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdeHomePath";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

